/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ClusterNodes;
import io.imply.cloud.model.DataTierInfo;
import io.imply.cloud.model.Host;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.NodeConfiguration;
import io.imply.cloud.model.Stage;
import io.imply.cloud.model.UpdateSubtype;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.builder.DiffResult;

public class PlanUpdateState {
    private final Account account;
    private Map<String, ImplyNodeType> autoScalingGroups;
    private String coordinatorDynamicConfiguration;
    private boolean coordinatorDynamicConfigurationModified;
    private Map<ImplyNodeType, DataTierInfo> dataTierInfoMap;
    private Set<ImplyNodeType> currentTiers;
    private Set<ImplyNodeType> desiredTiers;
    private final DiffResult<Cluster> clusterDiffs;
    private final ClusterNodes diffClusterNodes;
    private final Cluster endingCluster;
    private final ClusterNodes endingClusterNodes;
    private boolean fullMasterReplacement;
    private boolean fullQueryReplacement;
    private boolean fullPeonReplacement;
    private boolean fullColdTierDataReplacement;
    private boolean fullColdTierQueryReplacement;
    private Map<ImplyNodeType, List<Host>> hosts;
    private Set<String> hostsAlreadyUpdated = new HashSet<String>();
    private List<String> masterAutoScalingGroups;
    private String coldTierQueryAutoScalingGroup;
    private String coldTierDataAutoScalingGroup;
    private Set<String> masterHostAddresses;
    private List<Host> middleManagersToEnable;
    private Deque<Stage> pendingRollingStages;
    private final boolean performingRollback;
    private String queryAutoScalingGroup;
    private final Cluster startingCluster;
    private final ClusterNodes startingClusterNodes;
    private final UpdateSubtype updateSubtype;

    public PlanUpdateState(UpdateSubtype updateSubtype, Cluster startingCluster, Cluster endingCluster, ClusterNodes startingClusterNodes, ClusterNodes endingClusterNodes, Map<ImplyNodeType, DataTierInfo> dataTierInfoMap, Account account, boolean performingRollback) {
        this.account = account;
        this.endingCluster = endingCluster;
        this.endingClusterNodes = endingClusterNodes;
        this.performingRollback = performingRollback;
        this.startingCluster = startingCluster;
        this.startingClusterNodes = startingClusterNodes;
        this.updateSubtype = updateSubtype;
        this.dataTierInfoMap = dataTierInfoMap;
        this.clusterDiffs = startingCluster.diff(endingCluster);
        this.diffClusterNodes = startingClusterNodes == null || endingClusterNodes == null ? ClusterNodes.empty() : endingClusterNodes.mergeDiff(startingClusterNodes);
    }

    public boolean isSpecUpdate() {
        return UpdateSubtype.CLUSTER_SPEC.equals((Object)this.updateSubtype);
    }

    public boolean isNodeListUpdate() {
        return UpdateSubtype.CLUSTER_NODE_LIST.equals((Object)this.updateSubtype);
    }

    public String getClusterId() {
        return this.startingCluster != null && this.startingCluster.getClusterId() != null ? this.startingCluster.getClusterId() : (this.endingCluster != null ? this.endingCluster.getClusterId() : null);
    }

    public Integer getQueryCountDelta() {
        if (this.endingCluster == null || this.endingCluster.getQueryInstanceCount() == null || this.startingCluster == null || this.startingCluster.getQueryInstanceCount() == null) {
            return null;
        }
        return this.endingCluster.getQueryInstanceCount() - this.startingCluster.getQueryInstanceCount();
    }

    public Map<String, NodeConfiguration> getFilteredStartingClusterNodes() {
        if (this.startingClusterNodes == null || this.startingClusterNodes.getNodes() == null) {
            return ImmutableMap.of();
        }
        return this.startingClusterNodes.getNodes().entrySet().stream().filter(x -> x.getValue() != null && ((NodeConfiguration)x.getValue()).getNodeTypes() != null && !((NodeConfiguration)x.getValue()).getNodeTypes().isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<String, NodeConfiguration> getFilteredEndingClusterNodes() {
        if (this.endingClusterNodes == null || this.endingClusterNodes.getNodes() == null) {
            return ImmutableMap.of();
        }
        return this.endingClusterNodes.getNodes().entrySet().stream().filter(x -> x.getValue() != null && ((NodeConfiguration)x.getValue()).getNodeTypes() != null && !((NodeConfiguration)x.getValue()).getNodeTypes().isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public void setAllNodeTypesReplacement(boolean replace) {
        this.fullPeonReplacement = replace;
        this.setAllNonPeonNodeTypesReplacement(true);
    }

    public void setAllNonPeonNodeTypesReplacement(boolean replace) {
        this.dataTierInfoMap.values().forEach(dataTier -> dataTier.setFullReplacement(replace));
        this.fullMasterReplacement = replace;
        this.fullQueryReplacement = replace;
        this.fullColdTierDataReplacement = replace;
        this.fullColdTierQueryReplacement = replace;
    }

    public void validateComplete() {
        Preconditions.checkState((this.pendingRollingStages != null ? 1 : 0) != 0, (Object)"[pendingRollingStages] not set");
    }

    @Generated
    public Account getAccount() {
        return this.account;
    }

    @Generated
    public Map<String, ImplyNodeType> getAutoScalingGroups() {
        return this.autoScalingGroups;
    }

    @Generated
    public String getCoordinatorDynamicConfiguration() {
        return this.coordinatorDynamicConfiguration;
    }

    @Generated
    public boolean isCoordinatorDynamicConfigurationModified() {
        return this.coordinatorDynamicConfigurationModified;
    }

    @Generated
    public Map<ImplyNodeType, DataTierInfo> getDataTierInfoMap() {
        return this.dataTierInfoMap;
    }

    @Generated
    public Set<ImplyNodeType> getCurrentTiers() {
        return this.currentTiers;
    }

    @Generated
    public Set<ImplyNodeType> getDesiredTiers() {
        return this.desiredTiers;
    }

    @Generated
    public DiffResult<Cluster> getClusterDiffs() {
        return this.clusterDiffs;
    }

    @Generated
    public ClusterNodes getDiffClusterNodes() {
        return this.diffClusterNodes;
    }

    @Generated
    public Cluster getEndingCluster() {
        return this.endingCluster;
    }

    @Generated
    public ClusterNodes getEndingClusterNodes() {
        return this.endingClusterNodes;
    }

    @Generated
    public boolean isFullMasterReplacement() {
        return this.fullMasterReplacement;
    }

    @Generated
    public boolean isFullQueryReplacement() {
        return this.fullQueryReplacement;
    }

    @Generated
    public boolean isFullPeonReplacement() {
        return this.fullPeonReplacement;
    }

    @Generated
    public boolean isFullColdTierDataReplacement() {
        return this.fullColdTierDataReplacement;
    }

    @Generated
    public boolean isFullColdTierQueryReplacement() {
        return this.fullColdTierQueryReplacement;
    }

    @Generated
    public Map<ImplyNodeType, List<Host>> getHosts() {
        return this.hosts;
    }

    @Generated
    public Set<String> getHostsAlreadyUpdated() {
        return this.hostsAlreadyUpdated;
    }

    @Generated
    public List<String> getMasterAutoScalingGroups() {
        return this.masterAutoScalingGroups;
    }

    @Generated
    public String getColdTierQueryAutoScalingGroup() {
        return this.coldTierQueryAutoScalingGroup;
    }

    @Generated
    public String getColdTierDataAutoScalingGroup() {
        return this.coldTierDataAutoScalingGroup;
    }

    @Generated
    public Set<String> getMasterHostAddresses() {
        return this.masterHostAddresses;
    }

    @Generated
    public List<Host> getMiddleManagersToEnable() {
        return this.middleManagersToEnable;
    }

    @Generated
    public Deque<Stage> getPendingRollingStages() {
        return this.pendingRollingStages;
    }

    @Generated
    public boolean isPerformingRollback() {
        return this.performingRollback;
    }

    @Generated
    public String getQueryAutoScalingGroup() {
        return this.queryAutoScalingGroup;
    }

    @Generated
    public Cluster getStartingCluster() {
        return this.startingCluster;
    }

    @Generated
    public ClusterNodes getStartingClusterNodes() {
        return this.startingClusterNodes;
    }

    @Generated
    public UpdateSubtype getUpdateSubtype() {
        return this.updateSubtype;
    }

    @Generated
    public void setAutoScalingGroups(Map<String, ImplyNodeType> autoScalingGroups) {
        this.autoScalingGroups = autoScalingGroups;
    }

    @Generated
    public void setCoordinatorDynamicConfiguration(String coordinatorDynamicConfiguration) {
        this.coordinatorDynamicConfiguration = coordinatorDynamicConfiguration;
    }

    @Generated
    public void setCoordinatorDynamicConfigurationModified(boolean coordinatorDynamicConfigurationModified) {
        this.coordinatorDynamicConfigurationModified = coordinatorDynamicConfigurationModified;
    }

    @Generated
    public void setDataTierInfoMap(Map<ImplyNodeType, DataTierInfo> dataTierInfoMap) {
        this.dataTierInfoMap = dataTierInfoMap;
    }

    @Generated
    public void setCurrentTiers(Set<ImplyNodeType> currentTiers) {
        this.currentTiers = currentTiers;
    }

    @Generated
    public void setDesiredTiers(Set<ImplyNodeType> desiredTiers) {
        this.desiredTiers = desiredTiers;
    }

    @Generated
    public void setFullMasterReplacement(boolean fullMasterReplacement) {
        this.fullMasterReplacement = fullMasterReplacement;
    }

    @Generated
    public void setFullQueryReplacement(boolean fullQueryReplacement) {
        this.fullQueryReplacement = fullQueryReplacement;
    }

    @Generated
    public void setFullPeonReplacement(boolean fullPeonReplacement) {
        this.fullPeonReplacement = fullPeonReplacement;
    }

    @Generated
    public void setFullColdTierDataReplacement(boolean fullColdTierDataReplacement) {
        this.fullColdTierDataReplacement = fullColdTierDataReplacement;
    }

    @Generated
    public void setFullColdTierQueryReplacement(boolean fullColdTierQueryReplacement) {
        this.fullColdTierQueryReplacement = fullColdTierQueryReplacement;
    }

    @Generated
    public void setHosts(Map<ImplyNodeType, List<Host>> hosts) {
        this.hosts = hosts;
    }

    @Generated
    public void setHostsAlreadyUpdated(Set<String> hostsAlreadyUpdated) {
        this.hostsAlreadyUpdated = hostsAlreadyUpdated;
    }

    @Generated
    public void setMasterAutoScalingGroups(List<String> masterAutoScalingGroups) {
        this.masterAutoScalingGroups = masterAutoScalingGroups;
    }

    @Generated
    public void setColdTierQueryAutoScalingGroup(String coldTierQueryAutoScalingGroup) {
        this.coldTierQueryAutoScalingGroup = coldTierQueryAutoScalingGroup;
    }

    @Generated
    public void setColdTierDataAutoScalingGroup(String coldTierDataAutoScalingGroup) {
        this.coldTierDataAutoScalingGroup = coldTierDataAutoScalingGroup;
    }

    @Generated
    public void setMasterHostAddresses(Set<String> masterHostAddresses) {
        this.masterHostAddresses = masterHostAddresses;
    }

    @Generated
    public void setMiddleManagersToEnable(List<Host> middleManagersToEnable) {
        this.middleManagersToEnable = middleManagersToEnable;
    }

    @Generated
    public void setPendingRollingStages(Deque<Stage> pendingRollingStages) {
        this.pendingRollingStages = pendingRollingStages;
    }

    @Generated
    public void setQueryAutoScalingGroup(String queryAutoScalingGroup) {
        this.queryAutoScalingGroup = queryAutoScalingGroup;
    }
}

