/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.model.ComparableVersion;
import io.imply.cloud.model.ImplyVersion;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Comparator;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PivotConfiguration {
    private final ComparableVersion minImplyVersion;
    private final Map<String, Object> config;

    @JsonCreator
    public PivotConfiguration(@JsonProperty(value="minImplyVersion") ComparableVersion minImplyVersion, @JsonProperty(value="config") Map<String, Object> config) {
        this.minImplyVersion = minImplyVersion;
        this.config = config;
    }

    @JsonProperty
    public ComparableVersion getMinImplyVersion() {
        return this.minImplyVersion;
    }

    @JsonProperty
    public Map<String, Object> getConfig() {
        return this.config;
    }

    public String toString() {
        return new ToStringBuilder(this).append("minImplyVersion", this.minImplyVersion).append("config", this.config).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PivotConfiguration that = (PivotConfiguration)o;
        if (this.minImplyVersion != null ? !this.minImplyVersion.equals(that.minImplyVersion) : that.minImplyVersion != null) {
            return false;
        }
        return !(this.config == null ? that.config != null : !this.config.equals(that.config));
    }

    public int hashCode() {
        int result = this.minImplyVersion != null ? this.minImplyVersion.hashCode() : 0;
        result = 31 * result + (this.config != null ? this.config.hashCode() : 0);
        return result;
    }

    public static PivotConfiguration getForImplyVersion(ImplyVersion version, RefreshableConstants refreshableConstants) {
        return version == null || version.getComparableVersion() == null ? null : (PivotConfiguration)refreshableConstants.getPivotConfigurations().stream().sorted(Comparator.comparing(PivotConfiguration::getMinImplyVersion).reversed()).filter(x -> version.getComparableVersion().compareTo(x.getMinImplyVersion()) >= 0).findFirst().orElse(null);
    }
}

