/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import io.imply.cloud.config.OtelCollectorConfig;
import io.imply.cloud.model.ImplyConstraintViolation;
import io.imply.cloud.model.Mergeable;
import io.imply.cloud.util.DiffUtils;
import io.imply.cloud.util.ToStringBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.DiffBuilder;
import org.apache.commons.lang3.builder.DiffResult;
import org.apache.commons.lang3.builder.Diffable;
import org.apache.commons.lang3.builder.ReflectionDiffBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OtelCollector
implements Mergeable<OtelCollector>,
Diffable<OtelCollector> {
    @JsonProperty(value="apiKey")
    private final String apiKey;
    @JsonProperty(value="hecEndpoint")
    private final String hecEndpoint;

    public OtelCollector withSensitiveFieldsMasked() {
        return this.toBuilder().apiKey(this.apiKey != null ? "{secret}" : null).build();
    }

    public OtelCollector withSensitiveFieldPlaceholdersRemoved() {
        return this.toBuilder().apiKey("{secret}".equals(this.apiKey) ? null : this.apiKey).build();
    }

    public String toString() {
        return new ToStringBuilder(this).append("apiKey", this.apiKey).append("hecEndpoint", (Object)this.hecEndpoint).toString();
    }

    public static OtelCollector getDefaultConfig(OtelCollectorConfig otelCollectorConfig) {
        if (otelCollectorConfig == null || otelCollectorConfig.getHecEndpoint() == null) {
            return null;
        }
        return OtelCollector.builder().hecEndpoint(otelCollectorConfig.getHecEndpoint()).build();
    }

    public boolean isValid() {
        return !Strings.isNullOrEmpty((String)this.hecEndpoint);
    }

    public void validate(List<ImplyConstraintViolation> results) {
        if (StringUtils.isNotBlank((CharSequence)this.hecEndpoint)) {
            try {
                URI uri = new URI(this.hecEndpoint);
                if (!"https".equals(uri.getScheme())) {
                    throw new URISyntaxException(this.hecEndpoint, "Invalid scheme");
                }
                if (uri.getHost() == null) {
                    throw new URISyntaxException(this.hecEndpoint, "Missing host");
                }
            }
            catch (URISyntaxException e) {
                results.add(ImplyConstraintViolation.error("otelCollector.hecEndpoint", "[otelCollector.hecEndpoint] is not valid: " + e.getMessage(), new Object[0]));
            }
        }
    }

    public OtelCollector merge(OtelCollector other) {
        if (other == null) {
            return this;
        }
        return OtelCollector.builder().apiKey((String)ObjectUtils.defaultIfNull((Object)other.apiKey, (Object)this.apiKey)).hecEndpoint((String)ObjectUtils.defaultIfNull((Object)other.hecEndpoint, (Object)this.hecEndpoint)).build();
    }

    @Override
    public OtelCollector mergeDiff(OtelCollector other) {
        if (other == null) {
            return this;
        }
        return new Builder().apiKey(DiffUtils.nullIf(this.apiKey, other.apiKey)).hecEndpoint(DiffUtils.nullIf(this.hecEndpoint, other.hecEndpoint)).build();
    }

    public DiffResult<OtelCollector> diff(OtelCollector other) {
        return ReflectionDiffBuilder.builder().setDiffBuilder(DiffBuilder.builder().setLeft((Object)this).setRight((Object)other).setStyle(ToStringStyle.SHORT_PREFIX_STYLE).build()).build().build();
    }

    public OtelCollector filterNonNullFields(OtelCollector filter) {
        if (filter == null) {
            return new OtelCollector();
        }
        return OtelCollector.builder().apiKey(filter.apiKey == null ? null : this.apiKey).hecEndpoint(filter.hecEndpoint == null ? null : this.hecEndpoint).build();
    }

    @Override
    public boolean isEmpty() {
        return this.apiKey == null && this.hecEndpoint == null;
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Builder toBuilder() {
        return new Builder().apiKey(this.apiKey).hecEndpoint(this.hecEndpoint);
    }

    @Generated
    public String getApiKey() {
        return this.apiKey;
    }

    @Generated
    public String getHecEndpoint() {
        return this.hecEndpoint;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OtelCollector)) {
            return false;
        }
        OtelCollector other = (OtelCollector)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$apiKey = this.getApiKey();
        String other$apiKey = other.getApiKey();
        if (this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey)) {
            return false;
        }
        String this$hecEndpoint = this.getHecEndpoint();
        String other$hecEndpoint = other.getHecEndpoint();
        return !(this$hecEndpoint == null ? other$hecEndpoint != null : !this$hecEndpoint.equals(other$hecEndpoint));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OtelCollector;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $apiKey = this.getApiKey();
        result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
        String $hecEndpoint = this.getHecEndpoint();
        result = result * 59 + ($hecEndpoint == null ? 43 : $hecEndpoint.hashCode());
        return result;
    }

    @Generated
    private OtelCollector() {
        this.apiKey = null;
        this.hecEndpoint = null;
    }

    @Generated
    public OtelCollector(String apiKey, String hecEndpoint) {
        this.apiKey = apiKey;
        this.hecEndpoint = hecEndpoint;
    }

    @Generated
    public static class Builder {
        @Generated
        private String apiKey;
        @Generated
        private String hecEndpoint;

        @Generated
        Builder() {
        }

        @JsonProperty(value="apiKey")
        @Generated
        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @JsonProperty(value="hecEndpoint")
        @Generated
        public Builder hecEndpoint(String hecEndpoint) {
            this.hecEndpoint = hecEndpoint;
            return this;
        }

        @Generated
        public OtelCollector build() {
            return new OtelCollector(this.apiKey, this.hecEndpoint);
        }

        @Generated
        public String toString() {
            return "OtelCollector.Builder(apiKey=" + this.apiKey + ", hecEndpoint=" + this.hecEndpoint + ")";
        }
    }
}

