/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Iterables;
import io.imply.cloud.model.Notification;
import io.imply.cloud.model.Status;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Notifications {
    private final String entityKey;
    private final List<Notification> notifications;

    @JsonCreator
    public Notifications(@JsonProperty(value="entityKey") String entityKey, @JsonProperty(value="notifications") List<Notification> notifications) {
        this.entityKey = entityKey;
        this.notifications = notifications != null ? new ArrayList<Notification>(notifications) : new ArrayList();
    }

    public Notifications(String entityKey) {
        this(entityKey, null);
    }

    public Notifications() {
        this(null);
    }

    @JsonProperty(value="notifications")
    public List<Notification> getNotificationList() {
        Collections.sort(this.notifications, Comparator.comparing(Notification::getTimestamp).reversed());
        return this.notifications;
    }

    @JsonProperty
    public String getEntityKey() {
        if (this.entityKey != null) {
            return this.entityKey;
        }
        Set entityIds = this.notifications.stream().map(Notification::getEntityKey).collect(Collectors.toSet());
        return entityIds.size() == 1 ? (String)Iterables.getOnlyElement(entityIds) : null;
    }

    public Notifications addNotification(Notification notification) {
        Notification existingNotification = this.getSimilar(notification);
        if (existingNotification == null) {
            this.notifications.add(notification);
        } else {
            if (notification.getTimestamp() != null) {
                existingNotification.setTimestamp(notification.getTimestamp());
            }
            if (notification.getRelevance() != null) {
                existingNotification.setRelevance(notification.getRelevance());
            }
        }
        return this;
    }

    public Notifications addNotifications(List<Notification> notifications) {
        notifications.forEach(this::addNotification);
        return this;
    }

    public Notifications addNotifications(Notifications notifications) {
        return notifications == null ? this : this.addNotifications(notifications.notifications);
    }

    public Notifications merge(Notifications partialRecord) {
        if (partialRecord == null) {
            return this;
        }
        String entityKey = partialRecord.entityKey != null ? partialRecord.entityKey : this.entityKey;
        Notifications mergedNotifications = new Notifications(entityKey, this.notifications);
        partialRecord.notifications.forEach(mergedNotifications::addNotification);
        return mergedNotifications;
    }

    public Notifications stripInternalFields() {
        List<Notification> notifications = this.notifications.stream().map(x -> new Notification(null, x.getMessage(), x.getDetailedMessage(), x.getLevel(), x.getTimestamp(), x.getSource(), x.getRelevance(), null)).collect(Collectors.toList());
        return new Notifications(this.entityKey, notifications);
    }

    public Status getStatusFromNotifications() {
        Set levels = this.notifications.stream().filter(x -> Notification.Relevance.CURRENT.equals((Object)x.getRelevance())).map(Notification::getLevel).collect(Collectors.toSet());
        if (levels.contains((Object)Notification.Level.CRITICAL)) {
            return Status.CRITICAL;
        }
        if (levels.contains((Object)Notification.Level.WARNING)) {
            return Status.WARNING;
        }
        return Status.OK;
    }

    public Notification getSimilar(Notification notification) {
        return this.notifications.stream().filter(x -> x.equalsIgnoreTimestampAndRelevance(notification)).findFirst().orElse(null);
    }
}

