/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;
import org.joda.time.DateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Notification {
    private final String key;
    private final String message;
    private final String detailedMessage;
    private final Level level;
    private final Source source;
    private final String entityKey;
    private DateTime timestamp;
    private Relevance relevance;

    @JsonCreator
    Notification(@JsonProperty(value="key") String key, @JsonProperty(value="message") String message, @JsonProperty(value="detailedMessage") String detailedMessage, @JsonProperty(value="level") Level level, @JsonProperty(value="timestamp") DateTime timestamp, @JsonProperty(value="source") Source source, @JsonProperty(value="relevance") Relevance relevance, @JsonProperty(value="entityKey") String entityKey) {
        this.key = key;
        this.message = message;
        this.detailedMessage = detailedMessage;
        this.level = level;
        this.timestamp = timestamp;
        this.source = source;
        this.relevance = relevance;
        this.entityKey = entityKey;
    }

    private Notification(String message, String detailedMessage, Level level, DateTime timestamp, Source source, Relevance relevance, String entityKey) {
        this.message = message;
        this.detailedMessage = detailedMessage;
        this.level = level;
        this.timestamp = timestamp;
        this.source = source;
        this.relevance = relevance;
        this.entityKey = (String)Preconditions.checkNotNull((Object)entityKey);
        this.key = this.generateKey();
    }

    private String generateKey() {
        return DigestUtils.sha1Hex((String)this.toStringWithoutTimestampAndRelevance()).substring(0, 31);
    }

    @JsonProperty
    public String getKey() {
        return this.key;
    }

    @JsonProperty
    public String getMessage() {
        return this.message;
    }

    @JsonProperty
    public String getDetailedMessage() {
        return this.detailedMessage;
    }

    @JsonProperty
    public Level getLevel() {
        return this.level;
    }

    @JsonProperty
    public DateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(DateTime timestamp) {
        this.timestamp = timestamp;
    }

    @JsonProperty
    public Source getSource() {
        return this.source;
    }

    @JsonProperty
    public Relevance getRelevance() {
        return this.relevance;
    }

    public void setRelevance(Relevance relevance) {
        this.relevance = relevance;
    }

    @JsonProperty
    public String getEntityKey() {
        return this.entityKey;
    }

    public static Notification of(String message, String detailedMessage, Level level, String entityKey) {
        return Notification.of(message, detailedMessage, level, Source.MANAGER, entityKey);
    }

    public static Notification of(String message, String detailedMessage, Level level, Source source, String entityKey) {
        return Notification.of(message, detailedMessage, level, DateTime.now(), source, Relevance.CURRENT, entityKey);
    }

    public static Notification of(String message, String detailedMessage, Level level, DateTime timestamp, Source source, Relevance relevance, String entityKey) {
        return new Notification(message, detailedMessage, level, timestamp, source, relevance, entityKey);
    }

    public String toStringWithoutTimestampAndRelevance() {
        return new ToStringBuilder(this).append("message", this.message).append("detailedMessage", (Object)this.detailedMessage).append("level", (Object)this.level).append("source", (Object)this.source).append("entityKey", (Object)this.entityKey).toString();
    }

    public boolean equalsIgnoreTimestampAndRelevance(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Notification that = (Notification)o;
        if (!this.equals(this.message, that.message)) {
            return false;
        }
        if (!this.equals(this.detailedMessage, that.detailedMessage)) {
            return false;
        }
        if (this.level != that.level) {
            return false;
        }
        if (this.source != that.source) {
            return false;
        }
        return this.equals(this.entityKey, that.entityKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Notification that = (Notification)o;
        if (!this.equals(this.key, that.key)) {
            return false;
        }
        if (!this.equals(this.message, that.message)) {
            return false;
        }
        if (!this.equals(this.detailedMessage, that.detailedMessage)) {
            return false;
        }
        if (this.level != that.level) {
            return false;
        }
        if (this.source != that.source) {
            return false;
        }
        if (!this.equals(this.entityKey, that.entityKey)) {
            return false;
        }
        if (!this.equals(this.timestamp, that.timestamp)) {
            return false;
        }
        return this.relevance == that.relevance;
    }

    private boolean equals(Object first, Object second) {
        return Objects.equals(first, second);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.detailedMessage != null ? this.detailedMessage.hashCode() : 0);
        result = 31 * result + (this.level != null ? this.level.hashCode() : 0);
        result = 31 * result + (this.source != null ? this.source.hashCode() : 0);
        result = 31 * result + (this.entityKey != null ? this.entityKey.hashCode() : 0);
        result = 31 * result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        result = 31 * result + (this.relevance != null ? this.relevance.hashCode() : 0);
        return result;
    }

    public static enum Level {
        INFO,
        WARNING,
        CRITICAL,
        UNKNOWN;

    }

    public static enum Source {
        MANAGER,
        AWS,
        UNKNOWN;

    }

    public static enum Relevance {
        CURRENT,
        PREVIOUS,
        UNKNOWN;

    }
}

