/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class NodeConfiguration {
    private final Set<ImplyNodeType> nodeTypes;
    private final Boolean cattle;

    @JsonCreator
    public NodeConfiguration(@JsonProperty(value="nodeTypes") Set<ImplyNodeType> nodeTypes, @JsonProperty(value="cattle") Boolean cattle) {
        this.nodeTypes = nodeTypes;
        this.cattle = cattle;
    }

    @JsonProperty
    public Set<ImplyNodeType> getNodeTypes() {
        return this.nodeTypes;
    }

    @JsonProperty
    public Boolean isCattle() {
        return this.cattle;
    }

    public NodeConfiguration withCattle(Boolean cattle) {
        return new NodeConfiguration(this.nodeTypes, cattle);
    }

    public String toString() {
        return new ToStringBuilder(this).append("nodeTypes", this.nodeTypes).append("cattle", (Object)this.cattle).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeConfiguration that = (NodeConfiguration)o;
        return Objects.equals(this.nodeTypes, that.nodeTypes) && Objects.equals(this.cattle, that.cattle);
    }

    public int hashCode() {
        return Objects.hash(this.nodeTypes, this.cattle);
    }

    public static NodeConfiguration of(ImplyNodeType ... nodeTypes) {
        return NodeConfiguration.of(false, nodeTypes);
    }

    public static NodeConfiguration of(boolean cattle, ImplyNodeType ... nodeTypes) {
        return nodeTypes == null ? new NodeConfiguration(null, cattle) : new NodeConfiguration(new HashSet<ImplyNodeType>(Arrays.asList(nodeTypes)), cattle);
    }

    public static NodeConfiguration empty() {
        return new NodeConfiguration((Set<ImplyNodeType>)ImmutableSet.of(), null);
    }
}

