/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ComparableVersion;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.InstanceType;
import io.imply.cloud.model.MasterUnitSpec;
import io.imply.cloud.util.DiskSizeUtils;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.InstanceTypeHelper;
import io.imply.cloud.util.Pair;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class MasterUnitType {
    @JsonProperty
    private ComparableVersion minImplyVersion;
    @JsonProperty
    private Integer instanceCount;
    @JsonProperty
    private Integer cpu;
    @JsonProperty
    private Integer memory;

    public String toString() {
        return new ToStringBuilder(this).append("minImplyVersion", this.minImplyVersion).append("cpu", (Object)this.cpu).append("memory", (Object)this.memory).append("instanceCount", (Object)this.instanceCount).toString();
    }

    public Integer getMinCount(RefreshableConstants refreshableConstants) {
        return Math.min(2, this.getMaxCount(refreshableConstants));
    }

    public Integer getMaxCount(RefreshableConstants refreshableConstants) {
        return refreshableConstants.getSupportedMasterInstanceTypes().stream().filter(this::proportionalCPUMemory).sorted(Comparator.comparing(InstanceType::getvCpu).reversed()).findFirst().map(instanceType -> instanceType.getvCpu() * this.getInstanceCount() / this.getCpu()).get();
    }

    public static Optional<Pair<String, Integer>> getMasterInstanceTypeCount(MasterUnitSpec unitSpec, ComparableVersion comparableVersion, RefreshableConstants refreshableConstants) {
        return Optional.ofNullable(MasterUnitType.getForComparableImplyVersion(unitSpec.getType(), comparableVersion, refreshableConstants)).map(masterUnitType -> {
            double desiredCPU = Math.ceil((double)(masterUnitType.getCpu() * unitSpec.getCount()) / (double)masterUnitType.getInstanceCount().intValue());
            double desiredMemory = Math.ceil((double)(masterUnitType.getMemory() * unitSpec.getCount()) / (double)masterUnitType.getInstanceCount().intValue());
            Optional<InstanceType> instanceType = refreshableConstants.getSupportedMasterInstanceTypes().stream().sorted(Comparator.comparing(InstanceType::getvCpu)).filter(i -> masterUnitType.proportionalCPUMemory((InstanceType)i) && (double)i.getvCpu().intValue() >= desiredCPU && (double)i.getMemoryInGb().intValue() >= desiredMemory).findFirst();
            return instanceType.map(i -> Pair.of(i.getInstanceType(), masterUnitType.getInstanceCount())).orElse(null);
        });
    }

    public static Optional<MasterUnitSpec> getUnitSpecFromCluster(Cluster cluster, RefreshableConstants refreshableConstants, InstanceTypeHelper instanceTypeHelper) {
        return MasterUnitType.getUnitTypeFromCluster(cluster, refreshableConstants, instanceTypeHelper).map(p -> MasterUnitSpec.builder().type((String)p.lhs).count(((MasterUnitType)p.rhs).getUnitCountFromCluster(cluster, instanceTypeHelper)).build());
    }

    public static MasterUnitType getForComparableImplyVersion(String unitType, ComparableVersion comparableVersion, RefreshableConstants refreshableConstants) {
        if (StringUtils.isBlank((CharSequence)unitType) || comparableVersion == null) {
            return null;
        }
        Map<String, List<MasterUnitType>> unitTypeMap = refreshableConstants.getMasterUnitTypeMap();
        if (!unitTypeMap.containsKey(unitType)) {
            return null;
        }
        List<MasterUnitType> versionedSizeDetails = unitTypeMap.get(unitType);
        return versionedSizeDetails.stream().sorted(Comparator.comparing(MasterUnitType::getMinImplyVersion).reversed()).filter(x -> comparableVersion.compareTo(x.getMinImplyVersion()) >= 0).findFirst().orElse(null);
    }

    public static Optional<Pair<String, Integer>> predictMasterInstanceTypeCount(Integer totalStorageGb, ComparableVersion comparableVersion, RefreshableConstants refreshableConstants) {
        Integer averageSegmentSizeMb = 50;
        Integer averageMetadataSizePerSegmentKb = 10;
        Integer memoryCpuRatio = 4;
        Pair desiredMasterUnitTypePair = refreshableConstants.getMasterUnitTypeMap().entrySet().stream().map(e -> Pair.of((String)e.getKey(), ((List)e.getValue()).stream().sorted(Comparator.comparing(MasterUnitType::getMinImplyVersion).reversed()).filter(x -> comparableVersion.compareTo(x.getMinImplyVersion()) >= 0).filter(ut -> ut.getCpu() * memoryCpuRatio == ut.getMemory()).findAny())).filter(p -> ((Optional)p.rhs).isPresent()).map(p -> Pair.of((String)p.lhs, (MasterUnitType)((Optional)p.rhs).get())).findAny().orElseThrow(() -> new ISE("could not find a valid master unit type", new Object[0]));
        MasterUnitType unitType = (MasterUnitType)desiredMasterUnitTypePair.rhs;
        double totalSegmentCount = (double)totalStorageGb.intValue() * 1000.0 * (double)DiskSizeUtils.REPLICATION_FACTOR.intValue() / (double)averageSegmentSizeMb.intValue();
        double totalMetadataSizeKb = (double)averageMetadataSizePerSegmentKb.intValue() * totalSegmentCount;
        double calculatedMemoryPerMasterKb = totalMetadataSizeKb * 4.0;
        double calculatedMemoryPerMasterGb = calculatedMemoryPerMasterKb / 1000000.0;
        double calculatedCPUPerMaster = calculatedMemoryPerMasterGb / (double)memoryCpuRatio.intValue();
        double desiredCPUPerMaster = Math.max((double)unitType.getCpu().intValue(), calculatedCPUPerMaster);
        double desiredCPU = desiredCPUPerMaster * (double)unitType.getInstanceCount().intValue();
        double calculatedUnitCount = Math.ceil(desiredCPU / (double)unitType.getCpu().intValue());
        int desiredUnitCount = (int)Math.min(Math.max((double)unitType.getMinCount(refreshableConstants).intValue(), calculatedUnitCount), (double)unitType.getMaxCount(refreshableConstants).intValue());
        return MasterUnitType.getMasterInstanceTypeCount(MasterUnitSpec.builder().type((String)desiredMasterUnitTypePair.lhs).count(desiredUnitCount).build(), comparableVersion, refreshableConstants);
    }

    private static Optional<Pair<String, MasterUnitType>> getUnitTypeFromCluster(Cluster cluster, RefreshableConstants refreshableConstants, InstanceTypeHelper instanceTypeHelper) {
        if (cluster == null) {
            return Optional.empty();
        }
        return refreshableConstants.getMasterUnitTypeMap().entrySet().stream().map(details -> Pair.of((String)details.getKey(), ((List)details.getValue()).stream().sorted(Comparator.comparing(MasterUnitType::getMinImplyVersion).reversed()).filter(s -> s.getMinImplyVersion().compareTo(new ComparableVersion(cluster.getImplyVersion())) <= 0).filter(s -> s.proportionalMasterInstanceType(cluster, instanceTypeHelper)).findFirst())).filter(p -> ((Optional)p.rhs).isPresent()).map(p -> Pair.of((String)p.lhs, (MasterUnitType)((Optional)p.rhs).get())).findFirst();
    }

    private Integer getUnitCountFromCluster(Cluster cluster, InstanceTypeHelper instanceTypeHelper) {
        InstanceType instanceType = instanceTypeHelper.lookupInstanceType(ImplyNodeType.MASTER, cluster.getMasterInstanceType());
        return instanceType.getvCpu() * cluster.getMasterInstanceCount() / this.getCpu();
    }

    private boolean proportionalMasterInstanceType(Cluster cluster, InstanceTypeHelper instanceTypeHelper) {
        InstanceType instanceType;
        try {
            instanceType = instanceTypeHelper.lookupInstanceType(ImplyNodeType.MASTER, cluster.getMasterInstanceType());
        }
        catch (ISE e) {
            return false;
        }
        return this.proportionalCPUMemory(instanceType);
    }

    private boolean proportionalCPUMemory(InstanceType instanceType) {
        return this.getCpu() * instanceType.getMemoryInGb() == instanceType.getvCpu() * this.getMemory();
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    private MasterUnitType() {
    }

    @Generated
    public MasterUnitType(ComparableVersion minImplyVersion, Integer instanceCount, Integer cpu, Integer memory) {
        this.minImplyVersion = minImplyVersion;
        this.instanceCount = instanceCount;
        this.cpu = cpu;
        this.memory = memory;
    }

    @Generated
    public ComparableVersion getMinImplyVersion() {
        return this.minImplyVersion;
    }

    @Generated
    public Integer getInstanceCount() {
        return this.instanceCount;
    }

    @Generated
    public Integer getCpu() {
        return this.cpu;
    }

    @Generated
    public Integer getMemory() {
        return this.memory;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MasterUnitType)) {
            return false;
        }
        MasterUnitType other = (MasterUnitType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$instanceCount = this.getInstanceCount();
        Integer other$instanceCount = other.getInstanceCount();
        if (this$instanceCount == null ? other$instanceCount != null : !((Object)this$instanceCount).equals(other$instanceCount)) {
            return false;
        }
        Integer this$cpu = this.getCpu();
        Integer other$cpu = other.getCpu();
        if (this$cpu == null ? other$cpu != null : !((Object)this$cpu).equals(other$cpu)) {
            return false;
        }
        Integer this$memory = this.getMemory();
        Integer other$memory = other.getMemory();
        if (this$memory == null ? other$memory != null : !((Object)this$memory).equals(other$memory)) {
            return false;
        }
        ComparableVersion this$minImplyVersion = this.getMinImplyVersion();
        ComparableVersion other$minImplyVersion = other.getMinImplyVersion();
        return !(this$minImplyVersion == null ? other$minImplyVersion != null : !((Object)this$minImplyVersion).equals(other$minImplyVersion));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MasterUnitType;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $instanceCount = this.getInstanceCount();
        result = result * 59 + ($instanceCount == null ? 43 : ((Object)$instanceCount).hashCode());
        Integer $cpu = this.getCpu();
        result = result * 59 + ($cpu == null ? 43 : ((Object)$cpu).hashCode());
        Integer $memory = this.getMemory();
        result = result * 59 + ($memory == null ? 43 : ((Object)$memory).hashCode());
        ComparableVersion $minImplyVersion = this.getMinImplyVersion();
        result = result * 59 + ($minImplyVersion == null ? 43 : ((Object)$minImplyVersion).hashCode());
        return result;
    }

    @Generated
    public static class Builder {
        @Generated
        private ComparableVersion minImplyVersion;
        @Generated
        private Integer instanceCount;
        @Generated
        private Integer cpu;
        @Generated
        private Integer memory;

        @Generated
        Builder() {
        }

        @JsonProperty
        @Generated
        public Builder minImplyVersion(ComparableVersion minImplyVersion) {
            this.minImplyVersion = minImplyVersion;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder cpu(Integer cpu) {
            this.cpu = cpu;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        @Generated
        public MasterUnitType build() {
            return new MasterUnitType(this.minImplyVersion, this.instanceCount, this.cpu, this.memory);
        }

        @Generated
        public String toString() {
            return "MasterUnitType.Builder(minImplyVersion=" + String.valueOf(this.minImplyVersion) + ", instanceCount=" + this.instanceCount + ", cpu=" + this.cpu + ", memory=" + this.memory + ")";
        }
    }
}

