/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.util.ToStringBuilder;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;

public class LicenseEntitlement {
    @JsonProperty
    private String id;
    @JsonProperty
    private String name;
    @JsonProperty
    private String description;
    @JsonProperty
    private boolean alwaysEnabled;

    public String toString() {
        return new ToStringBuilder(this).append("id", this.id).append("name", (Object)this.name).append("description", (Object)this.description).append("alwaysEnabled", this.alwaysEnabled).toString();
    }

    public static List<String> getLicenseEntitlementsAlwaysEnabled(RefreshableConstants refreshableConstants) {
        return refreshableConstants.getLicenseEntitlements().stream().filter(x -> BooleanUtils.isTrue((Boolean)x.alwaysEnabled)).map(x -> x.getId()).collect(Collectors.toList());
    }

    public static Boolean hasInvalidLicenseEntitlements(List<String> licenseEntitlements, RefreshableConstants refreshableConstants) {
        Set validLicenseEntitlements = refreshableConstants.getLicenseEntitlements().stream().map(x -> x.getId()).collect(Collectors.toSet());
        return licenseEntitlements.stream().anyMatch(x -> !validLicenseEntitlements.contains(x));
    }

    public static List<String> getAllLicenseEntitlements(RefreshableConstants refreshableConstants) {
        return refreshableConstants.getLicenseEntitlements().stream().map(x -> x.getId()).collect(Collectors.toList());
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    private LicenseEntitlement() {
    }

    @Generated
    public LicenseEntitlement(String id, String name, String description, boolean alwaysEnabled) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.alwaysEnabled = alwaysEnabled;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public boolean isAlwaysEnabled() {
        return this.alwaysEnabled;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LicenseEntitlement)) {
            return false;
        }
        LicenseEntitlement other = (LicenseEntitlement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAlwaysEnabled() != other.isAlwaysEnabled()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LicenseEntitlement;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAlwaysEnabled() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    @Generated
    public static class Builder {
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private boolean alwaysEnabled;

        @Generated
        Builder() {
        }

        @JsonProperty
        @Generated
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder description(String description) {
            this.description = description;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder alwaysEnabled(boolean alwaysEnabled) {
            this.alwaysEnabled = alwaysEnabled;
            return this;
        }

        @Generated
        public LicenseEntitlement build() {
            return new LicenseEntitlement(this.id, this.name, this.description, this.alwaysEnabled);
        }

        @Generated
        public String toString() {
            return "LicenseEntitlement.Builder(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", alwaysEnabled=" + this.alwaysEnabled + ")";
        }
    }
}

