/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.ServiceHealth;
import io.imply.cloud.util.ToStringBuilder;
import java.util.List;
import org.joda.time.DateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class InstanceHealth {
    private final String key;
    private final String clusterId;
    private final String instanceId;
    private final String host;
    private final ImplyNodeType implyNodeType;
    private final DateTime created;
    private final DateTime lastStatusCheck;
    private final Integer consecutiveSuccessCount;
    private final Integer failureCount;
    private final Integer consecutiveFailureCount;
    private final String lastMessage;
    private final List<ServiceHealth> serviceHealth;

    @JsonCreator
    private InstanceHealth(@JsonProperty(value="key") String key, @JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="instanceId") String instanceId, @JsonProperty(value="host") String host, @JsonProperty(value="implyNodeType") ImplyNodeType implyNodeType, @JsonProperty(value="created") DateTime created, @JsonProperty(value="lastStatusCheck") DateTime lastStatusCheck, @JsonProperty(value="consecutiveSuccessCount") Integer consecutiveSuccessCount, @JsonProperty(value="failureCount") Integer failureCount, @JsonProperty(value="consecutiveFailureCount") Integer consecutiveFailureCount, @JsonProperty(value="lastMessage") String lastMessage, @JsonProperty(value="serviceHealth") List<ServiceHealth> serviceHealth) {
        this.key = key;
        this.clusterId = clusterId;
        this.instanceId = instanceId;
        this.host = host;
        this.implyNodeType = implyNodeType;
        this.created = created;
        this.lastStatusCheck = lastStatusCheck;
        this.consecutiveSuccessCount = consecutiveSuccessCount;
        this.failureCount = failureCount;
        this.consecutiveFailureCount = consecutiveFailureCount;
        this.lastMessage = lastMessage;
        this.serviceHealth = serviceHealth;
    }

    @JsonProperty
    public String getKey() {
        return this.key;
    }

    @JsonProperty
    public String getClusterId() {
        return this.clusterId;
    }

    @JsonProperty
    public String getInstanceId() {
        return this.instanceId;
    }

    @JsonProperty
    public String getHost() {
        return this.host;
    }

    @JsonProperty
    public ImplyNodeType getImplyNodeType() {
        return this.implyNodeType;
    }

    @JsonProperty
    public DateTime getCreated() {
        return this.created;
    }

    @JsonProperty
    public DateTime getLastStatusCheck() {
        return this.lastStatusCheck;
    }

    @JsonProperty
    public Integer getConsecutiveSuccessCount() {
        return this.consecutiveSuccessCount;
    }

    @JsonProperty
    public Integer getFailureCount() {
        return this.failureCount;
    }

    @JsonProperty
    public Integer getConsecutiveFailureCount() {
        return this.consecutiveFailureCount;
    }

    @JsonProperty
    public String getLastMessage() {
        return this.lastMessage;
    }

    @JsonProperty
    public List<ServiceHealth> getServiceHealth() {
        return this.serviceHealth;
    }

    public boolean hasFailedCheck() {
        return this.failureCount != null && this.failureCount > 0;
    }

    public static String createKey(String clusterId, String instanceId, ImplyNodeType implyNodeType) {
        return String.format("%s/%s/%s", clusterId, instanceId, implyNodeType.camelCasedName());
    }

    public InstanceHealth merge(InstanceHealth partialRecord) {
        if (partialRecord == null) {
            return this;
        }
        String key = partialRecord.key != null ? partialRecord.key : this.key;
        String clusterId = partialRecord.clusterId != null ? partialRecord.clusterId : this.clusterId;
        String instanceId = partialRecord.instanceId != null ? partialRecord.instanceId : this.instanceId;
        String host = partialRecord.host != null ? partialRecord.host : this.host;
        ImplyNodeType implyNodeType = partialRecord.implyNodeType != null ? partialRecord.implyNodeType : this.implyNodeType;
        DateTime created = partialRecord.created != null ? partialRecord.created : this.created;
        DateTime lastStatusCheck = partialRecord.lastStatusCheck != null ? partialRecord.lastStatusCheck : this.lastStatusCheck;
        Integer consecutiveSuccessCount = partialRecord.consecutiveSuccessCount != null ? partialRecord.consecutiveSuccessCount : this.consecutiveSuccessCount;
        Integer failureCount = partialRecord.failureCount != null ? partialRecord.failureCount : this.failureCount;
        Integer consecutiveFailureCount = partialRecord.consecutiveFailureCount != null ? partialRecord.consecutiveFailureCount : this.consecutiveFailureCount;
        String lastMessage = partialRecord.lastMessage != null ? partialRecord.lastMessage : this.lastMessage;
        List<ServiceHealth> serviceHealth = partialRecord.serviceHealth != null ? partialRecord.serviceHealth : this.serviceHealth;
        return new InstanceHealth(key, clusterId, instanceId, host, implyNodeType, created, lastStatusCheck, consecutiveSuccessCount, failureCount, consecutiveFailureCount, lastMessage, serviceHealth);
    }

    public InstanceHealth simplifiedForDescribeCluster() {
        return new InstanceHealth(null, null, null, null, null, null, this.lastStatusCheck, this.consecutiveSuccessCount, null, this.consecutiveFailureCount, this.lastMessage, this.serviceHealth);
    }

    public String toString() {
        return new ToStringBuilder(this).append("key", this.key).append("clusterId", (Object)this.clusterId).append("instanceId", (Object)this.instanceId).append("host", (Object)this.host).append("implyNodeType", (Object)this.implyNodeType).append("created", (Object)this.created).append("lastStatusCheck", (Object)this.lastStatusCheck).append("consecutiveSuccessCount", (Object)this.consecutiveSuccessCount).append("failureCount", (Object)this.failureCount).append("consecutiveFailureCount", (Object)this.consecutiveFailureCount).append("lastMessage", (Object)this.lastMessage).append("serviceHealth", this.serviceHealth).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String clusterId;
        private String instanceId;
        private String host;
        private ImplyNodeType implyNodeType;
        private DateTime created;
        private DateTime lastStatusCheck;
        private Integer consecutiveSuccessCount;
        private Integer failureCount;
        private Integer consecutiveFailureCount;
        private String lastMessage;
        private List<ServiceHealth> serviceHealth;

        private Builder() {
        }

        public Builder withInstanceHealth(InstanceHealth instanceHealth) {
            if (instanceHealth == null) {
                return this;
            }
            if (instanceHealth.clusterId != null) {
                this.clusterId = instanceHealth.clusterId;
            }
            if (instanceHealth.instanceId != null) {
                this.instanceId = instanceHealth.instanceId;
            }
            if (instanceHealth.host != null) {
                this.host = instanceHealth.host;
            }
            if (instanceHealth.implyNodeType != null) {
                this.implyNodeType = instanceHealth.implyNodeType;
            }
            if (instanceHealth.created != null) {
                this.created = instanceHealth.created;
            }
            if (instanceHealth.lastStatusCheck != null) {
                this.lastStatusCheck = instanceHealth.lastStatusCheck;
            }
            if (instanceHealth.consecutiveSuccessCount != null) {
                this.consecutiveSuccessCount = instanceHealth.consecutiveSuccessCount;
            }
            if (instanceHealth.failureCount != null) {
                this.failureCount = instanceHealth.failureCount;
            }
            if (instanceHealth.consecutiveFailureCount != null) {
                this.consecutiveFailureCount = instanceHealth.consecutiveFailureCount;
            }
            if (instanceHealth.lastMessage != null) {
                this.lastMessage = instanceHealth.lastMessage;
            }
            if (instanceHealth.serviceHealth != null) {
                this.serviceHealth = instanceHealth.serviceHealth;
            }
            return this;
        }

        public Builder withClusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public Builder withInstanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public Builder withHost(String host) {
            this.host = host;
            return this;
        }

        public Builder withImplyNodeType(ImplyNodeType implyNodeType) {
            this.implyNodeType = implyNodeType;
            return this;
        }

        public Builder withCreated(DateTime created) {
            this.created = created;
            return this;
        }

        public Builder withLastStatusCheck(DateTime lastStatusCheck) {
            this.lastStatusCheck = lastStatusCheck;
            return this;
        }

        public Builder withConsecutiveSuccessCount(Integer consecutiveSuccessCount) {
            this.consecutiveSuccessCount = consecutiveSuccessCount;
            return this;
        }

        public Builder withFailureCount(Integer failureCount) {
            this.failureCount = failureCount;
            return this;
        }

        public Builder withConsecutiveFailureCount(Integer consecutiveFailureCount) {
            this.consecutiveFailureCount = consecutiveFailureCount;
            return this;
        }

        public Builder withLastMessage(String lastMessage) {
            this.lastMessage = lastMessage;
            return this;
        }

        public Builder withServiceHealth(List<ServiceHealth> serviceHealth) {
            this.serviceHealth = serviceHealth;
            return this;
        }

        public InstanceHealth build() {
            Preconditions.checkNotNull((Object)this.clusterId, (Object)"clusterId");
            Preconditions.checkNotNull((Object)this.instanceId, (Object)"instanceId");
            return new InstanceHealth(InstanceHealth.createKey(this.clusterId, this.instanceId, this.implyNodeType), this.clusterId, this.instanceId, this.host, this.implyNodeType, this.created, this.lastStatusCheck, this.consecutiveSuccessCount, this.failureCount, this.consecutiveFailureCount, this.lastMessage, this.serviceHealth);
        }
    }
}

