/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableList;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.ToStringBuilder;
import java.util.List;
import lombok.Generated;

public class ImplyNodeType {
    public static final ImplyNodeType MASTER = new ImplyNodeType(ImplyNodeServiceType.MASTER);
    public static final ImplyNodeType COLD_TIER_DATA = new ImplyNodeType(ImplyNodeServiceType.COLD_TIER_DATA);
    public static final ImplyNodeType COLD_TIER_QUERY = new ImplyNodeType(ImplyNodeServiceType.COLD_TIER_QUERY);
    public static final ImplyNodeType QUERY = new ImplyNodeType(ImplyNodeServiceType.QUERY);
    public static final ImplyNodeType INGEST = new ImplyNodeType(ImplyNodeServiceType.INGEST);
    public static final ImplyNodeType UNKNOWN = new ImplyNodeType(ImplyNodeServiceType.UNKNOWN);
    public static final ImplyNodeType DATA = new ImplyNodeType(ImplyNodeServiceType.DATA, 0);
    public static final ImplyNodeType DATA_TIER_1 = new ImplyNodeType(ImplyNodeServiceType.DATA, 1);
    public static final ImplyNodeType DATA_TIER_2 = new ImplyNodeType(ImplyNodeServiceType.DATA, 2);
    public static final ImplyNodeType DATA_TIER_3 = new ImplyNodeType(ImplyNodeServiceType.DATA, 3);
    public static final ImplyNodeType PEON = new ImplyNodeType(ImplyNodeServiceType.PEON);
    public static final List<ImplyNodeType> USER_SELECTABLE_NODE_TYPES = ImmutableList.of((Object)MASTER, (Object)DATA_TIER_1, (Object)DATA_TIER_2, (Object)DATA_TIER_3, (Object)QUERY);
    @JsonProperty
    private ImplyNodeServiceType nodeServiceType;
    @JsonProperty
    private int tierNumber;

    public ImplyNodeType(ImplyNodeServiceType nodeServiceType) {
        this.nodeServiceType = nodeServiceType;
        this.tierNumber = 0;
    }

    @JsonCreator
    public static ImplyNodeType fromString(String key) {
        for (ImplyNodeServiceType nodeServiceType : ImplyNodeServiceType.values()) {
            String type = nodeServiceType.name().replaceAll("_", "").toLowerCase();
            if (!key.toLowerCase().startsWith(type)) continue;
            if (!type.equalsIgnoreCase(key)) {
                Integer tierNumber = Integer.parseInt(key.replaceAll("[^0-9]+", ""));
                return new ImplyNodeType(nodeServiceType, tierNumber);
            }
            return new ImplyNodeType(nodeServiceType);
        }
        return null;
    }

    public static ImplyNodeType fromServiceTypeAndTier(String key, Integer tierNumber) {
        ImplyNodeType implyNodeType = ImplyNodeType.fromString(key);
        if (implyNodeType != null && implyNodeType.getNodeServiceType().isTiered() && implyNodeType.getTierNumber() == 0) {
            return new ImplyNodeType(implyNodeType.getNodeServiceType(), tierNumber != null ? tierNumber : 0);
        }
        return implyNodeType;
    }

    @JsonValue
    public String camelCasedName() {
        switch (this.nodeServiceType) {
            case DATA: {
                return this.tierNumber > 0 ? String.format("dataTier%d", this.tierNumber) : this.nodeServiceType.name().toLowerCase();
            }
            case COLD_TIER_DATA: {
                return "coldTierData";
            }
            case COLD_TIER_QUERY: {
                return "coldTierQuery";
            }
        }
        return this.nodeServiceType.name().toLowerCase();
    }

    public String capitalCasedName() {
        switch (this.nodeServiceType) {
            case DATA: {
                return this.tierNumber > 0 ? String.format("DATA_TIER_%d", this.tierNumber) : this.nodeServiceType.name();
            }
        }
        return this.nodeServiceType.name();
    }

    public String getServiceType() {
        switch (this.nodeServiceType) {
            case MASTER: {
                return "master";
            }
            case COLD_TIER_QUERY: {
                return "coldtierquery";
            }
            case QUERY: {
                return "query";
            }
            case COLD_TIER_DATA: {
                return "coldtierdata";
            }
            case DATA: {
                return "data";
            }
            case INGEST: {
                return "ingest";
            }
            case PEON: {
                return "peon";
            }
        }
        return "unknown";
    }

    public boolean isDataType() {
        return this.nodeServiceType == ImplyNodeServiceType.DATA || this.nodeServiceType == ImplyNodeServiceType.COLD_TIER_DATA;
    }

    public static ImplyNodeType dataFromTierInteger(int tierNumber) {
        if (tierNumber <= 0) {
            throw new IAE("[%d] is not a valid tier for DATA ImplyNodeType", tierNumber);
        }
        return new ImplyNodeType(ImplyNodeServiceType.DATA, tierNumber);
    }

    public String toString() {
        return new ToStringBuilder(this).append("serviceType", this.nodeServiceType.name()).append("tierNumber", this.tierNumber).toString();
    }

    @Generated
    public ImplyNodeType(ImplyNodeServiceType nodeServiceType, int tierNumber) {
        this.nodeServiceType = nodeServiceType;
        this.tierNumber = tierNumber;
    }

    @Generated
    public ImplyNodeServiceType getNodeServiceType() {
        return this.nodeServiceType;
    }

    @Generated
    public int getTierNumber() {
        return this.tierNumber;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImplyNodeType)) {
            return false;
        }
        ImplyNodeType other = (ImplyNodeType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTierNumber() != other.getTierNumber()) {
            return false;
        }
        ImplyNodeServiceType this$nodeServiceType = this.getNodeServiceType();
        ImplyNodeServiceType other$nodeServiceType = other.getNodeServiceType();
        return !(this$nodeServiceType == null ? other$nodeServiceType != null : !((Object)((Object)this$nodeServiceType)).equals((Object)other$nodeServiceType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ImplyNodeType;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTierNumber();
        ImplyNodeServiceType $nodeServiceType = this.getNodeServiceType();
        result = result * 59 + ($nodeServiceType == null ? 43 : ((Object)((Object)$nodeServiceType)).hashCode());
        return result;
    }

    public static enum ImplyNodeServiceType {
        MASTER,
        COLD_TIER_DATA,
        DATA,
        COLD_TIER_QUERY,
        QUERY,
        INGEST,
        PEON,
        UNKNOWN;


        public boolean isTiered() {
            return this == DATA;
        }
    }
}

