/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.model.User;
import io.imply.cloud.util.ToStringBuilder;
import java.util.List;
import org.joda.time.DateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ImpersonatedUser
extends User {
    private final String impersonator;

    @JsonCreator
    public ImpersonatedUser(@JsonProperty(value="userId") String userId, @JsonProperty(value="accountId") String accountId, @JsonProperty(value="version") Integer version, @JsonProperty(value="created") DateTime created, @JsonProperty(value="lastModified") DateTime lastModified, @JsonProperty(value="accountIds") List<String> accountIds, @JsonProperty(value="impersonator") String impersonator) {
        super(userId, accountId, version, created, lastModified, accountIds);
        this.impersonator = impersonator;
    }

    public ImpersonatedUser(User user, String impersonator) {
        this(user.userId, user.accountId, user.version, user.created, user.lastModified, user.accountIds, impersonator);
    }

    @JsonProperty
    public String getImpersonator() {
        return this.impersonator;
    }

    @Override
    public String getDetailedUserId() {
        return String.format("%s -> %s", this.impersonator, this.userId);
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("userId", this.userId).append("accountId", (Object)this.accountId).append("version", (Object)this.version).append("created", (Object)this.created).append("lastModified", (Object)this.lastModified).append("accountIds", (Object)this.accountIds).append("impersonator", (Object)this.impersonator).toString();
    }
}

