/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import io.imply.cloud.model.DataUnitType;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.InstanceTier;
import io.imply.cloud.model.Scalable;
import io.imply.cloud.util.DiskSizeUtils;
import io.imply.cloud.util.InstanceTypeHelper;
import io.imply.cloud.util.ToStringBuilder;
import lombok.Generated;

public class HorizontalDataUnitType
extends DataUnitType {
    private static final Integer MAX_EBS_VOLUME_SIZE_GB = 16000;
    private static final Integer MAX_EBS_VOLUME_COUNT = 8;

    @Override
    public Integer getCpu(InstanceTypeHelper instanceTypeHelper) {
        return this.getInstanceTiers().entrySet().stream().filter(e -> ((InstanceTier)e.getValue()).getInstanceCount() > 0).mapToInt(e -> instanceTypeHelper.lookupInstanceType(ImplyNodeType.DATA, ((InstanceTier)e.getValue()).getInstanceType()).getvCpu() * ((InstanceTier)e.getValue()).getInstanceCount()).sum();
    }

    @Override
    public Integer getMemory(InstanceTypeHelper instanceTypeHelper) {
        return this.getInstanceTiers().entrySet().stream().filter(e -> ((InstanceTier)e.getValue()).getInstanceCount() > 0).mapToInt(e -> instanceTypeHelper.lookupInstanceType(ImplyNodeType.DATA, ((InstanceTier)e.getValue()).getInstanceType()).getMemoryInGb() * ((InstanceTier)e.getValue()).getInstanceCount()).sum();
    }

    @Override
    public Integer getMinCount() {
        return 2;
    }

    @Override
    public Integer getMaxCount() {
        return 50;
    }

    @Override
    public Integer getMaxCPUToDiskGBRatio(InstanceTypeHelper instanceTypeHelper) {
        return Math.min(500, DiskSizeUtils.getCPUToDiskGBRatioFromDisk(MAX_EBS_VOLUME_SIZE_GB * MAX_EBS_VOLUME_COUNT, this, instanceTypeHelper));
    }

    @Override
    public Integer getMinCPUToDiskGBRatio(InstanceTypeHelper instanceTypeHelper) {
        return this.getMemory(instanceTypeHelper) / this.getCpu(instanceTypeHelper);
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).appendSuper(super.toString()).toString();
    }

    @Override
    public Scalable.Scaling getScaling() {
        return Scalable.Scaling.HORIZONTAL;
    }

    @Generated
    protected HorizontalDataUnitType(Builder<?, ?> b) {
        super(b);
    }

    @Generated
    public static Builder<?, ?> builder() {
        return new BuilderImpl();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HorizontalDataUnitType)) {
            return false;
        }
        HorizontalDataUnitType other = (HorizontalDataUnitType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HorizontalDataUnitType;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    private HorizontalDataUnitType() {
    }

    @Generated
    private static final class BuilderImpl
    extends Builder<HorizontalDataUnitType, BuilderImpl> {
        @Generated
        private BuilderImpl() {
        }

        @Override
        @Generated
        protected BuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public HorizontalDataUnitType build() {
            return new HorizontalDataUnitType(this);
        }
    }

    @Generated
    public static abstract class Builder<C extends HorizontalDataUnitType, B extends Builder<C, B>>
    extends DataUnitType.Builder<C, B> {
        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "HorizontalDataUnitType.Builder(super=" + super.toString() + ")";
        }
    }
}

