/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.imply.cloud.FeatureFlags;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ComparableVersion;
import io.imply.cloud.model.ImplyVersion;
import io.imply.cloud.model.UpdateType;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FeatureFlag {
    private final String id;
    private final String name;
    private final String description;
    private final ComparableVersion enabledByDefaultMinImplyVersion;
    private final ComparableVersion enabledByDefaultMaxImplyVersion;
    private final ComparableVersion minImplyVersion;
    private final ComparableVersion maxImplyVersion;
    private final Map<String, Object> druidProperties;
    private final UpdateType requiredUpdateType;
    private final List<String> userExtensions;
    private final boolean visibleByDefault;
    private final Boolean requiresManagerSupport;
    private final boolean kubernetesModeOnly;
    private final String requiredAccountFeatureFlag;

    @JsonCreator
    public FeatureFlag(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="minImplyVersion") ComparableVersion minImplyVersion, @JsonProperty(value="maxImplyVersion") ComparableVersion maxImplyVersion, @JsonProperty(value="druidProperties") Map<String, Object> druidProperties, @JsonProperty(value="requiresManagerSupport") Boolean requiresManagerSupport, @JsonProperty(value="enabledByDefaultMinImplyVersion") ComparableVersion enabledByDefaultMinImplyVersion, @JsonProperty(value="enabledByDefaultMaxImplyVersion") ComparableVersion enabledByDefaultMaxImplyVersion, @JsonProperty(value="requiredUpdateType") UpdateType requiredUpdateType, @JsonProperty(value="userExtensions") List<String> userExtensions, @JsonProperty(value="visibleByDefault") boolean visibleByDefault, @JsonProperty(value="kubernetesModeOnly") boolean kubernetesModeOnly, @JsonProperty(value="requiredAccountFeatureFlag") String requiredAccountFeatureFlag) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.minImplyVersion = minImplyVersion;
        this.maxImplyVersion = maxImplyVersion;
        this.druidProperties = druidProperties;
        this.requiresManagerSupport = requiresManagerSupport;
        this.enabledByDefaultMinImplyVersion = enabledByDefaultMinImplyVersion;
        this.enabledByDefaultMaxImplyVersion = enabledByDefaultMaxImplyVersion;
        this.requiredUpdateType = requiredUpdateType;
        this.userExtensions = userExtensions;
        this.visibleByDefault = visibleByDefault;
        this.kubernetesModeOnly = kubernetesModeOnly;
        this.requiredAccountFeatureFlag = requiredAccountFeatureFlag;
    }

    @JsonProperty
    public String getId() {
        return this.id;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getDescription() {
        return this.description;
    }

    @JsonProperty
    public ComparableVersion getEnabledByDefaultMinImplyVersion() {
        return this.enabledByDefaultMinImplyVersion;
    }

    @JsonProperty
    public ComparableVersion getEnabledByDefaultMaxImplyVersion() {
        return this.enabledByDefaultMaxImplyVersion;
    }

    @JsonProperty
    public ComparableVersion getMinImplyVersion() {
        return this.minImplyVersion;
    }

    @JsonProperty
    public ComparableVersion getMaxImplyVersion() {
        return this.maxImplyVersion;
    }

    public Map<String, Object> getDruidProperties() {
        return this.druidProperties;
    }

    public UpdateType getRequiredUpdateType() {
        return this.requiredUpdateType;
    }

    @JsonProperty
    public List<String> getUserExtensions() {
        return this.userExtensions;
    }

    @JsonProperty
    public boolean getVisibleByDefault() {
        return this.visibleByDefault;
    }

    @JsonProperty
    public boolean getKubernetesModeOnly() {
        return this.kubernetesModeOnly;
    }

    @JsonProperty
    public String getRequiredAccountFeatureFlag() {
        return this.requiredAccountFeatureFlag;
    }

    public String toString() {
        return new ToStringBuilder(this).append("id", this.id).append("name", (Object)this.name).append("description", (Object)this.description).append("minImplyVersion", (Object)this.minImplyVersion).append("maxImplyVersion", (Object)this.maxImplyVersion).append("druidProperties", this.druidProperties).append("requiresManagerSupport", (Object)this.requiresManagerSupport).append("enabledByDefaultMinImplyVersion", (Object)this.enabledByDefaultMinImplyVersion).append("enabledByDefaultMaxImplyVersion", (Object)this.enabledByDefaultMaxImplyVersion).append("requiredUpdateTypes", (Object)this.requiredUpdateType).append("userExtensions", this.userExtensions).append("visibleByDefault", this.visibleByDefault).append("kubernetesModeOnly", this.kubernetesModeOnly).append("requiredAccountFeatureFlag", (Object)this.requiredAccountFeatureFlag).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureFlag that = (FeatureFlag)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.minImplyVersion, that.minImplyVersion) && Objects.equals(this.maxImplyVersion, that.maxImplyVersion) && Objects.equals(this.druidProperties, that.druidProperties) && Objects.equals(this.requiresManagerSupport, that.requiresManagerSupport) && Objects.equals(this.enabledByDefaultMinImplyVersion, that.enabledByDefaultMinImplyVersion) && Objects.equals(this.enabledByDefaultMaxImplyVersion, that.enabledByDefaultMaxImplyVersion) && Objects.equals((Object)this.requiredUpdateType, (Object)that.requiredUpdateType) && Objects.equals(this.userExtensions, that.userExtensions) && Objects.equals(this.visibleByDefault, that.visibleByDefault) && Objects.equals(this.kubernetesModeOnly, that.kubernetesModeOnly) && Objects.equals(this.requiredAccountFeatureFlag, that.requiredAccountFeatureFlag);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.description, this.minImplyVersion, this.maxImplyVersion, this.druidProperties, this.requiresManagerSupport, this.enabledByDefaultMinImplyVersion, this.enabledByDefaultMaxImplyVersion, this.requiredUpdateType, this.userExtensions, this.visibleByDefault, this.kubernetesModeOnly, this.requiredAccountFeatureFlag});
    }

    public static boolean enabledForAccount(Account account, FeatureFlags featureFlag) {
        return FeatureFlag.enabledForAccount(account, featureFlag.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean enabledForAccount(Account account, String featureFlag) {
        Preconditions.checkNotNull((Object)account, (Object)"account cannot be null");
        Preconditions.checkNotNull((Object)featureFlag, (Object)"featureFlag cannot be null");
        if (account.getFeatureFlags() == null) return false;
        if (!account.getFeatureFlags().stream().anyMatch(featureFlag::equals)) return false;
        return true;
    }

    public static boolean enabledForCluster(Cluster cluster, FeatureFlags featureFlags, RefreshableConstants refreshableConstants) {
        return FeatureFlag.getForCluster(cluster, refreshableConstants).stream().anyMatch(x -> featureFlags.toString().equals(x.getId()));
    }

    public static List<FeatureFlag> getEnabledByDefaultForImplyVersion(ImplyVersion version, ApplicationConfig applicationConfig, RefreshableConstants refreshableConstants) {
        if (version == null || version.getComparableVersion() == null) {
            return ImmutableList.of();
        }
        return refreshableConstants.getFeatureFlags().stream().filter(f -> f.getEnabledByDefaultMinImplyVersion() != null && version.getComparableVersion().compareTo(f.getEnabledByDefaultMinImplyVersion()) >= 0 && (f.getEnabledByDefaultMaxImplyVersion() == null || version.getComparableVersion().compareTo(f.getEnabledByDefaultMaxImplyVersion()) <= 0)).filter(x -> BooleanUtils.isNotTrue((Boolean)x.requiresManagerSupport) || FeatureFlags.isSupported(x.getId())).filter(flag -> BooleanUtils.isNotTrue((Boolean)flag.getKubernetesModeOnly()) || applicationConfig.isKubernetesMode()).collect(Collectors.toList());
    }

    public static List<String> getEnabledByDefaultForImplyVersionStringList(ImplyVersion version, ApplicationConfig applicationConfig, RefreshableConstants refreshableConstants) {
        List<FeatureFlag> featureFlags = FeatureFlag.getEnabledByDefaultForImplyVersion(version, applicationConfig, refreshableConstants);
        return featureFlags.stream().map(FeatureFlag::getId).collect(Collectors.toList());
    }

    public static List<FeatureFlag> getForImplyVersion(ImplyVersion version, RefreshableConstants refreshableConstants) {
        return FeatureFlag.getStreamForImplyVersion(version, refreshableConstants).collect(Collectors.toList());
    }

    public static List<FeatureFlag> getForImplyVersionAndPlatform(ImplyVersion version, ApplicationConfig applicationConfig, Account account, RefreshableConstants refreshableConstants) {
        return FeatureFlag.getStreamForImplyVersion(version, refreshableConstants).filter(flag -> BooleanUtils.isNotTrue((Boolean)flag.getKubernetesModeOnly()) || applicationConfig.isKubernetesMode()).filter(flag -> flag.getRequiredAccountFeatureFlag() == null || account != null && FeatureFlag.enabledForAccount(account, flag.getRequiredAccountFeatureFlag())).collect(Collectors.toList());
    }

    public static List<FeatureFlag> getVisibleForImplyVersion(ImplyVersion version, RefreshableConstants refreshableConstants) {
        return FeatureFlag.getStreamForImplyVersion(version, refreshableConstants).filter(x -> BooleanUtils.isTrue((Boolean)x.visibleByDefault)).collect(Collectors.toList());
    }

    private static Stream<FeatureFlag> getStreamForImplyVersion(ImplyVersion version, RefreshableConstants refreshableConstants) {
        return version == null || version.getComparableVersion() == null || refreshableConstants.getFeatureFlags() == null ? Stream.empty() : refreshableConstants.getFeatureFlags().stream().filter(x -> version.getComparableVersion().compareTo(x.getMinImplyVersion()) >= 0 && (x.getMaxImplyVersion() == null || version.getComparableVersion().compareTo(x.getMaxImplyVersion()) <= 0)).filter(x -> BooleanUtils.isNotTrue((Boolean)x.requiresManagerSupport) || FeatureFlags.isSupported(x.getId()));
    }

    public static List<FeatureFlag> getForCluster(Cluster cluster, RefreshableConstants refreshableConstants) {
        return FeatureFlag.getForCluster(cluster, FeatureFlag.getForImplyVersion(cluster.getImplyVersionFull(), refreshableConstants));
    }

    public static List<FeatureFlag> getVisibleForCluster(Cluster cluster, RefreshableConstants refreshableConstants) {
        return FeatureFlag.getForCluster(cluster, FeatureFlag.getVisibleForImplyVersion(cluster.getImplyVersionFull(), refreshableConstants));
    }

    private static List<FeatureFlag> getForCluster(Cluster cluster, List<FeatureFlag> supportedFeatureFlags) {
        if (cluster == null || CollectionUtils.isEmpty(cluster.getFeatureFlags())) {
            return Collections.emptyList();
        }
        return supportedFeatureFlags.stream().filter(x -> cluster.getFeatureFlags().contains(x.getId())).collect(Collectors.toList());
    }

    public static List<FeatureFlag> getForIds(Collection<String> featureFlagIds, RefreshableConstants refreshableConstants) {
        return featureFlagIds == null ? ImmutableList.of() : refreshableConstants.getFeatureFlags().stream().filter(x -> featureFlagIds.contains(x.getId())).collect(Collectors.toList());
    }

    public static boolean isEnabledByDefaultForImplyVersion(FeatureFlag featureFlag, String version) {
        if (version == null || StringUtils.isBlank((CharSequence)version)) {
            throw new IAE("The parameter 'version' must not be null or empty", new Object[0]);
        }
        return FeatureFlag.isEnabledByDefaultForImplyVersion(featureFlag, new ComparableVersion(version));
    }

    public static boolean isEnabledByDefaultForImplyVersion(FeatureFlag featureFlag, ComparableVersion implyVersion) {
        if (featureFlag == null) {
            throw new IAE("The parameter featureFlag cannot be null", new Object[0]);
        }
        if (implyVersion == null) {
            throw new IAE("The parameter implyVersion cannot be null", new Object[0]);
        }
        ComparableVersion enabledByDefaultMinImplyVersion = featureFlag.getEnabledByDefaultMinImplyVersion();
        ComparableVersion enabledByDefaultMaxImplyVersion = featureFlag.getEnabledByDefaultMaxImplyVersion();
        return implyVersion.compareTo(enabledByDefaultMinImplyVersion) >= 0 && (enabledByDefaultMaxImplyVersion == null || implyVersion.compareTo(enabledByDefaultMaxImplyVersion) <= 0);
    }
}

