/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.model.ComparableVersion;
import io.imply.cloud.model.ImplyVersion;
import io.imply.cloud.security.druid.ResourceAction;
import io.imply.cloud.util.ToStringBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DruidRoleMapping {
    @JsonProperty
    private final ComparableVersion minImplyVersion;
    @JsonProperty
    private final Map<String, List<ResourceAction>> roles;

    public String toString() {
        return new ToStringBuilder(this).append("minImplyVersion", this.minImplyVersion).append("roles", this.roles).build();
    }

    public boolean isNotEmpty() {
        return this.minImplyVersion != null && MapUtils.isNotEmpty(this.roles);
    }

    public static DruidRoleMapping getForImplyVersion(ImplyVersion version, RefreshableConstants refreshableConstants) {
        return version == null || version.getComparableVersion() == null ? null : (DruidRoleMapping)refreshableConstants.getDruidRoleMappings().stream().sorted(Comparator.comparing(DruidRoleMapping::getMinImplyVersion).reversed()).filter(x -> version.getComparableVersion().compareTo(x.getMinImplyVersion()) >= 0).findFirst().orElse(null);
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Builder toBuilder() {
        Builder builder = new Builder().minImplyVersion(this.minImplyVersion);
        if (this.roles != null) {
            builder.roles(this.roles);
        }
        return builder;
    }

    @Generated
    private DruidRoleMapping(ComparableVersion minImplyVersion, Map<String, List<ResourceAction>> roles) {
        this.minImplyVersion = minImplyVersion;
        this.roles = roles;
    }

    @Generated
    private DruidRoleMapping() {
        this.minImplyVersion = null;
        this.roles = null;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DruidRoleMapping)) {
            return false;
        }
        DruidRoleMapping other = (DruidRoleMapping)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ComparableVersion this$minImplyVersion = this.getMinImplyVersion();
        ComparableVersion other$minImplyVersion = other.getMinImplyVersion();
        if (this$minImplyVersion == null ? other$minImplyVersion != null : !((Object)this$minImplyVersion).equals(other$minImplyVersion)) {
            return false;
        }
        Map<String, List<ResourceAction>> this$roles = this.getRoles();
        Map<String, List<ResourceAction>> other$roles = other.getRoles();
        return !(this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DruidRoleMapping;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ComparableVersion $minImplyVersion = this.getMinImplyVersion();
        result = result * 59 + ($minImplyVersion == null ? 43 : ((Object)$minImplyVersion).hashCode());
        Map<String, List<ResourceAction>> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        return result;
    }

    @Generated
    public ComparableVersion getMinImplyVersion() {
        return this.minImplyVersion;
    }

    @Generated
    public Map<String, List<ResourceAction>> getRoles() {
        return this.roles;
    }

    @Generated
    public static class Builder {
        @Generated
        private ComparableVersion minImplyVersion;
        @Generated
        private ArrayList<String> roles$key;
        @Generated
        private ArrayList<List<ResourceAction>> roles$value;

        @Generated
        Builder() {
        }

        @JsonProperty
        @Generated
        public Builder minImplyVersion(ComparableVersion minImplyVersion) {
            this.minImplyVersion = minImplyVersion;
            return this;
        }

        @Generated
        public Builder role(String roleKey, List<ResourceAction> roleValue) {
            if (this.roles$key == null) {
                this.roles$key = new ArrayList();
                this.roles$value = new ArrayList();
            }
            this.roles$key.add(roleKey);
            this.roles$value.add(roleValue);
            return this;
        }

        @JsonProperty
        @Generated
        public Builder roles(Map<? extends String, ? extends List<ResourceAction>> roles) {
            if (roles == null) {
                throw new NullPointerException("roles cannot be null");
            }
            if (this.roles$key == null) {
                this.roles$key = new ArrayList();
                this.roles$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends List<ResourceAction>> $lombokEntry : roles.entrySet()) {
                this.roles$key.add($lombokEntry.getKey());
                this.roles$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public Builder clearRoles() {
            if (this.roles$key != null) {
                this.roles$key.clear();
                this.roles$value.clear();
            }
            return this;
        }

        @Generated
        public DruidRoleMapping build() {
            Map<String, List<ResourceAction>> roles;
            switch (this.roles$key == null ? 0 : this.roles$key.size()) {
                case 0: {
                    roles = Collections.emptyMap();
                    break;
                }
                case 1: {
                    roles = Collections.singletonMap(this.roles$key.get(0), this.roles$value.get(0));
                    break;
                }
                default: {
                    roles = new LinkedHashMap<String, List<ResourceAction>>(this.roles$key.size() < 0x40000000 ? 1 + this.roles$key.size() + (this.roles$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.roles$key.size(); ++$i) {
                        roles.put(this.roles$key.get($i), this.roles$value.get($i));
                    }
                    roles = Collections.unmodifiableMap(roles);
                }
            }
            return new DruidRoleMapping(this.minImplyVersion, roles);
        }

        @Generated
        public String toString() {
            return "DruidRoleMapping.Builder(minImplyVersion=" + String.valueOf(this.minImplyVersion) + ", roles$key=" + String.valueOf(this.roles$key) + ", roles$value=" + String.valueOf(this.roles$value) + ")";
        }
    }
}

