/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.model.ComparableVersion;
import io.imply.cloud.model.ImplyVersion;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DruidExtensions {
    private final ComparableVersion minImplyVersion;
    private final List<String> baseLoadList;
    private final List<String> baseExtensionPaths;
    private final List<String> optionalExtensions;
    private final Map<String, String> optionalExtensionPaths;
    private final List<String> defaultHadoopCoordinates;
    private final List<String> baseHadoopDependenciesPaths;
    private final Set<String> allExtensions;

    @JsonCreator
    public DruidExtensions(@JsonProperty(value="minImplyVersion") ComparableVersion minImplyVersion, @JsonProperty(value="baseLoadList") List<String> baseLoadList, @JsonProperty(value="baseExtensionPaths") List<String> baseExtensionPaths, @JsonProperty(value="optionalExtensions") List<String> optionalExtensions, @JsonProperty(value="optionalExtensionPaths") Map<String, String> optionalExtensionPaths, @JsonProperty(value="defaultHadoopCoordinates") List<String> defaultHadoopCoordinates, @JsonProperty(value="baseHadoopDependenciesPaths") List<String> baseHadoopDependenciesPaths) {
        this.minImplyVersion = minImplyVersion;
        this.baseLoadList = baseLoadList;
        this.baseExtensionPaths = baseExtensionPaths;
        this.optionalExtensions = optionalExtensions;
        this.optionalExtensionPaths = optionalExtensionPaths;
        this.defaultHadoopCoordinates = defaultHadoopCoordinates;
        this.baseHadoopDependenciesPaths = baseHadoopDependenciesPaths;
        this.allExtensions = ImmutableSet.builder().addAll(baseLoadList).addAll(optionalExtensions).build();
    }

    @JsonProperty
    public ComparableVersion getMinImplyVersion() {
        return this.minImplyVersion;
    }

    public List<String> getBaseLoadList() {
        return this.baseLoadList;
    }

    public List<String> getBaseExtensionPaths() {
        return this.baseExtensionPaths;
    }

    @JsonProperty
    public List<String> getOptionalExtensions() {
        return this.optionalExtensions;
    }

    public Map<String, String> getOptionalExtensionPaths() {
        return this.optionalExtensionPaths;
    }

    public List<String> getDefaultHadoopCoordinates() {
        return this.defaultHadoopCoordinates;
    }

    public List<String> getBaseHadoopDependenciesPaths() {
        return this.baseHadoopDependenciesPaths;
    }

    public Set<String> getAllExtensions() {
        return this.allExtensions;
    }

    public String toString() {
        return new ToStringBuilder(this).append("minImplyVersion", this.minImplyVersion).append("baseLoadList", this.baseLoadList).append("baseExtensionPaths", this.baseExtensionPaths).append("optionalExtensions", this.optionalExtensions).append("optionalExtensionPaths", this.optionalExtensionPaths).append("defaultHadoopCoordinates", this.defaultHadoopCoordinates).append("baseHadoopDependenciesPaths", this.baseHadoopDependenciesPaths).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DruidExtensions that = (DruidExtensions)o;
        if (this.minImplyVersion != null ? !this.minImplyVersion.equals(that.minImplyVersion) : that.minImplyVersion != null) {
            return false;
        }
        if (this.baseLoadList != null ? !this.baseLoadList.equals(that.baseLoadList) : that.baseLoadList != null) {
            return false;
        }
        if (this.baseExtensionPaths != null ? !this.baseExtensionPaths.equals(that.baseExtensionPaths) : that.baseExtensionPaths != null) {
            return false;
        }
        if (this.optionalExtensions != null ? !this.optionalExtensions.equals(that.optionalExtensions) : that.optionalExtensions != null) {
            return false;
        }
        if (this.optionalExtensionPaths != null ? !this.optionalExtensionPaths.equals(that.optionalExtensionPaths) : that.optionalExtensionPaths != null) {
            return false;
        }
        if (this.defaultHadoopCoordinates != null ? !this.defaultHadoopCoordinates.equals(that.defaultHadoopCoordinates) : that.defaultHadoopCoordinates != null) {
            return false;
        }
        return !(this.baseHadoopDependenciesPaths == null ? that.baseHadoopDependenciesPaths != null : !this.baseHadoopDependenciesPaths.equals(that.baseHadoopDependenciesPaths));
    }

    public int hashCode() {
        int result = this.minImplyVersion != null ? this.minImplyVersion.hashCode() : 0;
        result = 31 * result + (this.baseLoadList != null ? this.baseLoadList.hashCode() : 0);
        result = 31 * result + (this.baseExtensionPaths != null ? this.baseExtensionPaths.hashCode() : 0);
        result = 31 * result + (this.optionalExtensions != null ? this.optionalExtensions.hashCode() : 0);
        result = 31 * result + (this.optionalExtensionPaths != null ? this.optionalExtensionPaths.hashCode() : 0);
        result = 31 * result + (this.defaultHadoopCoordinates != null ? this.defaultHadoopCoordinates.hashCode() : 0);
        result = 31 * result + (this.baseHadoopDependenciesPaths != null ? this.baseHadoopDependenciesPaths.hashCode() : 0);
        return result;
    }

    public static DruidExtensions getForImplyVersion(ImplyVersion version, RefreshableConstants refreshableConstants) {
        return version == null || version.getComparableVersion() == null ? null : (DruidExtensions)refreshableConstants.getDruidExtensions().stream().sorted(Comparator.comparing(DruidExtensions::getMinImplyVersion).reversed()).filter(x -> version.getComparableVersion().compareTo(x.getMinImplyVersion()) >= 0).findFirst().orElse(null);
    }
}

