/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.model.ComparableVersion;
import io.imply.cloud.model.ImplyVersion;
import io.imply.cloud.util.MapUtils;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DruidConfiguration {
    private final ComparableVersion minImplyVersion;
    private final Map<String, String> commonRuntimeProperties;
    private final Map<String, String> brokerRuntimeProperties;
    private final List<String> brokerJvmConfig;
    private final Map<String, String> coordinatorRuntimeProperties;
    private final List<String> coordinatorJvmConfig;
    private final Map<String, String> historicalRuntimeProperties;
    private final List<String> historicalJvmConfig;
    private final Map<String, String> middleManagerRuntimeProperties;
    private final List<String> middleManagerJvmConfig;
    private final Map<String, String> indexerRuntimeProperties;
    private final List<String> indexerJvmConfig;
    private final Map<String, String> overlordRuntimeProperties;
    private final List<String> overlordJvmConfig;
    private final Map<String, String> routerRuntimeProperties;
    private final List<String> routerJvmConfig;
    private final Map<String, String> coldHistoricalRuntimeProperties;
    private final List<String> coldHistoricalJvmConfig;
    private final Map<String, String> coldBrokerRuntimeProperties;
    private final List<String> coldBrokerJvmConfig;
    private final Map<String, String> peonRuntimeProperties;
    private final List<String> peonJvmConfig;

    @JsonCreator
    public DruidConfiguration(@JsonProperty(value="minImplyVersion") ComparableVersion minImplyVersion, @JsonProperty(value="commonRuntimeProperties") Map<String, String> commonRuntimeProperties, @JsonProperty(value="brokerRuntimeProperties") Map<String, String> brokerRuntimeProperties, @JsonProperty(value="brokerJvmConfig") List<String> brokerJvmConfig, @JsonProperty(value="coordinatorRuntimeProperties") Map<String, String> coordinatorRuntimeProperties, @JsonProperty(value="coordinatorJvmConfig") List<String> coordinatorJvmConfig, @JsonProperty(value="historicalRuntimeProperties") Map<String, String> historicalRuntimeProperties, @JsonProperty(value="historicalJvmConfig") List<String> historicalJvmConfig, @JsonProperty(value="middleManagerRuntimeProperties") Map<String, String> middleManagerRuntimeProperties, @JsonProperty(value="middleManagerJvmConfig") List<String> middleManagerJvmConfig, @JsonProperty(value="indexerRuntimeProperties") Map<String, String> indexerRuntimeProperties, @JsonProperty(value="indexerJvmConfig") List<String> indexerJvmConfig, @JsonProperty(value="overlordRuntimeProperties") Map<String, String> overlordRuntimeProperties, @JsonProperty(value="overlordJvmConfig") List<String> overlordJvmConfig, @JsonProperty(value="routerRuntimeProperties") Map<String, String> routerRuntimeProperties, @JsonProperty(value="routerJvmConfig") List<String> routerJvmConfig, @JsonProperty(value="coldHistoricalRuntimeProperties") Map<String, String> coldHistoricalRuntimeProperties, @JsonProperty(value="coldHistoricalJvmConfig") List<String> coldHistoricalJvmConfig, @JsonProperty(value="coldBrokerRuntimeProperties") Map<String, String> coldBrokerRuntimeProperties, @JsonProperty(value="coldBrokerJvmConfig") List<String> coldBrokerJvmConfig, @JsonProperty(value="peonRuntimeProperties") Map<String, String> peonRuntimeProperties, @JsonProperty(value="peonJvmConfig") List<String> peonJvmConfig) {
        this.minImplyVersion = minImplyVersion;
        this.commonRuntimeProperties = commonRuntimeProperties;
        this.brokerRuntimeProperties = brokerRuntimeProperties;
        this.brokerJvmConfig = brokerJvmConfig;
        this.coordinatorRuntimeProperties = coordinatorRuntimeProperties;
        this.coordinatorJvmConfig = coordinatorJvmConfig;
        this.historicalRuntimeProperties = historicalRuntimeProperties;
        this.historicalJvmConfig = historicalJvmConfig;
        this.middleManagerRuntimeProperties = middleManagerRuntimeProperties;
        this.middleManagerJvmConfig = middleManagerJvmConfig;
        this.indexerRuntimeProperties = indexerRuntimeProperties;
        this.indexerJvmConfig = indexerJvmConfig;
        this.overlordRuntimeProperties = overlordRuntimeProperties;
        this.overlordJvmConfig = overlordJvmConfig;
        this.routerRuntimeProperties = routerRuntimeProperties;
        this.routerJvmConfig = routerJvmConfig;
        this.coldBrokerRuntimeProperties = coldBrokerRuntimeProperties;
        this.coldBrokerJvmConfig = coldBrokerJvmConfig;
        this.coldHistoricalRuntimeProperties = coldHistoricalRuntimeProperties;
        this.coldHistoricalJvmConfig = coldHistoricalJvmConfig;
        this.peonRuntimeProperties = peonRuntimeProperties;
        this.peonJvmConfig = peonJvmConfig;
    }

    @JsonProperty
    public ComparableVersion getMinImplyVersion() {
        return this.minImplyVersion;
    }

    @JsonProperty
    public Map<String, String> getCommonRuntimeProperties() {
        return this.commonRuntimeProperties;
    }

    @JsonProperty
    public Map<String, String> getBrokerRuntimeProperties() {
        return this.brokerRuntimeProperties;
    }

    @JsonProperty
    public List<String> getBrokerJvmConfig() {
        return this.brokerJvmConfig;
    }

    @JsonProperty
    public Map<String, String> getCoordinatorRuntimeProperties() {
        return this.coordinatorRuntimeProperties;
    }

    @JsonProperty
    public List<String> getCoordinatorJvmConfig() {
        return this.coordinatorJvmConfig;
    }

    @JsonProperty
    public Map<String, String> getHistoricalRuntimeProperties() {
        return this.historicalRuntimeProperties;
    }

    @JsonProperty
    public List<String> getHistoricalJvmConfig() {
        return this.historicalJvmConfig;
    }

    @JsonProperty
    public Map<String, String> getMiddleManagerRuntimeProperties() {
        return this.middleManagerRuntimeProperties;
    }

    @JsonProperty
    public List<String> getMiddleManagerJvmConfig() {
        return this.middleManagerJvmConfig;
    }

    @JsonProperty
    public Map<String, String> getIndexerRuntimeProperties() {
        return this.indexerRuntimeProperties;
    }

    @JsonProperty
    public List<String> getIndexerJvmConfig() {
        return this.indexerJvmConfig;
    }

    @JsonProperty
    public Map<String, String> getOverlordRuntimeProperties() {
        return this.overlordRuntimeProperties;
    }

    @JsonProperty
    public List<String> getOverlordJvmConfig() {
        return this.overlordJvmConfig;
    }

    @JsonProperty
    public Map<String, String> getRouterRuntimeProperties() {
        return this.routerRuntimeProperties;
    }

    @JsonProperty
    public List<String> getRouterJvmConfig() {
        return this.routerJvmConfig;
    }

    @JsonProperty
    public Map<String, String> getColdHistoricalRuntimeProperties() {
        return this.coldHistoricalRuntimeProperties;
    }

    @JsonProperty
    public List<String> getColdHistoricalJvmConfig() {
        return this.coldHistoricalJvmConfig;
    }

    @JsonProperty
    public Map<String, String> getColdBrokerRuntimeProperties() {
        return this.coldBrokerRuntimeProperties;
    }

    @JsonProperty
    public List<String> getColdBrokerJvmConfig() {
        return this.coldBrokerJvmConfig;
    }

    @JsonProperty
    public Map<String, String> getPeonRuntimeProperties() {
        return this.peonRuntimeProperties;
    }

    @JsonProperty
    public List<String> getPeonJvmConfig() {
        return this.peonJvmConfig;
    }

    public String toString() {
        return new ToStringBuilder(this).append("minImplyVersion", this.minImplyVersion).append("commonRuntimeProperties", this.commonRuntimeProperties).append("brokerRuntimeProperties", this.brokerRuntimeProperties).append("brokerJvmConfig", this.brokerJvmConfig).append("coordinatorRuntimeProperties", this.coordinatorRuntimeProperties).append("coordinatorJvmConfig", this.coordinatorJvmConfig).append("historicalRuntimeProperties", this.historicalRuntimeProperties).append("historicalJvmConfig", this.historicalJvmConfig).append("middleManagerRuntimeProperties", this.middleManagerRuntimeProperties).append("middleManagerJvmConfig", this.middleManagerJvmConfig).append("indexerRuntimeProperties", this.indexerRuntimeProperties).append("indexerJvmConfig", this.indexerJvmConfig).append("overlordRuntimeProperties", this.overlordRuntimeProperties).append("overlordJvmConfig", this.overlordJvmConfig).append("routerRuntimeProperties", this.routerRuntimeProperties).append("routerJvmConfig", this.routerJvmConfig).append("coldHistoricalRuntimeProperties", this.coldHistoricalRuntimeProperties).append("coldHistoricalJvmConfig", this.coldHistoricalJvmConfig).append("coldBrokerRuntimeProperties", this.coldBrokerRuntimeProperties).append("coldBrokerJvmConfig", this.coldBrokerJvmConfig).append("peonRuntimeProperties", this.peonRuntimeProperties).append("peonJvmConfig", this.peonJvmConfig).toString();
    }

    public DruidConfiguration merge(DruidConfiguration other) {
        if (other == null) {
            return this;
        }
        ComparableVersion minImplyVersion = other.minImplyVersion != null ? other.minImplyVersion : this.minImplyVersion;
        Map<String, String> commonRuntimeProperties = MapUtils.mergePropertyMap(this.commonRuntimeProperties, other.commonRuntimeProperties);
        Map<String, String> brokerRuntimeProperties = MapUtils.mergePropertyMap(this.brokerRuntimeProperties, other.brokerRuntimeProperties);
        List<String> brokerJvmConfig = other.brokerJvmConfig != null ? other.brokerJvmConfig : this.brokerJvmConfig;
        Map<String, String> coordinatorRuntimeProperties = MapUtils.mergePropertyMap(this.coordinatorRuntimeProperties, other.coordinatorRuntimeProperties);
        List<String> coordinatorJvmConfig = other.coordinatorJvmConfig != null ? other.coordinatorJvmConfig : this.coordinatorJvmConfig;
        Map<String, String> historicalRuntimeProperties = MapUtils.mergePropertyMap(this.historicalRuntimeProperties, other.historicalRuntimeProperties);
        List<String> historicalJvmConfig = other.historicalJvmConfig != null ? other.historicalJvmConfig : this.historicalJvmConfig;
        Map<String, String> middleManagerRuntimeProperties = MapUtils.mergePropertyMap(this.middleManagerRuntimeProperties, other.middleManagerRuntimeProperties);
        List<String> middleManagerJvmConfig = other.middleManagerJvmConfig != null ? other.middleManagerJvmConfig : this.middleManagerJvmConfig;
        Map<String, String> indexerRuntimeProperties = MapUtils.mergePropertyMap(this.indexerRuntimeProperties, other.indexerRuntimeProperties);
        List<String> indexerJvmConfig = other.indexerJvmConfig != null ? other.indexerJvmConfig : this.indexerJvmConfig;
        Map<String, String> overlordRuntimeProperties = MapUtils.mergePropertyMap(this.overlordRuntimeProperties, other.overlordRuntimeProperties);
        List<String> overlordJvmConfig = other.overlordJvmConfig != null ? other.overlordJvmConfig : this.overlordJvmConfig;
        Map<String, String> routerRuntimeProperties = MapUtils.mergePropertyMap(this.routerRuntimeProperties, other.routerRuntimeProperties);
        List<String> routerJvmConfig = other.routerJvmConfig != null ? other.routerJvmConfig : this.routerJvmConfig;
        Map<String, String> coldHistoricalRuntimeProperties = MapUtils.mergePropertyMap(this.coldHistoricalRuntimeProperties, other.coldHistoricalRuntimeProperties);
        List<String> coldHistoricalJvmConfig = other.coldHistoricalJvmConfig != null ? other.coldHistoricalJvmConfig : this.coldHistoricalJvmConfig;
        Map<String, String> coldBrokerRuntimeProperties = MapUtils.mergePropertyMap(this.coldBrokerRuntimeProperties, other.coldBrokerRuntimeProperties);
        List<String> coldBrokerJvmConfig = other.coldBrokerJvmConfig != null ? other.coldBrokerJvmConfig : this.coldBrokerJvmConfig;
        Map<String, String> peonRuntimeProperties = MapUtils.mergePropertyMap(this.peonRuntimeProperties, other.peonRuntimeProperties);
        List<String> peonJvmConfig = other.peonJvmConfig != null ? other.peonJvmConfig : this.peonJvmConfig;
        return new DruidConfiguration(minImplyVersion, commonRuntimeProperties, brokerRuntimeProperties, brokerJvmConfig, coordinatorRuntimeProperties, coordinatorJvmConfig, historicalRuntimeProperties, historicalJvmConfig, middleManagerRuntimeProperties, middleManagerJvmConfig, indexerRuntimeProperties, indexerJvmConfig, overlordRuntimeProperties, overlordJvmConfig, routerRuntimeProperties, routerJvmConfig, coldHistoricalRuntimeProperties, coldHistoricalJvmConfig, coldBrokerRuntimeProperties, coldBrokerJvmConfig, peonRuntimeProperties, peonJvmConfig);
    }

    public boolean isNotEmpty() {
        return this.minImplyVersion != null && (this.commonRuntimeProperties != null || this.brokerRuntimeProperties != null || this.brokerJvmConfig != null || this.coordinatorRuntimeProperties != null || this.coordinatorJvmConfig != null || this.historicalRuntimeProperties != null || this.historicalJvmConfig != null || this.middleManagerRuntimeProperties != null || this.middleManagerJvmConfig != null || this.indexerRuntimeProperties != null || this.indexerJvmConfig != null || this.overlordRuntimeProperties != null || this.overlordJvmConfig != null || this.routerRuntimeProperties != null || this.routerJvmConfig != null || this.coldHistoricalRuntimeProperties != null || this.coldHistoricalJvmConfig != null || this.coldBrokerRuntimeProperties != null || this.coldBrokerJvmConfig != null || this.peonRuntimeProperties != null || this.peonJvmConfig != null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DruidConfiguration that = (DruidConfiguration)o;
        return Objects.equals(this.minImplyVersion, that.minImplyVersion) && Objects.equals(this.commonRuntimeProperties, that.commonRuntimeProperties) && Objects.equals(this.brokerRuntimeProperties, that.brokerRuntimeProperties) && Objects.equals(this.brokerJvmConfig, that.brokerJvmConfig) && Objects.equals(this.coordinatorRuntimeProperties, that.coordinatorRuntimeProperties) && Objects.equals(this.coordinatorJvmConfig, that.coordinatorJvmConfig) && Objects.equals(this.historicalRuntimeProperties, that.historicalRuntimeProperties) && Objects.equals(this.historicalJvmConfig, that.historicalJvmConfig) && Objects.equals(this.middleManagerRuntimeProperties, that.middleManagerRuntimeProperties) && Objects.equals(this.middleManagerJvmConfig, that.middleManagerJvmConfig) && Objects.equals(this.indexerRuntimeProperties, that.indexerRuntimeProperties) && Objects.equals(this.indexerJvmConfig, that.indexerJvmConfig) && Objects.equals(this.overlordRuntimeProperties, that.overlordRuntimeProperties) && Objects.equals(this.overlordJvmConfig, that.overlordJvmConfig) && Objects.equals(this.routerRuntimeProperties, that.routerRuntimeProperties) && Objects.equals(this.routerJvmConfig, that.routerJvmConfig) && Objects.equals(this.coldHistoricalRuntimeProperties, that.coldHistoricalRuntimeProperties) && Objects.equals(this.coldHistoricalJvmConfig, that.coldHistoricalJvmConfig) && Objects.equals(this.coldBrokerRuntimeProperties, that.coldBrokerRuntimeProperties) && Objects.equals(this.coldBrokerJvmConfig, that.coldBrokerJvmConfig) && Objects.equals(this.peonRuntimeProperties, that.peonRuntimeProperties) && Objects.equals(this.peonJvmConfig, that.peonJvmConfig);
    }

    public int hashCode() {
        return Objects.hash(this.minImplyVersion, this.commonRuntimeProperties, this.brokerRuntimeProperties, this.brokerJvmConfig, this.coordinatorRuntimeProperties, this.coordinatorJvmConfig, this.historicalRuntimeProperties, this.historicalJvmConfig, this.middleManagerRuntimeProperties, this.middleManagerJvmConfig, this.indexerRuntimeProperties, this.indexerJvmConfig, this.overlordRuntimeProperties, this.overlordJvmConfig, this.routerRuntimeProperties, this.routerJvmConfig, this.coldHistoricalRuntimeProperties, this.coldHistoricalJvmConfig, this.coldBrokerRuntimeProperties, this.coldBrokerJvmConfig, this.peonRuntimeProperties, this.peonJvmConfig);
    }

    public static DruidConfiguration getForImplyVersion(ImplyVersion version, RefreshableConstants refreshableConstants) {
        if (version == null || version.getComparableVersion() == null) {
            return null;
        }
        List configurations = refreshableConstants.getDruidConfigurations().stream().sorted(Comparator.comparing(DruidConfiguration::getMinImplyVersion)).collect(Collectors.toList());
        DruidConfiguration mergedConfiguration = null;
        for (DruidConfiguration configuration : configurations) {
            if (configuration.getMinImplyVersion().compareTo(version.getComparableVersion()) > 0) continue;
            mergedConfiguration = mergedConfiguration == null ? configuration : mergedConfiguration.merge(configuration);
        }
        return mergedConfiguration;
    }
}

