/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.imply.cloud.util.ToStringBuilder;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public class ConfigRequestBody {
    private final String clusterId;
    private final String instanceType;
    private final Integer instanceTier;
    private final String instanceId;
    private final List<String> serviceTypes;
    private final String key;
    private final String templateVersion;
    private final List<String> privateIpAddresses;
    private final List<String> publicIpAddresses;
    private final List<String> privateHostnames;
    private final List<String> publicHostnames;
    private final Integer configVersion;
    private final String availabilityZone;

    @JsonCreator
    public ConfigRequestBody(@JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="instanceType") String instanceType, @JsonProperty(value="instanceTier") Integer instanceTier, @JsonProperty(value="instanceId") String instanceId, @Deprecated @JsonProperty(value="serviceType") String serviceType, @JsonProperty(value="serviceTypes") List<String> serviceTypes, @JsonProperty(value="key") String key, @JsonProperty(value="templateVersion") String templateVersion, @JsonProperty(value="privateIpAddresses") List<String> privateIpAddresses, @JsonProperty(value="publicIpAddresses") List<String> publicIpAddresses, @JsonProperty(value="privateHostnames") List<String> privateHostnames, @JsonProperty(value="publicHostnames") List<String> publicHostnames, @JsonProperty(value="configVersion") Integer configVersion, @JsonProperty(value="availabilityZone") String availabilityZone) {
        this.clusterId = clusterId;
        this.instanceType = instanceType;
        this.instanceTier = instanceTier;
        this.instanceId = instanceId;
        this.serviceTypes = serviceTypes != null ? serviceTypes : (serviceType != null ? ImmutableList.of((Object)serviceType) : null);
        this.key = key;
        this.templateVersion = templateVersion;
        this.privateIpAddresses = privateIpAddresses;
        this.publicIpAddresses = publicIpAddresses;
        this.privateHostnames = privateHostnames;
        this.publicHostnames = publicHostnames;
        this.configVersion = configVersion;
        this.availabilityZone = availabilityZone;
    }

    @JsonProperty
    public String getClusterId() {
        return this.clusterId;
    }

    @JsonProperty
    public String getInstanceType() {
        return this.instanceType;
    }

    @JsonProperty
    public Integer getInstanceTier() {
        return this.instanceTier;
    }

    @JsonProperty
    public String getInstanceId() {
        return this.instanceId;
    }

    @JsonProperty
    public List<String> getServiceTypes() {
        return this.serviceTypes;
    }

    @JsonProperty
    public String getKey() {
        return this.key;
    }

    @JsonProperty
    public String getTemplateVersion() {
        return this.templateVersion;
    }

    @JsonProperty
    public List<String> getPrivateIpAddresses() {
        return this.privateIpAddresses;
    }

    @JsonProperty
    public List<String> getPublicIpAddresses() {
        return this.publicIpAddresses;
    }

    @JsonProperty
    public List<String> getPrivateHostnames() {
        return this.privateHostnames;
    }

    @JsonProperty
    public List<String> getPublicHostnames() {
        return this.publicHostnames;
    }

    public String getMyPrivateIpAddress() {
        if (this.privateIpAddresses == null || this.privateIpAddresses.isEmpty()) {
            return "127.0.0.1";
        }
        return this.privateIpAddresses.get(0);
    }

    public String getMyPrivateHostname() {
        if (this.privateHostnames == null || this.privateHostnames.isEmpty()) {
            return "127.0.0.1";
        }
        return this.privateHostnames.get(0);
    }

    public Integer getConfigVersion() {
        return this.configVersion;
    }

    @JsonProperty
    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public String toString() {
        return new ToStringBuilder(this).append("clusterId", this.clusterId).append("instanceType", (Object)this.instanceType).append("instanceTier", (Object)this.instanceTier).append("instanceId", (Object)this.instanceId).append("serviceTypes", this.serviceTypes).append("key", (Object)"*****************").append("templateVersion", (Object)this.templateVersion).append("privateIpAddresses", this.privateIpAddresses).append("publicIpAddresses", this.publicIpAddresses).append("privateHostnames", this.privateHostnames).append("publicHostnames", this.publicHostnames).append("configVersion", (Object)this.configVersion).append("availabilityZone", (Object)this.availabilityZone).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigRequestBody that = (ConfigRequestBody)o;
        return Objects.equals(this.clusterId, that.clusterId) && Objects.equals(this.instanceType, that.instanceType) && Objects.equals(this.instanceTier, that.instanceTier) && Objects.equals(this.instanceId, that.instanceId) && Objects.equals(this.serviceTypes, that.serviceTypes) && Objects.equals(this.key, that.key) && Objects.equals(this.templateVersion, that.templateVersion) && Objects.equals(this.privateIpAddresses, that.privateIpAddresses) && Objects.equals(this.publicIpAddresses, that.publicIpAddresses) && Objects.equals(this.privateHostnames, that.privateHostnames) && Objects.equals(this.publicHostnames, that.publicHostnames) && Objects.equals(this.configVersion, that.configVersion) && Objects.equals(this.availabilityZone, that.availabilityZone);
    }

    public int hashCode() {
        return Objects.hash(this.clusterId, this.instanceType, this.instanceTier, this.instanceId, this.serviceTypes, this.key, this.templateVersion, this.privateIpAddresses, this.publicIpAddresses, this.privateHostnames, this.publicHostnames, this.configVersion, this.availabilityZone);
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Builder toBuilder() {
        return new Builder().clusterId(this.clusterId).instanceType(this.instanceType).instanceTier(this.instanceTier).instanceId(this.instanceId).serviceTypes(this.serviceTypes).key(this.key).templateVersion(this.templateVersion).privateIpAddresses(this.privateIpAddresses).publicIpAddresses(this.publicIpAddresses).privateHostnames(this.privateHostnames).publicHostnames(this.publicHostnames).configVersion(this.configVersion).availabilityZone(this.availabilityZone);
    }

    @Generated
    public ConfigRequestBody(String clusterId, String instanceType, Integer instanceTier, String instanceId, List<String> serviceTypes, String key, String templateVersion, List<String> privateIpAddresses, List<String> publicIpAddresses, List<String> privateHostnames, List<String> publicHostnames, Integer configVersion, String availabilityZone) {
        this.clusterId = clusterId;
        this.instanceType = instanceType;
        this.instanceTier = instanceTier;
        this.instanceId = instanceId;
        this.serviceTypes = serviceTypes;
        this.key = key;
        this.templateVersion = templateVersion;
        this.privateIpAddresses = privateIpAddresses;
        this.publicIpAddresses = publicIpAddresses;
        this.privateHostnames = privateHostnames;
        this.publicHostnames = publicHostnames;
        this.configVersion = configVersion;
        this.availabilityZone = availabilityZone;
    }

    @Generated
    public static class Builder {
        @Generated
        private String clusterId;
        @Generated
        private String instanceType;
        @Generated
        private Integer instanceTier;
        @Generated
        private String instanceId;
        @Generated
        private List<String> serviceTypes;
        @Generated
        private String key;
        @Generated
        private String templateVersion;
        @Generated
        private List<String> privateIpAddresses;
        @Generated
        private List<String> publicIpAddresses;
        @Generated
        private List<String> privateHostnames;
        @Generated
        private List<String> publicHostnames;
        @Generated
        private Integer configVersion;
        @Generated
        private String availabilityZone;

        @Generated
        Builder() {
        }

        @Generated
        public Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        @Generated
        public Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Generated
        public Builder instanceTier(Integer instanceTier) {
            this.instanceTier = instanceTier;
            return this;
        }

        @Generated
        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        @Generated
        public Builder serviceTypes(List<String> serviceTypes) {
            this.serviceTypes = serviceTypes;
            return this;
        }

        @Generated
        public Builder key(String key) {
            this.key = key;
            return this;
        }

        @Generated
        public Builder templateVersion(String templateVersion) {
            this.templateVersion = templateVersion;
            return this;
        }

        @Generated
        public Builder privateIpAddresses(List<String> privateIpAddresses) {
            this.privateIpAddresses = privateIpAddresses;
            return this;
        }

        @Generated
        public Builder publicIpAddresses(List<String> publicIpAddresses) {
            this.publicIpAddresses = publicIpAddresses;
            return this;
        }

        @Generated
        public Builder privateHostnames(List<String> privateHostnames) {
            this.privateHostnames = privateHostnames;
            return this;
        }

        @Generated
        public Builder publicHostnames(List<String> publicHostnames) {
            this.publicHostnames = publicHostnames;
            return this;
        }

        @Generated
        public Builder configVersion(Integer configVersion) {
            this.configVersion = configVersion;
            return this;
        }

        @Generated
        public Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        @Generated
        public ConfigRequestBody build() {
            return new ConfigRequestBody(this.clusterId, this.instanceType, this.instanceTier, this.instanceId, this.serviceTypes, this.key, this.templateVersion, this.privateIpAddresses, this.publicIpAddresses, this.privateHostnames, this.publicHostnames, this.configVersion, this.availabilityZone);
        }

        @Generated
        public String toString() {
            return "ConfigRequestBody.Builder(clusterId=" + this.clusterId + ", instanceType=" + this.instanceType + ", instanceTier=" + this.instanceTier + ", instanceId=" + this.instanceId + ", serviceTypes=" + String.valueOf(this.serviceTypes) + ", key=" + this.key + ", templateVersion=" + this.templateVersion + ", privateIpAddresses=" + String.valueOf(this.privateIpAddresses) + ", publicIpAddresses=" + String.valueOf(this.publicIpAddresses) + ", privateHostnames=" + String.valueOf(this.privateHostnames) + ", publicHostnames=" + String.valueOf(this.publicHostnames) + ", configVersion=" + this.configVersion + ", availabilityZone=" + this.availabilityZone + ")";
        }
    }
}

