/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ComparableVersion;
import io.imply.cloud.model.InstanceTier;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class ClusterSizeDetails {
    @JsonProperty
    private ComparableVersion minImplyVersion;
    @JsonProperty
    private String masterInstanceType;
    @JsonProperty
    private Integer masterInstanceCount;
    @JsonProperty
    private String queryInstanceType;
    @JsonProperty
    private Integer queryInstanceCount;
    @JsonProperty
    Map<Integer, InstanceTier> dataInstanceTiers;

    public String toString() {
        return new ToStringBuilder(this).append("minImplyVersion", this.minImplyVersion).append("masterInstanceType", (Object)this.masterInstanceType).append("masterInstanceCount", (Object)this.masterInstanceCount).append("queryInstanceType", (Object)this.queryInstanceType).append("queryInstanceCount", (Object)this.queryInstanceCount).append("dataInstanceTiers", this.dataInstanceTiers).toString();
    }

    public static ClusterSizeDetails getForComparableImplyVersion(String projectSize, ComparableVersion comparableVersion, RefreshableConstants refreshableConstants) {
        if (StringUtils.isBlank((CharSequence)projectSize) || comparableVersion == null) {
            return null;
        }
        Map<String, List<ClusterSizeDetails>> projectSizeMap = refreshableConstants.getProjectSizeMap();
        if (!projectSizeMap.containsKey(projectSize)) {
            return null;
        }
        List<ClusterSizeDetails> versionedSizeDetails = projectSizeMap.get(projectSize);
        return versionedSizeDetails.stream().sorted(Comparator.comparing(ClusterSizeDetails::getMinImplyVersion).reversed()).filter(x -> comparableVersion.compareTo(x.getMinImplyVersion()) >= 0).findFirst().orElse(null);
    }

    public static Optional<String> getProjectSizeFromCluster(Cluster cluster, RefreshableConstants refreshableConstants) {
        if (cluster == null) {
            return Optional.empty();
        }
        Map<String, List<ClusterSizeDetails>> projectSizeMap = refreshableConstants.getProjectSizeMap();
        for (Map.Entry<String, List<ClusterSizeDetails>> projectSizeAndDetails : projectSizeMap.entrySet()) {
            String size = projectSizeAndDetails.getKey();
            Optional<ClusterSizeDetails> matchingDetails = projectSizeAndDetails.getValue().stream().sorted(Comparator.comparing(ClusterSizeDetails::getMinImplyVersion).reversed()).filter(s -> s.equalAndVersionLessOrEqual(cluster)).findFirst();
            if (!matchingDetails.isPresent()) continue;
            return Optional.of(size);
        }
        return Optional.empty();
    }

    private boolean equalAndVersionLessOrEqual(Cluster cluster) {
        return this.equalDataInstanceTiers(cluster) && this.getMasterInstanceCount().equals(cluster.getMasterInstanceCount()) && this.getMasterInstanceType().equals(cluster.getMasterInstanceType()) && this.getQueryInstanceCount().equals(cluster.getQueryInstanceCount()) && this.getQueryInstanceType().equals(cluster.getQueryInstanceType()) && this.getMinImplyVersion().compareTo(new ComparableVersion(cluster.getImplyVersion())) <= 0;
    }

    public boolean equalDataInstanceTiers(Cluster cluster) {
        if (cluster.getDataInstanceTiers() == null) {
            return false;
        }
        return cluster.getDataInstanceTiers().entrySet().stream().filter(e -> ((InstanceTier)e.getValue()).getInstanceCount() > 0).allMatch(e -> {
            int expectedTier = (Integer)e.getKey() % 2 == 0 ? (Integer)e.getKey() - 1 : (Integer)e.getKey();
            InstanceTier currentTier = this.getDataInstanceTiers().get(expectedTier);
            if (currentTier == null) {
                return false;
            }
            return currentTier.getInstanceCount().equals(((InstanceTier)e.getValue()).getInstanceCount()) && currentTier.getInstanceType().equals(((InstanceTier)e.getValue()).getInstanceType());
        });
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    private ClusterSizeDetails() {
    }

    @Generated
    public ClusterSizeDetails(ComparableVersion minImplyVersion, String masterInstanceType, Integer masterInstanceCount, String queryInstanceType, Integer queryInstanceCount, Map<Integer, InstanceTier> dataInstanceTiers) {
        this.minImplyVersion = minImplyVersion;
        this.masterInstanceType = masterInstanceType;
        this.masterInstanceCount = masterInstanceCount;
        this.queryInstanceType = queryInstanceType;
        this.queryInstanceCount = queryInstanceCount;
        this.dataInstanceTiers = dataInstanceTiers;
    }

    @Generated
    public ComparableVersion getMinImplyVersion() {
        return this.minImplyVersion;
    }

    @Generated
    public String getMasterInstanceType() {
        return this.masterInstanceType;
    }

    @Generated
    public Integer getMasterInstanceCount() {
        return this.masterInstanceCount;
    }

    @Generated
    public String getQueryInstanceType() {
        return this.queryInstanceType;
    }

    @Generated
    public Integer getQueryInstanceCount() {
        return this.queryInstanceCount;
    }

    @Generated
    public Map<Integer, InstanceTier> getDataInstanceTiers() {
        return this.dataInstanceTiers;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterSizeDetails)) {
            return false;
        }
        ClusterSizeDetails other = (ClusterSizeDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$masterInstanceCount = this.getMasterInstanceCount();
        Integer other$masterInstanceCount = other.getMasterInstanceCount();
        if (this$masterInstanceCount == null ? other$masterInstanceCount != null : !((Object)this$masterInstanceCount).equals(other$masterInstanceCount)) {
            return false;
        }
        Integer this$queryInstanceCount = this.getQueryInstanceCount();
        Integer other$queryInstanceCount = other.getQueryInstanceCount();
        if (this$queryInstanceCount == null ? other$queryInstanceCount != null : !((Object)this$queryInstanceCount).equals(other$queryInstanceCount)) {
            return false;
        }
        ComparableVersion this$minImplyVersion = this.getMinImplyVersion();
        ComparableVersion other$minImplyVersion = other.getMinImplyVersion();
        if (this$minImplyVersion == null ? other$minImplyVersion != null : !((Object)this$minImplyVersion).equals(other$minImplyVersion)) {
            return false;
        }
        String this$masterInstanceType = this.getMasterInstanceType();
        String other$masterInstanceType = other.getMasterInstanceType();
        if (this$masterInstanceType == null ? other$masterInstanceType != null : !this$masterInstanceType.equals(other$masterInstanceType)) {
            return false;
        }
        String this$queryInstanceType = this.getQueryInstanceType();
        String other$queryInstanceType = other.getQueryInstanceType();
        if (this$queryInstanceType == null ? other$queryInstanceType != null : !this$queryInstanceType.equals(other$queryInstanceType)) {
            return false;
        }
        Map<Integer, InstanceTier> this$dataInstanceTiers = this.getDataInstanceTiers();
        Map<Integer, InstanceTier> other$dataInstanceTiers = other.getDataInstanceTiers();
        return !(this$dataInstanceTiers == null ? other$dataInstanceTiers != null : !((Object)this$dataInstanceTiers).equals(other$dataInstanceTiers));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClusterSizeDetails;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $masterInstanceCount = this.getMasterInstanceCount();
        result = result * 59 + ($masterInstanceCount == null ? 43 : ((Object)$masterInstanceCount).hashCode());
        Integer $queryInstanceCount = this.getQueryInstanceCount();
        result = result * 59 + ($queryInstanceCount == null ? 43 : ((Object)$queryInstanceCount).hashCode());
        ComparableVersion $minImplyVersion = this.getMinImplyVersion();
        result = result * 59 + ($minImplyVersion == null ? 43 : ((Object)$minImplyVersion).hashCode());
        String $masterInstanceType = this.getMasterInstanceType();
        result = result * 59 + ($masterInstanceType == null ? 43 : $masterInstanceType.hashCode());
        String $queryInstanceType = this.getQueryInstanceType();
        result = result * 59 + ($queryInstanceType == null ? 43 : $queryInstanceType.hashCode());
        Map<Integer, InstanceTier> $dataInstanceTiers = this.getDataInstanceTiers();
        result = result * 59 + ($dataInstanceTiers == null ? 43 : ((Object)$dataInstanceTiers).hashCode());
        return result;
    }

    @Generated
    public static class Builder {
        @Generated
        private ComparableVersion minImplyVersion;
        @Generated
        private String masterInstanceType;
        @Generated
        private Integer masterInstanceCount;
        @Generated
        private String queryInstanceType;
        @Generated
        private Integer queryInstanceCount;
        @Generated
        private Map<Integer, InstanceTier> dataInstanceTiers;

        @Generated
        Builder() {
        }

        @JsonProperty
        @Generated
        public Builder minImplyVersion(ComparableVersion minImplyVersion) {
            this.minImplyVersion = minImplyVersion;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder masterInstanceType(String masterInstanceType) {
            this.masterInstanceType = masterInstanceType;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder masterInstanceCount(Integer masterInstanceCount) {
            this.masterInstanceCount = masterInstanceCount;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder queryInstanceType(String queryInstanceType) {
            this.queryInstanceType = queryInstanceType;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder queryInstanceCount(Integer queryInstanceCount) {
            this.queryInstanceCount = queryInstanceCount;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder dataInstanceTiers(Map<Integer, InstanceTier> dataInstanceTiers) {
            this.dataInstanceTiers = dataInstanceTiers;
            return this;
        }

        @Generated
        public ClusterSizeDetails build() {
            return new ClusterSizeDetails(this.minImplyVersion, this.masterInstanceType, this.masterInstanceCount, this.queryInstanceType, this.queryInstanceCount, this.dataInstanceTiers);
        }

        @Generated
        public String toString() {
            return "ClusterSizeDetails.Builder(minImplyVersion=" + String.valueOf(this.minImplyVersion) + ", masterInstanceType=" + this.masterInstanceType + ", masterInstanceCount=" + this.masterInstanceCount + ", queryInstanceType=" + this.queryInstanceType + ", queryInstanceCount=" + this.queryInstanceCount + ", dataInstanceTiers=" + String.valueOf(this.dataInstanceTiers) + ")";
        }
    }
}

