/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.imply.cloud.Toolbox;
import io.imply.cloud.exception.BadGatewayException;
import io.imply.cloud.exception.ImplyViolationException;
import io.imply.cloud.grove.Node;
import io.imply.cloud.model.Account;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ImplyConstraintViolation;
import io.imply.cloud.model.ImplyNodeType;
import io.imply.cloud.model.Info;
import io.imply.cloud.model.NodeConfiguration;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.Pair;
import io.imply.cloud.util.ThreadLocalContext;
import io.imply.cloud.util.ToStringBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.joda.time.DateTime;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ClusterNodes {
    private static final Logger log = new Logger(ClusterNodes.class);
    private final String clusterId;
    private final Integer version;
    private final DateTime lastModified;
    private final String modifiedBy;
    private final Map<String, NodeConfiguration> nodes;

    @JsonCreator
    public ClusterNodes(@JsonProperty(value="clusterId") String clusterId, @JsonProperty(value="version") Integer version, @JsonProperty(value="lastModified") DateTime lastModified, @JsonProperty(value="modifiedBy") String modifiedBy, @JsonProperty(value="nodes") Map<String, NodeConfiguration> nodes) {
        this.clusterId = clusterId;
        this.version = version;
        this.lastModified = lastModified;
        this.modifiedBy = modifiedBy;
        this.nodes = nodes;
    }

    @JsonProperty
    public String getClusterId() {
        return this.clusterId;
    }

    @JsonProperty
    public Integer getVersion() {
        return this.version;
    }

    @JsonProperty
    public DateTime getLastModified() {
        return this.lastModified;
    }

    @JsonProperty
    public String getModifiedBy() {
        return this.modifiedBy;
    }

    @JsonProperty
    public Map<String, NodeConfiguration> getNodes() {
        return this.nodes;
    }

    public final List<ImplyConstraintViolation> validate(Toolbox toolbox, boolean throwExceptions) {
        ArrayList<ImplyConstraintViolation> results = new ArrayList<ImplyConstraintViolation>();
        this.validateInternal(results, toolbox);
        Set constraintViolations = results.stream().filter(violation -> ImplyConstraintViolation.Severity.ERROR.equals((Object)violation.getSeverity())).collect(Collectors.toSet());
        if (throwExceptions && CollectionUtils.isNotEmpty(constraintViolations)) {
            throw new ImplyViolationException(constraintViolations);
        }
        return results;
    }

    private void validateInternal(List<ImplyConstraintViolation> results, Toolbox toolbox) {
        Cluster cluster = toolbox.getClusterDataManager().getOrNull(this.clusterId);
        Account account = toolbox.getAccountDataManager().get(cluster != null ? cluster.getAccountId() : "onprem");
        this.validateNodeConfiguration(results, account, toolbox);
        this.validateNodesAvailable(results, toolbox);
    }

    private void validateNodeConfiguration(List<ImplyConstraintViolation> results, Account account, Toolbox toolbox) {
        ImmutableMap groveNodes;
        if (this.nodes == null) {
            return;
        }
        boolean skipGroveValidation = ThreadLocalContext.userContextIsTrue("skipGroveValidation") || ThreadLocalContext.systemContextIsTrue("skipGroveValidation") || CollectionUtils.emptyIfNull(account.getFeatureFlags()).contains("disableGroveServer");
        try {
            groveNodes = skipGroveValidation ? ImmutableMap.of() : toolbox.getGroveClient().getGroveNodes(account.getGroveServer(), false).stream().collect(Collectors.toMap(Node::getAddress, x -> x));
        }
        catch (BadGatewayException e) {
            throw new IAE("Unable to validate [nodeConfigurations]: %s", e.getMessage());
        }
        List onlineNodes = groveNodes.entrySet().stream().filter(x -> x.getValue() != null && ((Node)x.getValue()).isOnline()).map(Map.Entry::getKey).collect(Collectors.toList());
        for (Map.Entry<String, NodeConfiguration> entry : this.nodes.entrySet()) {
            Node myNode;
            if (entry.getValue() == null || entry.getValue().getNodeTypes() == null) {
                results.add(ImplyConstraintViolation.error(String.format("nodes.%s.nodeTypes", entry.getKey()), "[nodeTypes] must be provided", new Object[0]));
                continue;
            }
            Set<ImplyNodeType> nodeTypes = entry.getValue().getNodeTypes();
            for (ImplyNodeType nodeType : nodeTypes) {
                if (ClusterNodes.isNodeTypeValid(nodeType)) continue;
                results.add(ImplyConstraintViolation.error(String.format("nodes.%s.nodeTypes", entry.getKey()), "[nodeTypes] must be one of %s", Stream.concat(ImplyNodeType.USER_SELECTABLE_NODE_TYPES.stream(), Stream.of(ImplyNodeType.DATA)).map(ImplyNodeType::camelCasedName).collect(Collectors.toList())));
            }
            ArrayList<ImplyNodeType> testForMultipleDataTiers = new ArrayList<ImplyNodeType>(nodeTypes);
            testForMultipleDataTiers.removeAll((Collection<?>)ImmutableList.of((Object)ImplyNodeType.MASTER, (Object)ImplyNodeType.QUERY));
            if (testForMultipleDataTiers.stream().distinct().filter(Objects::nonNull).count() > 1L) {
                results.add(ImplyConstraintViolation.error(String.format("nodes.%s.nodeTypes", entry.getKey()), "A node cannot be part of more than one data tier", new Object[0]));
                continue;
            }
            if (!skipGroveValidation && !onlineNodes.contains(entry.getKey())) {
                results.add(ImplyConstraintViolation.error(String.format("nodes.%s", entry.getKey()), "[%s] cannot be assigned to this cluster because it is not online, valid: %s", entry.getKey(), onlineNodes));
            }
            if (groveNodes.get(entry.getKey()) == null || (myNode = (Node)groveNodes.get(entry.getKey())).isModifiable().booleanValue()) continue;
            if (!myNode.getTaggedImplyNodeTypes().equals(entry.getValue().getNodeTypes())) {
                results.add(ImplyConstraintViolation.error(String.format("nodes.%s.nodeTypes", entry.getKey()), "The node type of [%s] is fixed to %s and cannot be changed", entry.getKey(), myNode.getTaggedImplyNodeTypes()));
            }
            if (myNode.getTaggedClusterId().equals(this.clusterId)) continue;
            results.add(ImplyConstraintViolation.error(String.format("nodes.%s", entry.getKey()), "The node [%s] is fixed to cluster [%s] and cannot be changed", entry.getKey(), myNode.getTaggedClusterId()));
        }
    }

    protected static boolean isNodeTypeValid(ImplyNodeType nodeType) {
        return ImplyNodeType.USER_SELECTABLE_NODE_TYPES.contains(nodeType) || nodeType != null && ImplyNodeType.ImplyNodeServiceType.DATA.equals((Object)nodeType.getNodeServiceType());
    }

    private void validateNodesAvailable(List<ImplyConstraintViolation> results, Toolbox toolbox) {
        if (this.nodes == null || this.nodes.keySet().isEmpty()) {
            return;
        }
        ArrayList<String> myHosts = new ArrayList<String>(this.nodes.keySet());
        HashMap<String, Pair> usedHosts = new HashMap<String, Pair>();
        for (ClusterNodes clusterNodes : toolbox.getClusterNodesDataManager().getAll()) {
            if (clusterNodes.getClusterId().equals(this.getClusterId())) continue;
            Cluster cluster = toolbox.getClusterDataManager().getOrNull(clusterNodes.getClusterId());
            if (cluster == null) {
                log.warn("No entry for clusterId [%s] in cluster table; skipping node availability validation", clusterNodes.getClusterId());
                continue;
            }
            Info info = toolbox.getEntityStateDataManager().getOrNull(cluster);
            if (info == null || info.getState() == null || info.getState().isStoppedTerminatedOrFailed() || clusterNodes.getNodes() == null) continue;
            usedHosts.putAll(clusterNodes.getNodes().keySet().stream().collect(Collectors.toMap(k -> k, v -> Pair.of(cluster.getClusterId(), cluster.getName()))));
        }
        myHosts.retainAll(usedHosts.keySet());
        if (!myHosts.isEmpty()) {
            HashMap hostsByCluster = new HashMap();
            for (String host : myHosts) {
                Pair clusterInfo = (Pair)usedHosts.get(host);
                if (!hostsByCluster.containsKey(clusterInfo)) {
                    hostsByCluster.put(clusterInfo, new ArrayList());
                }
                ((List)hostsByCluster.get(clusterInfo)).add(host);
            }
            StringJoiner stringJoiner = new StringJoiner(", ");
            for (Map.Entry entry : hostsByCluster.entrySet()) {
                stringJoiner.add(String.format("%s in '%s' (%s)", entry.getValue(), ((Pair)entry.getKey()).rhs, ((Pair)entry.getKey()).lhs));
            }
            results.add(ImplyConstraintViolation.error("nodes", "Cluster contains hosts already being used by another active cluster: %s", stringJoiner.toString()));
        }
    }

    public String toString() {
        return new ToStringBuilder(this).append("clusterId", this.clusterId).append("version", (Object)this.version).append("lastModified", (Object)this.lastModified).append("modifiedBy", (Object)this.modifiedBy).append("nodes", this.nodes).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterNodes that = (ClusterNodes)o;
        return Objects.equals(this.clusterId, that.clusterId) && Objects.equals(this.version, that.version) && Objects.equals(this.lastModified, that.lastModified) && Objects.equals(this.modifiedBy, that.modifiedBy) && Objects.equals(this.nodes, that.nodes);
    }

    public int hashCode() {
        return Objects.hash(this.clusterId, this.version, this.lastModified, this.modifiedBy, this.nodes);
    }

    public static ClusterNodes empty() {
        return new ClusterNodes(null, null, null, null, null);
    }

    public Builder cloner() {
        return ClusterNodes.builder().withClusterNodes(this, false);
    }

    public ClusterNodes mergeDiff(ClusterNodes other) {
        return this.mergeDiff(ClusterNodes.builder(), other).build();
    }

    public ClusterNodes filterNonNullFields(ClusterNodes filter) {
        return this.filterNonNullFields(ClusterNodes.builder(), filter).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isEmpty() {
        return this.nodes == null;
    }

    protected Builder mergeDiff(Builder builder, ClusterNodes other) {
        if (other == null) {
            return builder.withClusterNodes(this, false);
        }
        builder.withClusterId(this.clusterId == null ? null : (this.clusterId.equals(other.clusterId) ? null : this.clusterId));
        builder.withVersion(this.version == null ? null : (this.version.equals(other.version) ? null : this.version));
        builder.withLastModified(this.lastModified == null ? null : (this.lastModified.equals((Object)other.lastModified) ? null : this.lastModified));
        builder.withModifiedBy(this.modifiedBy == null ? null : (this.modifiedBy.equals(other.modifiedBy) ? null : this.modifiedBy));
        Map<String, NodeConfiguration> nodes = this.nodes;
        if (nodes != null && (nodes.equals(other.nodes) || nodes.isEmpty() && other.nodes == null)) {
            nodes = null;
        }
        builder.withNodes(nodes);
        return builder;
    }

    protected Builder filterNonNullFields(Builder builder, ClusterNodes filter) {
        if (filter == null) {
            return builder;
        }
        if (filter.clusterId != null) {
            builder.withClusterId(this.clusterId);
        }
        if (filter.version != null) {
            builder.withVersion(this.version);
        }
        if (filter.lastModified != null) {
            builder.withLastModified(this.lastModified);
        }
        if (filter.modifiedBy != null) {
            builder.withModifiedBy(this.modifiedBy);
        }
        if (filter.nodes != null) {
            builder.withNodes(this.nodes);
        }
        return builder;
    }

    public static class Builder<Subclass extends Builder, TypeToBuild extends ClusterNodes> {
        protected String clusterId;
        protected Integer version;
        protected DateTime lastModified;
        protected String modifiedBy;
        protected Map<String, NodeConfiguration> nodes;

        protected Builder() {
        }

        protected final Subclass getSubclass() {
            return (Subclass)this;
        }

        public TypeToBuild build() {
            return (TypeToBuild)new ClusterNodes(this.clusterId, this.version, this.lastModified, this.modifiedBy, this.nodes);
        }

        public Subclass withClusterNodes(ClusterNodes clusterNodes, boolean merge) {
            if (clusterNodes == null) {
                return this.getSubclass();
            }
            if (clusterNodes.clusterId != null) {
                this.clusterId = clusterNodes.clusterId;
            }
            if (clusterNodes.version != null) {
                this.version = clusterNodes.version;
            }
            if (clusterNodes.lastModified != null) {
                this.lastModified = clusterNodes.lastModified;
            }
            if (clusterNodes.modifiedBy != null) {
                this.modifiedBy = clusterNodes.modifiedBy;
            }
            if (clusterNodes.nodes != null) {
                this.nodes = merge && this.nodes != null ? clusterNodes.nodes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, x -> {
                    if (x.getValue() == null || ((NodeConfiguration)x.getValue()).isCattle() != null) {
                        return (NodeConfiguration)x.getValue();
                    }
                    Boolean imCattle = this.nodes.get(x.getKey()) == null || this.nodes.get(x.getKey()).isCattle() == null ? null : this.nodes.get(x.getKey()).isCattle();
                    return ((NodeConfiguration)x.getValue()).withCattle(imCattle);
                })) : clusterNodes.nodes;
            }
            return this.getSubclass();
        }

        public Subclass withClusterId(String clusterId) {
            this.clusterId = clusterId;
            return this.getSubclass();
        }

        public Subclass withVersion(Integer version) {
            this.version = version;
            return this.getSubclass();
        }

        public Subclass withLastModified(DateTime lastModified) {
            this.lastModified = lastModified;
            return this.getSubclass();
        }

        public Subclass withModifiedBy(String modifiedBy) {
            this.modifiedBy = modifiedBy;
            return this.getSubclass();
        }

        public Subclass withNodes(Map<String, NodeConfiguration> nodes) {
            this.nodes = nodes;
            return this.getSubclass();
        }

        public Subclass withoutNonUpdatableFields() {
            this.lastModified = null;
            this.modifiedBy = null;
            return this.getSubclass();
        }
    }
}

