/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.model.Architecture;
import io.imply.cloud.model.ComparableVersion;
import io.imply.cloud.model.Region;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;

public class AmiRegion {
    private final ComparableVersion minImplyVersion;
    private final Map<Region, String> regions;
    private final Architecture architecture;

    @JsonCreator
    public AmiRegion(@JsonProperty(value="minImplyVersion") ComparableVersion minImplyVersion, @JsonProperty(value="regions") Map<Region, String> regions, @JsonProperty(value="architecture") Architecture architecture) {
        this.minImplyVersion = minImplyVersion;
        this.regions = regions;
        this.architecture = architecture == null ? Architecture.X86_64 : architecture;
    }

    @JsonProperty
    public ComparableVersion getMinImplyVersion() {
        return this.minImplyVersion;
    }

    @JsonProperty
    public Map<Region, String> getRegions() {
        return this.regions;
    }

    @JsonProperty
    public Architecture getArchitecture() {
        return this.architecture;
    }

    public String toString() {
        return new ToStringBuilder(this).append("minImplyVersion", this.minImplyVersion).append("regions", this.regions).append("architecture", (Object)this.architecture).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AmiRegion amiRegion = (AmiRegion)o;
        return Objects.equals(this.minImplyVersion, amiRegion.minImplyVersion) && Objects.equals(this.regions, amiRegion.regions) && Objects.equals((Object)this.architecture, (Object)amiRegion.architecture);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.minImplyVersion, this.regions, this.architecture});
    }

    public static Map<Region, String> getForComparableImplyVersion(ComparableVersion comparableVersion, Architecture architecture, RefreshableConstants refreshableConstants) {
        return comparableVersion == null ? ImmutableMap.of() : refreshableConstants.getAmiForRegion().stream().sorted(Comparator.comparing(AmiRegion::getMinImplyVersion).reversed()).filter(x -> comparableVersion.compareTo(x.getMinImplyVersion()) >= 0).filter(x -> x.architecture.equals((Object)(architecture == null ? Architecture.X86_64 : architecture))).map(AmiRegion::getRegions).findFirst().orElseGet(ImmutableMap::of);
    }
}

