/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.model.ComparableVersion;
import io.imply.cloud.model.ImplyVersion;
import io.imply.cloud.model.UserFile;
import io.imply.cloud.util.ToStringBuilder;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AdditionalFiles {
    private final ComparableVersion minImplyVersion;
    private final List<UserFile> files;

    @JsonCreator
    public AdditionalFiles(@JsonProperty(value="minImplyVersion") ComparableVersion minImplyVersion, @JsonProperty(value="files") List<UserFile> files) {
        this.minImplyVersion = minImplyVersion;
        this.files = files;
    }

    @JsonProperty
    public ComparableVersion getMinImplyVersion() {
        return this.minImplyVersion;
    }

    @JsonProperty
    public List<UserFile> getFiles() {
        return this.files;
    }

    public String toString() {
        return new ToStringBuilder(this).append("minImplyVersion", this.minImplyVersion).append("files", this.files).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdditionalFiles that = (AdditionalFiles)o;
        return Objects.equals(this.minImplyVersion, that.minImplyVersion) && Objects.equals(this.files, that.files);
    }

    public int hashCode() {
        return Objects.hash(this.minImplyVersion, this.files);
    }

    public static AdditionalFiles getForImplyVersion(ImplyVersion version, RefreshableConstants refreshableConstants) {
        return version == null || version.getComparableVersion() == null ? null : (AdditionalFiles)refreshableConstants.getAdditionalFiles().stream().sorted(Comparator.comparing(AdditionalFiles::getMinImplyVersion).reversed()).filter(x -> version.getComparableVersion().compareTo(x.getMinImplyVersion()) >= 0).findFirst().orElse(null);
    }
}

