/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.imply.cloud.jackson.JodaStuff;
import java.io.IOException;
import java.util.TimeZone;
import org.joda.time.DateTimeZone;

public class DefaultSerializersModule
extends SimpleModule {
    private static final long serialVersionUID = -2064730128242848272L;

    public DefaultSerializersModule() {
        super("Default serializers");
        JodaStuff.register(this);
        this.addDeserializer(DateTimeZone.class, (JsonDeserializer)new JsonDeserializer<DateTimeZone>(){

            public DateTimeZone deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
                String tzId = jp.getText();
                try {
                    return DateTimeZone.forID((String)tzId);
                }
                catch (IllegalArgumentException e) {
                    return DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(tzId));
                }
            }
        });
        this.addSerializer(DateTimeZone.class, (JsonSerializer)new JsonSerializer<DateTimeZone>(){

            public void serialize(DateTimeZone dateTimeZone, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeString(dateTimeZone.getID());
            }
        });
    }
}

