/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.imply.cloud.Constants;
import io.imply.cloud.http.HttpClientProvider;
import io.imply.cloud.model.druid.ImmutableWorkerInfo;
import io.imply.cloud.model.druid.SimpleComputeServer;
import io.imply.cloud.model.druid.Worker;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.ThreadLocalContext;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.joda.time.DateTime;

public class MockHttpClientProvider
extends EasyMockSupport
implements HttpClientProvider {
    private static final Logger log = new Logger(MockHttpClientProvider.class);
    private final ObjectMapper objectMapper;

    @Inject
    public MockHttpClientProvider(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public HttpClient get() {
        HttpClient httpClient = (HttpClient)this.createMock(HttpClient.class);
        try {
            this.maybeInitializeMocks(ThreadLocalContext.getNoticeOrActionClass(), httpClient);
        }
        catch (Exception e) {
            log.warn(e, "Exception while initializing mock");
        }
        EasyMock.replay((Object[])new Object[]{httpClient});
        return httpClient;
    }

    @Override
    public HttpClient get(boolean forceRealClient) {
        if (forceRealClient) {
            throw new IllegalStateException("MockHttpClientProvider cannot return a real implementation!");
        }
        return this.get();
    }

    private void maybeInitializeMocks(Class<?> noticeOrActionClass, HttpClient httpClient) throws Exception {
        String actionName;
        switch (actionName = noticeOrActionClass != null ? noticeOrActionClass.getSimpleName() : "") {
            case "AwsCreateClusterStackNotice": 
            case "AwsUpdateClusterStackNotice": {
                this.setCreateOrUpdateClusterNoticeMockBehavior(httpClient);
                break;
            }
            case "AwsPlanRollingUpdateNotice": 
            case "AwsExecuteStagedOperationNotice": {
                this.setPlanAndExecuteRollingUpdateNoticeMockBehavior(httpClient);
                break;
            }
            case "CheckInstanceHealthNotice": {
                this.setCheckInstanceHealthMockBehavior(httpClient);
            }
        }
    }

    private void setCreateOrUpdateClusterNoticeMockBehavior(HttpClient httpClient) {
        if (httpClient != null) {
            Request request = (Request)this.createMock(Request.class);
            Response response = (Response)this.createMock(Response.class);
            Capture captured = Capture.newInstance();
            EasyMock.expect((Object)httpClient.newRequest(EasyMock.anyString())).andReturn((Object)request).anyTimes();
            EasyMock.expect((Object)request.method(HttpMethod.HEAD)).andReturn((Object)request).anyTimes();
            EasyMock.expect((Object)request.timeout(EasyMock.anyLong(), (TimeUnit)((Object)EasyMock.anyObject(TimeUnit.class)))).andReturn((Object)request).anyTimes();
            request.send((Response.CompleteListener)EasyMock.capture((Capture)captured));
            EasyMock.expectLastCall().andAnswer(() -> {
                ((InputStreamResponseListener)captured.getValue()).onHeaders(response);
                return null;
            }).anyTimes();
            EasyMock.expect((Object)response.getStatus()).andReturn((Object)200).anyTimes();
            EasyMock.expect((Object)response.abort((Throwable)EasyMock.anyObject(Exception.class))).andReturn((Object)true).anyTimes();
            EasyMock.replay((Object[])new Object[]{request, response});
        }
    }

    private void setHttpClientDefaultMockBehavior(HttpClient httpClient, BiFunction<String, HttpMethod, String> contentProvider) throws Exception {
        if (httpClient != null) {
            Capture capturedUri = Capture.newInstance();
            Capture capturedMethod = Capture.newInstance();
            Request request = (Request)this.createMock(Request.class);
            EasyMock.expect((Object)httpClient.newRequest((URI)EasyMock.capture((Capture)capturedUri))).andReturn((Object)request).anyTimes();
            EasyMock.expect((Object)request.method((HttpMethod)EasyMock.capture((Capture)capturedMethod))).andReturn((Object)request).anyTimes();
            EasyMock.expect((Object)request.timeout(EasyMock.anyLong(), (TimeUnit)((Object)EasyMock.anyObject(TimeUnit.class)))).andReturn((Object)request).anyTimes();
            EasyMock.expect((Object)request.content((ContentProvider)EasyMock.anyObject(ContentProvider.class))).andReturn((Object)request).anyTimes();
            EasyMock.expect((Object)request.header(EasyMock.anyString(), EasyMock.anyString())).andReturn((Object)request).anyTimes();
            EasyMock.expect((Object)request.header((HttpHeader)EasyMock.anyObject(HttpHeader.class), EasyMock.anyString())).andReturn((Object)request).anyTimes();
            EasyMock.expect((Object)request.getHeaders()).andReturn((Object)new HttpFields()).anyTimes();
            EasyMock.expect((Object)request.send()).andAnswer(() -> {
                ContentResponse response = (ContentResponse)this.createMock(ContentResponse.class);
                URI uri = (URI)capturedUri.getValue();
                HttpMethod method = (HttpMethod)capturedMethod.getValue();
                EasyMock.expect((Object)response.getStatus()).andReturn((Object)200).anyTimes();
                EasyMock.expect((Object)response.getContentAsString()).andReturn((Object)((String)contentProvider.apply(uri.getPath(), method))).anyTimes();
                EasyMock.replay((Object[])new Object[]{response});
                return response;
            }).anyTimes();
            EasyMock.replay((Object[])new Object[]{request});
        }
    }

    private void setPlanAndExecuteRollingUpdateNoticeMockBehavior(HttpClient httpClient) throws Exception {
        this.setHttpClientDefaultMockBehavior(httpClient, this::getMockPlanAndExecuteRollingUpdateResponseContent);
    }

    private void setCheckInstanceHealthMockBehavior(HttpClient httpClient) throws Exception {
        this.setHttpClientDefaultMockBehavior(httpClient, (path, method) -> {
            if (!HttpMethod.GET.equals(method) || !ImmutableList.of((Object)"/status", (Object)"/health").contains(path)) {
                throw new ISE("Illegal call to setCheckInstanceHealthMockBehavior", new Object[0]);
            }
            return "{\"version\":\"0.10.1-rc3\",\"modules\":[{\"name\":\"io.druid.client.cache.CaffeineDruidModule\",\"artifact\":\"druid-caffeine-cache\",\"version\":\"0.10.1-rc3\"},{\"name\":\"io.druid.storage.s3.S3StorageDruidModule\",\"artifact\":\"druid-s3-extensions\",\"version\":\"0.10.1-rc3\"}],\"memory\":{\"maxMemory\":536870912,\"totalMemory\":536870912,\"freeMemory\":283091792,\"usedMemory\":253779120}}";
        });
    }

    private String getMockPlanAndExecuteRollingUpdateResponseContent(String path, HttpMethod method) {
        try {
            switch (method) {
                case GET: {
                    switch (path) {
                        case "/druid/coordinator/v1/config": {
                            return "{ \"millisToWaitBeforeDeleting\": 900000, \"mergeBytesLimit\": 524288000, \"mergeSegmentsLimit\": 100, \"maxSegmentsToMove\": 5, \"replicantLifetime\": 15, \"replicationThrottleLimit\": 10, \"balancerComputeThreads\": 1, \"emitBalancingStats\": false, \"killDataSourceWhitelist\": [\"ds1\", \"ds2\"], \"killAllDataSources\": false}";
                        }
                        case "/druid/coordinator/v1/servers": {
                            Integer numTier1Historicals = (Integer)ThreadLocalContext.getSystemContext("expectedDataTier1Nodes");
                            Integer numTier2Historicals = (Integer)ThreadLocalContext.getSystemContext("expectedDataTier2Nodes");
                            Integer numTier3Historicals = (Integer)ThreadLocalContext.getSystemContext("expectedDataTier3Nodes");
                            return this.generateCoordinatorServerList(numTier1Historicals != null ? numTier1Historicals : 0, numTier2Historicals != null ? numTier2Historicals : 0, numTier3Historicals != null ? numTier3Historicals : 0);
                        }
                        case "/druid/indexer/v1/workers": {
                            Integer numTier1Workers = (Integer)ThreadLocalContext.getSystemContext("expectedDataTier1Nodes");
                            Integer numTier2Workers = (Integer)ThreadLocalContext.getSystemContext("expectedDataTier2Nodes");
                            Integer numTier3Workers = (Integer)ThreadLocalContext.getSystemContext("expectedDataTier3Nodes");
                            int totalWorkers = (numTier1Workers == null ? 0 : numTier1Workers) + (numTier2Workers == null ? 0 : numTier2Workers) + (numTier3Workers == null ? 0 : numTier3Workers);
                            return this.generateMockWorkersResponse(totalWorkers);
                        }
                        case "/druid/worker/v1/tasks": {
                            return "[]";
                        }
                        case "/druid/coordinator/v1/loadstatus": {
                            return "{\"_default_tier\": {\"wikipedia\": 0, \"twitter\": 0}, \"cold\": {\"github\": 0}}";
                        }
                        case "/status": {
                            return "{\"version\":\"0.10.1-rc3\",\"modules\":[{\"name\":\"io.druid.client.cache.CaffeineDruidModule\",\"artifact\":\"druid-caffeine-cache\",\"version\":\"0.10.1-rc3\"},{\"name\":\"io.druid.storage.s3.S3StorageDruidModule\",\"artifact\":\"druid-s3-extensions\",\"version\":\"0.10.1-rc3\"}],\"memory\":{\"maxMemory\":536870912,\"totalMemory\":536870912,\"freeMemory\":283091792,\"usedMemory\":253779120}}";
                        }
                        case "/health": {
                            return "I am healthy @ 2017-10-24T02:14:55.985Z";
                        }
                    }
                    break;
                }
                case POST: {
                    switch (path) {
                        case "/druid/worker/v1/disable": {
                            return "{\"172.31.13.155:8091\": \"disabled\"}";
                        }
                        case "/druid/worker/v1/enable": {
                            return "{\"172.31.13.155:8091\": \"enabled\"}";
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        return null;
    }

    private String generateCoordinatorServerList(int numTier1Historicals, int numTier2Historicals, int numTier3Historicals) throws JsonProcessingException {
        int i;
        ArrayList<SimpleComputeServer> servers = new ArrayList<SimpleComputeServer>();
        for (i = 0; i < numTier1Historicals; ++i) {
            servers.add(new SimpleComputeServer(String.format("ip-172-31-11-%d.ec2.internal:%d", i, 8083), "_default_tier", "historical", Constants.DRUID_SERVER_TIER_PRIORITY_DEFAULT, 100000000L, 1000000000L));
        }
        for (i = 0; i < numTier2Historicals; ++i) {
            servers.add(new SimpleComputeServer(String.format("ip-172-31-12-%d.ec2.internal:%d", i, 8083), "tier2", "historical", Constants.DRUID_SERVER_TIER_PRIORITY_DEFAULT, 100000000L, 1000000000L));
        }
        for (i = 0; i < numTier3Historicals; ++i) {
            servers.add(new SimpleComputeServer(String.format("ip-172-31-13-%d.ec2.internal:%d", i, 8083), "tier3", "historical", Constants.DRUID_SERVER_TIER_PRIORITY_DEFAULT, 100000000L, 1000000000L));
        }
        servers.add(new SimpleComputeServer("ip-172-31-3-59.ec2.internal:8103", "_default_tier", "indexer-executor", Constants.DRUID_SERVER_TIER_PRIORITY_DEFAULT, 0L, 0L));
        return this.objectMapper.writeValueAsString(servers);
    }

    private String generateMockWorkersResponse(int numWorkers) throws JsonProcessingException {
        ArrayList<ImmutableWorkerInfo> workerInfos = new ArrayList<ImmutableWorkerInfo>();
        for (int i = 0; i < numWorkers; ++i) {
            Worker worker = new Worker("http", String.format("ip-172-31-14-%d.ec2.internal:8091", i), String.format("ip-172-31-14-%d.ec2.internal", i), 3, "0");
            workerInfos.add(new ImmutableWorkerInfo(worker, 1, (Set<String>)ImmutableSet.of((Object)"index_kafka_twitter-status_0d1fe7fd85c71a8"), (Collection<String>)ImmutableList.of((Object)"index_kafka_twitter-status_0d1fe7fd85c71a8_cegbkejf"), DateTime.now()));
        }
        return this.objectMapper.writeValueAsString(workerInfos);
    }
}

