/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.guice;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.module.guice.GuiceAnnotationIntrospector;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import io.imply.cloud.config.ConfigServerConfig;
import io.imply.cloud.config.ConfigValidator;
import io.imply.cloud.config.JsonConfigurator;
import io.imply.cloud.config.RefreshableConstantsConfig;
import io.imply.cloud.guice.GuiceExtensions;
import io.imply.cloud.guice.GuiceInjectableValues;
import io.imply.cloud.guice.JsonConfigProvider;
import io.imply.cloud.guice.LifecycleModule;
import io.imply.cloud.guice.annotations.LazySingleton;
import java.util.Properties;
import javax.validation.Validator;

public class SecondaryModule
implements Module {
    private final Properties properties;
    private final ObjectMapper jsonMapper;
    private final Validator validator;

    @Inject
    public SecondaryModule(Properties properties, ObjectMapper jsonMapper, Validator validator) {
        this.properties = properties;
        this.jsonMapper = jsonMapper;
        this.validator = validator;
    }

    public void configure(Binder binder) {
        binder.install((Module)new GuiceExtensions());
        binder.bind(Properties.class).toInstance((Object)this.properties);
        binder.bind(Validator.class).toInstance((Object)this.validator);
        binder.bind(JsonConfigurator.class);
        JsonConfigProvider.bind(binder, "refreshableConstants", RefreshableConstantsConfig.class);
        JsonConfigProvider.bind(binder, "configServer", ConfigServerConfig.class);
        LifecycleModule.register(binder, ConfigValidator.class);
    }

    @Provides
    @LazySingleton
    public ObjectMapper getJsonMapper(Injector injector) {
        this.setupJackson(injector, this.jsonMapper);
        return this.jsonMapper;
    }

    private void setupJackson(Injector injector, ObjectMapper mapper) {
        GuiceAnnotationIntrospector guiceIntrospector = new GuiceAnnotationIntrospector();
        mapper.setInjectableValues((InjectableValues)new GuiceInjectableValues(injector));
        mapper.setAnnotationIntrospectors((AnnotationIntrospector)new AnnotationIntrospectorPair((AnnotationIntrospector)guiceIntrospector, mapper.getSerializationConfig().getAnnotationIntrospector()), (AnnotationIntrospector)new AnnotationIntrospectorPair((AnnotationIntrospector)guiceIntrospector, mapper.getDeserializationConfig().getAnnotationIntrospector()));
    }
}

