/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.guice;

import com.google.inject.Binder;
import com.google.inject.Module;
import io.imply.cloud.util.Logger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class PropertiesModule
implements Module {
    private static final Logger log = new Logger(PropertiesModule.class);
    private final List<String> propertiesFiles;

    public PropertiesModule(List<String> propertiesFiles) {
        this.propertiesFiles = propertiesFiles;
    }

    public void configure(Binder binder) {
        Properties fileProps = new Properties();
        Properties systemProps = System.getProperties();
        Properties props = new Properties(fileProps);
        props.putAll((Map<?, ?>)systemProps);
        for (String propertiesFile : this.propertiesFiles) {
            try {
                InputStream stream = this.getPropertiesFileStream(propertiesFile, systemProps);
                try {
                    if (stream == null) continue;
                    log.info("Loading properties from %s", propertiesFile);
                    this.loadFile(stream, fileProps);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (FileNotFoundException e) {
                log.wtf(e, "This can only happen if the .exists() call lied.  That's f'd up.", new Object[0]);
            }
            catch (IOException iOException) {}
        }
        binder.bind(Properties.class).toInstance((Object)props);
    }

    private InputStream getPropertiesFileStream(String propertiesFile, Properties systemProps) throws FileNotFoundException {
        InputStream stream = ClassLoader.getSystemResourceAsStream(propertiesFile);
        if (stream != null) {
            return stream;
        }
        File workingDirectoryFile = new File(systemProps.getProperty("imply.properties.file", propertiesFile));
        if (workingDirectoryFile.exists()) {
            return new BufferedInputStream(new FileInputStream(workingDirectoryFile));
        }
        return null;
    }

    private void loadFile(InputStream inputStream, Properties fileProps) {
        try (InputStreamReader stream = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            fileProps.load(stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

