/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.guice;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.jvm.CachedThreadStatesGaugeSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Singleton;
import io.dropwizard.metrics.logback13.InstrumentedAppender;
import java.util.concurrent.TimeUnit;
import org.slf4j.LoggerFactory;

public class MetricsModule
implements Module {
    private static final MetricRegistry METRIC_REGISTRY = new MetricRegistry();

    public void configure(Binder binder) {
        binder.bind(MetricRegistry.class).toInstance((Object)METRIC_REGISTRY);
        binder.bind(HealthCheckRegistry.class).in(Singleton.class);
    }

    static {
        METRIC_REGISTRY.register("gc", (Metric)new GarbageCollectorMetricSet());
        METRIC_REGISTRY.register("threads", (Metric)new CachedThreadStatesGaugeSet(10L, TimeUnit.SECONDS));
        METRIC_REGISTRY.register("memory", (Metric)new MemoryUsageGaugeSet());
        Logger root = ((LoggerContext)LoggerFactory.getILoggerFactory()).getLogger("ROOT");
        InstrumentedAppender metrics = new InstrumentedAppender(METRIC_REGISTRY);
        metrics.setContext((Context)root.getLoggerContext());
        metrics.start();
        root.addAppender((Appender)metrics);
    }
}

