/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.guice;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import io.imply.cloud.config.ClientConfig;
import io.imply.cloud.guice.JsonConfigProvider;
import io.imply.cloud.guice.LifecycleModule;
import io.imply.cloud.guice.annotations.LazySingleton;
import io.imply.cloud.lifecycle.Lifecycle;
import io.imply.cloud.security.CertificateManager;
import io.imply.cloud.util.Logger;
import org.eclipse.jetty.client.HttpClient;

public class JettyClientModule
implements Module {
    private static final Logger log = new Logger(JettyClientModule.class);

    public void configure(Binder binder) {
        LifecycleModule.register(binder, HttpClient.class);
        JsonConfigProvider.bind(binder, "client.http", ClientConfig.class);
    }

    @Provides
    @LazySingleton
    public HttpClient getHttpClient(Lifecycle lifecycle, CertificateManager certificateManager, ClientConfig clientConfig) {
        HttpClient httpClient = new HttpClient(certificateManager.getSslContextFactory());
        JettyClientModule.initializeClient(lifecycle, httpClient);
        httpClient.setRequestBufferSize(clientConfig.getRequestBufferSize());
        return httpClient;
    }

    static void initializeClient(Lifecycle lifecycle, final HttpClient httpClient) {
        lifecycle.addHandler(new Lifecycle.Handler(){

            @Override
            public void start() throws Exception {
                httpClient.start();
            }

            @Override
            public void stop() {
                try {
                    httpClient.stop();
                }
                catch (Exception e) {
                    log.warn(e, "Unable to stop Jetty client.");
                }
            }
        });
    }
}

