/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.guice;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.config.ExtensionsConfig;
import io.imply.cloud.guice.ConfigModule;
import io.imply.cloud.guice.GuiceExtensions;
import io.imply.cloud.guice.JsonConfigProvider;
import io.imply.cloud.guice.PropertiesModule;
import io.imply.cloud.jackson.JacksonModule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class GuiceInjectors {
    public static Collection<Module> makeDefaultStartupModules() {
        return ImmutableList.of((Object)new GuiceExtensions(), (Object)new JacksonModule(), (Object)new ConfigModule(), (Object)new PropertiesModule(Arrays.asList("runtime.properties")), binder -> {
            JsonConfigProvider.bind(binder, "application", ApplicationConfig.class);
            JsonConfigProvider.bind(binder, "extensions", ExtensionsConfig.class);
        });
    }

    public static Injector makeStartupInjector() {
        return Guice.createInjector(GuiceInjectors.makeDefaultStartupModules());
    }

    public static Injector makeStartupInjectorWithModules(Iterable<? extends Module> modules) {
        ArrayList theModules = Lists.newArrayList();
        theModules.addAll(GuiceInjectors.makeDefaultStartupModules());
        for (Module module : modules) {
            theModules.add(module);
        }
        return Guice.createInjector((Iterable)theModules);
    }
}

