/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.grove;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.imply.cloud.grove.GroveResult;
import java.io.IOException;
import java.util.List;

public class GroveSysResult
extends GroveResult {
    private final SysInfo sysInfo;

    @JsonCreator
    public GroveSysResult(@JacksonInject ObjectMapper objectMapper, @JsonProperty(value="host") String host, @JsonProperty(value="ok") Boolean ok, @JsonProperty(value="result") String result) {
        super(objectMapper, host, ok, result);
        try {
            this.sysInfo = this.isOk() ? (SysInfo)objectMapper.readValue(result, SysInfo.class) : null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public SwapMemory getSwapMemory() {
        return this.sysInfo == null ? null : this.sysInfo.swapMemory;
    }

    public Memory getMemory() {
        return this.sysInfo == null ? null : this.sysInfo.memory;
    }

    public List<Cpu> getCpus() {
        return this.sysInfo == null ? null : this.sysInfo.cpus;
    }

    public List<Disk> getDisks() {
        return this.sysInfo == null ? null : this.sysInfo.disks;
    }

    private static class SysInfo {
        private final SwapMemory swapMemory;
        private final Memory memory;
        private final List<Cpu> cpus;
        private final List<Disk> disks;

        @JsonCreator
        private SysInfo(@JsonProperty(value="swap_mem") SwapMemory swapMemory, @JsonProperty(value="mem") Memory memory, @JsonProperty(value="cpu") List<Cpu> cpus, @JsonProperty(value="disk") List<Disk> disks) {
            this.swapMemory = swapMemory;
            this.memory = memory;
            this.cpus = cpus;
            this.disks = disks;
        }
    }

    public static class SwapMemory {
        private final Float percent;
        private final Long total;
        private final Long used;
        private final Long free;

        @JsonCreator
        private SwapMemory(@JsonProperty(value="percent") Float percent, @JsonProperty(value="total") Long total, @JsonProperty(value="used") Long used, @JsonProperty(value="free") Long free) {
            this.percent = percent;
            this.total = total;
            this.used = used;
            this.free = free;
        }

        public Float getPercent() {
            return this.percent;
        }

        public Long getTotal() {
            return this.total;
        }

        public Long getUsed() {
            return this.used;
        }

        public Long getFree() {
            return this.free;
        }
    }

    public static class Memory {
        private final Float percent;
        private final Long buffers;
        private final Long available;
        private final Long total;
        private final Long used;
        private final Long free;
        private final Long cached;

        @JsonCreator
        private Memory(@JsonProperty(value="percent") Float percent, @JsonProperty(value="buffers") Long buffers, @JsonProperty(value="available") Long available, @JsonProperty(value="total") Long total, @JsonProperty(value="used") Long used, @JsonProperty(value="free") Long free, @JsonProperty(value="cached") Long cached) {
            this.percent = percent;
            this.buffers = buffers;
            this.available = available;
            this.total = total;
            this.used = used;
            this.free = free;
            this.cached = cached;
        }

        public Float getPercent() {
            return this.percent;
        }

        public Long getBuffers() {
            return this.buffers;
        }

        public Long getAvailable() {
            return this.available;
        }

        public Long getTotal() {
            return this.total;
        }

        public Long getUsed() {
            return this.used;
        }

        public Long getFree() {
            return this.free;
        }

        public Long getCached() {
            return this.cached;
        }
    }

    public static class Disk {
        private final Float percent;
        private final String device;
        private final String mount;
        private final Long used;
        private final Long total;
        private final Long free;

        @JsonCreator
        private Disk(@JsonProperty(value="percent") Float percent, @JsonProperty(value="device") String device, @JsonProperty(value="mount") String mount, @JsonProperty(value="used") Long used, @JsonProperty(value="total") Long total, @JsonProperty(value="free") Long free) {
            this.percent = percent;
            this.device = device;
            this.mount = mount;
            this.used = used;
            this.total = total;
            this.free = free;
        }

        public Float getPercent() {
            return this.percent;
        }

        public String getDevice() {
            return this.device;
        }

        public String getMount() {
            return this.mount;
        }

        public Long getUsed() {
            return this.used;
        }

        public Long getTotal() {
            return this.total;
        }

        public Long getFree() {
            return this.free;
        }
    }

    public static class Cpu {
        private final Integer id;
        private final Float nice;
        private final Float sys;
        private final Float idle;
        private final Float user;

        @JsonCreator
        private Cpu(@JsonProperty(value="id") Integer id, @JsonProperty(value="nice") Float nice, @JsonProperty(value="sys") Float sys, @JsonProperty(value="idle") Float idle, @JsonProperty(value="user") Float user) {
            this.id = id;
            this.nice = nice;
            this.sys = sys;
            this.idle = idle;
            this.user = user;
        }

        public Integer getId() {
            return this.id;
        }

        public Float getNice() {
            return this.nice;
        }

        public Float getSys() {
            return this.sys;
        }

        public Float getIdle() {
            return this.idle;
        }

        public Float getUser() {
            return this.user;
        }
    }
}

