/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.grove;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.imply.cloud.grove.GroveResult;
import java.io.IOException;

public class GroveRunResult
extends GroveResult {
    private final InnerRunResult runResult;

    @JsonCreator
    public GroveRunResult(@JacksonInject ObjectMapper objectMapper, @JsonProperty(value="host") String host, @JsonProperty(value="ok") Boolean ok, @JsonProperty(value="result") String result) {
        super(objectMapper, host, ok, result);
        try {
            this.runResult = this.isOk() ? (InnerRunResult)objectMapper.readValue(result, InnerRunResult.class) : null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Integer getExitCode() {
        return this.runResult == null ? null : this.runResult.exitCode;
    }

    public boolean isOkExitCode() {
        return this.getExitCode() != null && this.getExitCode() == 0;
    }

    public String getOutput() {
        return this.runResult == null ? null : this.runResult.output;
    }

    private static class InnerRunResult {
        private final Integer exitCode;
        private final String output;

        @JsonCreator
        private InnerRunResult(@JsonProperty(value="exit_code") Integer exitCode, @JsonProperty(value="output") String output) {
            this.exitCode = exitCode;
            this.output = output;
        }
    }
}

