/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.grove;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.imply.cloud.grove.GroveResult;
import java.io.IOException;
import java.util.List;
import org.joda.time.DateTime;

public class GroveHistoryResult
extends GroveResult {
    private final List<TimestampHashPair> timestampHashPairs;

    @JsonCreator
    public GroveHistoryResult(@JacksonInject ObjectMapper objectMapper, @JsonProperty(value="host") String host, @JsonProperty(value="ok") Boolean ok, @JsonProperty(value="result") String result) {
        super(objectMapper, host, ok, result);
        try {
            this.timestampHashPairs = this.isOk() ? (List)objectMapper.readValue(result, (TypeReference)new TypeReference<List<TimestampHashPair>>(){}) : null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<TimestampHashPair> getTimestampHashPairs() {
        return this.timestampHashPairs;
    }

    public static class TimestampHashPair {
        private final DateTime timestamp;
        private final String hashedServiceParts;

        @JsonCreator
        public TimestampHashPair(@JsonProperty(value="timestamp") Double timestamp, @JsonProperty(value="hashed_service_parts") String hashedServiceParts) {
            this.timestamp = timestamp == null ? null : new DateTime((long)(timestamp * 1000.0));
            this.hashedServiceParts = hashedServiceParts;
        }

        public DateTime getTimestamp() {
            return this.timestamp;
        }

        public String getHashedServiceParts() {
            return this.hashedServiceParts;
        }
    }
}

