/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.grove;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.exception.BadGatewayException;
import io.imply.cloud.exception.GatewayTimeoutException;
import io.imply.cloud.exception.GroveAgentException;
import io.imply.cloud.grove.GroveAgent;
import io.imply.cloud.grove.GroveAgentUtil;
import io.imply.cloud.grove.GroveBecomeResult;
import io.imply.cloud.grove.GroveDeploySpec;
import io.imply.cloud.grove.GroveHistoryResult;
import io.imply.cloud.grove.GroveResult;
import io.imply.cloud.grove.GroveRunResult;
import io.imply.cloud.grove.GroveSysResult;
import io.imply.cloud.grove.Node;
import io.imply.cloud.http.HttpClientProvider;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.Logger;
import io.imply.cloud.util.Retryable;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.BasicAuthentication;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;

public class GroveClient {
    private static final Logger log = new Logger(GroveClient.class);
    private static final String SCHEME_HTTP = "http";
    private static final String SCHEME_HTTPS = "https";
    private static final String AGENT_DO_PATH = "/do";
    private static final String SERVER_REAP_PATH = "/reap";
    private final HttpClientProvider httpClientProvider;
    private final ObjectMapper objectMapper;
    private final ApplicationConfig applicationConfig;
    private final String scheme;

    @Inject
    public GroveClient(HttpClientProvider httpClientProvider, ObjectMapper objectMapper, ApplicationConfig applicationConfig) {
        this.httpClientProvider = httpClientProvider;
        this.objectMapper = objectMapper;
        this.applicationConfig = applicationConfig;
        this.scheme = applicationConfig.useTls() ? SCHEME_HTTPS : SCHEME_HTTP;
    }

    public List<Node> getGroveNodes(String serverHost, boolean onlineOnly) {
        return GroveAgentUtil.getNodeListFromGroveAgents(this.getGroveAgents(serverHost, onlineOnly));
    }

    private List<GroveAgent> getGroveAgents(String serverHost, boolean onlineOnly) {
        String resources = Retryable.of(() -> this.get(serverHost, this.scheme, "/agents", 3, null, null), 3, 1);
        ObjectReader reader = this.objectMapper.readerFor((TypeReference)new TypeReference<Map<String, GroveAgent>>(){}).withRootName("agents");
        try {
            Map agents = (Map)reader.readValue(resources);
            if (agents == null) {
                return null;
            }
            return agents.entrySet().stream().filter(x -> x.getValue() != null && (!onlineOnly || ((GroveAgent)x.getValue()).getOnline() != null && ((GroveAgent)x.getValue()).getOnline() != false)).map(x -> ((GroveAgent)x.getValue()).withHost((String)x.getKey())).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<GroveBecomeResult> becomeWithServiceYamlPath(String serverHost, List<String> agents, String serviceYamlPath, String serviceType, List<String> postDeployParams, boolean alwaysBounce) {
        return this.becomeInternal(serverHost, agents, null, serviceYamlPath, serviceType, postDeployParams, alwaysBounce);
    }

    public List<GroveBecomeResult> becomeWithDeploySpec(String serverHost, List<String> agents, GroveDeploySpec deploySpec, String serviceType, List<String> postDeployParams, boolean alwaysBounce) {
        try {
            return this.becomeInternal(serverHost, agents, this.objectMapper.writeValueAsString((Object)deploySpec), null, serviceType, postDeployParams, alwaysBounce);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public List<GroveResult> bounce(String serverHost, List<String> agents, int timeout) {
        ImmutableMap payload = ImmutableMap.of((Object)"agents", agents, (Object)"command", (Object)ImmutableMap.of((Object)"type", (Object)"bounce", (Object)"timeout", (Object)timeout));
        ObjectReader reader = this.objectMapper.readerFor((TypeReference)new TypeReference<List<GroveResult>>(){}).withRootName("results");
        try {
            return (List)reader.readValue(this.post(serverHost, this.scheme, AGENT_DO_PATH, this.stringify((Map<String, Object>)payload), timeout + 15, null, null));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> reap(String serverHost, List<String> agents) {
        ImmutableMap payload = ImmutableMap.of((Object)"agents", agents);
        ObjectReader reader = this.objectMapper.readerFor((TypeReference)new TypeReference<List<String>>(){}).withRootName("remaining");
        try {
            return (List)reader.readValue(this.post(serverHost, this.scheme, SERVER_REAP_PATH, this.stringify((Map<String, Object>)payload), 15, null, null));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<GroveHistoryResult> history(String serverHost, List<String> agents) {
        ImmutableMap payload = ImmutableMap.of((Object)"agents", agents, (Object)"command", (Object)ImmutableMap.of((Object)"type", (Object)"history"));
        ObjectReader reader = this.objectMapper.readerFor((TypeReference)new TypeReference<List<GroveHistoryResult>>(){}).withRootName("results");
        try {
            return (List)reader.readValue(this.post(serverHost, this.scheme, AGENT_DO_PATH, this.stringify((Map<String, Object>)payload), null, null, null));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<GroveRunResult> run(String serverHost, List<String> agents, String args, boolean output, int timeout) {
        ImmutableMap payload = ImmutableMap.of((Object)"agents", agents, (Object)"command", (Object)ImmutableMap.of((Object)"type", (Object)"run", (Object)"args", (Object)args, (Object)"output", (Object)output, (Object)"timeout", (Object)timeout));
        ObjectReader reader = this.objectMapper.readerFor((TypeReference)new TypeReference<List<GroveRunResult>>(){}).withRootName("results");
        try {
            return (List)reader.readValue(this.post(serverHost, this.scheme, AGENT_DO_PATH, this.stringify((Map<String, Object>)payload), timeout + 15, null, null));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<GroveResult> write(String serverHost, List<String> agents, String content, String outputPath, Integer mode) {
        ImmutableMap payload = ImmutableMap.of((Object)"agents", agents, (Object)"command", (Object)ImmutableMap.of((Object)"type", (Object)"write", (Object)"path", (Object)outputPath, (Object)"content", (Object)content, (Object)"mode", (Object)(mode != null ? mode : 644)));
        ObjectReader reader = this.objectMapper.readerFor((TypeReference)new TypeReference<List<GroveResult>>(){}).withRootName("results");
        try {
            return (List)reader.readValue(this.post(serverHost, this.scheme, AGENT_DO_PATH, this.stringify((Map<String, Object>)payload), null, null, null));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<GroveResult> fetch(String serverHost, List<String> agents, String sourceUrl, String outputPath, Integer mode) {
        return this.fetch(serverHost, agents, sourceUrl, outputPath, mode, null, null);
    }

    public List<GroveResult> fetch(String serverHost, List<String> agents, String sourceUrl, String outputPath, Integer mode, String basicAuthUser, String basicAuthPassword) {
        ImmutableMap.Builder command = ImmutableMap.builder().put((Object)"type", (Object)"write").put((Object)"path", (Object)outputPath).put((Object)"source", (Object)sourceUrl).put((Object)"mode", (Object)(mode != null ? mode : 644));
        if (basicAuthUser != null && basicAuthPassword != null) {
            command.put((Object)"user", (Object)basicAuthUser).put((Object)"password", (Object)basicAuthPassword);
        }
        ImmutableMap payload = ImmutableMap.of((Object)"agents", agents, (Object)"command", (Object)command.build());
        ObjectReader reader = this.objectMapper.readerFor((TypeReference)new TypeReference<List<GroveResult>>(){}).withRootName("results");
        try {
            return (List)reader.readValue(this.post(serverHost, this.scheme, AGENT_DO_PATH, this.stringify((Map<String, Object>)payload), 90, null, null));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<GroveSysResult> getSystemMetrics(String serverHost, List<String> agents) {
        ImmutableMap payload = ImmutableMap.of((Object)"agents", agents, (Object)"command", (Object)ImmutableMap.of((Object)"type", (Object)"sys"));
        ObjectReader reader = this.objectMapper.readerFor((TypeReference)new TypeReference<List<GroveSysResult>>(){}).withRootName("results");
        try {
            return (List)reader.readValue(this.post(serverHost, this.scheme, AGENT_DO_PATH, this.stringify((Map<String, Object>)payload), null, null, null));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void simpleRun(String serverHost, List<String> targetHosts, String args, int timeout, boolean throwOnNonZeroExit) {
        List<GroveRunResult> results;
        if (!args.startsWith("mysql")) {
            log.info("Running command on %s: %s", targetHosts, args);
        }
        if ((results = this.run(serverHost, targetHosts, args, true, timeout)) == null || results.isEmpty()) {
            throw new ISE("Empty response returned from Grove server", new Object[0]);
        }
        for (GroveRunResult result : results) {
            if (!result.isOk()) {
                throw new GroveAgentException("Server returned failure response for [%s]: %s", result.getHost(), result.getErrorMessage());
            }
            if (!throwOnNonZeroExit || result.isOkExitCode()) continue;
            throw new GroveAgentException("Command on host [%s] returned non-zero exit code [%s]: %s", result.getHost(), result.getExitCode(), result.getOutput());
        }
    }

    public void retryableSimpleRun(String serverHost, List<String> targetHosts, String args, int timeout, boolean throwOnNonZeroExit) {
        Retryable.of(() -> {
            this.simpleRun(serverHost, targetHosts, args, timeout, throwOnNonZeroExit);
            return null;
        });
    }

    private String stringify(Map<String, Object> data) {
        try {
            return this.objectMapper.writeValueAsString(data);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private List<GroveBecomeResult> becomeInternal(String serverHost, List<String> agents, String serviceYaml, String serviceYamlPath, String serviceType, List<String> postDeployParams, boolean alwaysBounce) {
        ImmutableMap.Builder command = new ImmutableMap.Builder().put((Object)"type", (Object)"become").put((Object)"service_type", (Object)serviceType);
        if (serviceYaml != null) {
            command.put((Object)"service_yaml", (Object)serviceYaml);
        }
        if (serviceYamlPath != null) {
            command.put((Object)"service_yaml_path", (Object)serviceYamlPath);
        }
        if (postDeployParams != null) {
            command.put((Object)"post_deploy_params", postDeployParams);
        }
        if (alwaysBounce) {
            command.put((Object)"always_bounce", (Object)true);
        }
        ImmutableMap payload = ImmutableMap.of((Object)"agents", agents, (Object)"command", (Object)command.build());
        ObjectReader reader = this.objectMapper.readerFor((TypeReference)new TypeReference<List<GroveBecomeResult>>(){}).withRootName("results");
        try {
            List becomeInternalResults = (List)reader.readValue(this.post(serverHost, this.scheme, AGENT_DO_PATH, this.stringify((Map<String, Object>)payload), 300, null, null));
            for (GroveBecomeResult result : becomeInternalResults) {
                if (result.isOk()) continue;
                throw new GroveAgentException("Server returned failure response for [%s]: %s", result.getHost(), result.getErrorMessage());
            }
            return becomeInternalResults;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String get(String host, String scheme, String path, Integer timeoutInSeconds, String query, Map<String, String> headers) {
        return this.request(host, scheme, path, HttpMethod.GET, null, timeoutInSeconds, query, headers);
    }

    private String post(String host, String scheme, String path, String content, Integer timeoutInSeconds, String query, Map<String, String> headers) {
        return this.request(host, scheme, path, HttpMethod.POST, content, timeoutInSeconds, query, headers);
    }

    private String request(String host, String scheme, String path, HttpMethod method, String content, Integer timeoutInSeconds, String query, Map<String, String> headers) {
        int port;
        String[] fragments = host.split(":");
        if (fragments.length != 2) {
            throw new IAE("Invalid Grove server host [%s] (should be of the form 127.0.0.1:9999", host);
        }
        try {
            port = Integer.parseInt(fragments[1]);
        }
        catch (NumberFormatException e) {
            throw new IAE("Failed to parse port as integer from [%s]", host);
        }
        URI uri = null;
        try {
            uri = new URI(scheme, null, fragments[0], port, path, query, null);
            Request request = this.httpClientProvider.get(true).newRequest(uri).method(method).timeout(timeoutInSeconds != null ? (long)timeoutInSeconds.intValue() : 10L, TimeUnit.SECONDS);
            if (this.applicationConfig.useGroveAuthentication()) {
                BasicAuthentication.BasicResult auth = new BasicAuthentication.BasicResult(uri, this.applicationConfig.getGroveUsername(), this.applicationConfig.getGrovePassword());
                auth.apply(request);
            }
            if (content != null) {
                request.content((ContentProvider)new StringContentProvider(MimeTypes.Type.APPLICATION_JSON.asString(), content, StandardCharsets.UTF_8));
            }
            if (headers != null) {
                headers.forEach((arg_0, arg_1) -> ((Request)request).header(arg_0, arg_1));
            }
            log.debug("Req: %s %s%s", method, uri, content == null ? "" : String.format(" [%s]", content));
            long startTime = System.currentTimeMillis();
            ContentResponse response = request.send();
            log.debug("Res: %d (t=%dms)", response.getStatus(), System.currentTimeMillis() - startTime);
            String data = response.getContentAsString();
            if (data != null) {
                log.trace("Res: %s", data);
            }
            if (response.getStatus() / 100 != 2) {
                throw new ISE("Status code [%d] calling %s %s", response.getStatus(), method, uri);
            }
            if (HttpMethod.GET.equals((Object)method) && (data == null || data.isEmpty())) {
                throw new ISE("Empty GET response from [%s]", uri);
            }
            return data;
        }
        catch (TimeoutException e) {
            throw new GatewayTimeoutException("Timeout waiting for Grove server", e);
        }
        catch (ExecutionException e) {
            if (e.getCause() != null && e.getCause() instanceof ConnectException) {
                throw new BadGatewayException(String.format("Could not contact Grove server [%s]", host));
            }
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug(e, "Bad response while calling [%s %s]", method, uri);
            } else {
                log.info("Bad response while calling [%s %s]: %s -> %s", method, uri, e.getClass().getName(), e.getMessage());
            }
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

