/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.druid;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.imply.cloud.Constants;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.http.HttpClientProvider;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ServiceType;
import io.imply.cloud.model.druid.CloneStatus;
import io.imply.cloud.model.druid.GetTaskPayloadResponse;
import io.imply.cloud.model.druid.ImmutableWorkerInfo;
import io.imply.cloud.model.druid.LoadRule;
import io.imply.cloud.model.druid.SimpleComputeServer;
import io.imply.cloud.model.druid.SyncedBroker;
import io.imply.cloud.model.druid.TaskListItem;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.security.Authentication;
import io.imply.cloud.security.DruidAuthManager;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.Logger;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;

public class DruidApiClient {
    protected static final String SCHEME_HTTP = "http";
    protected static final String SCHEME_HTTPS = "https";
    private static final Logger log = new Logger(DruidApiClient.class);
    private static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    private final HttpClientProvider httpClientProvider;
    private final ObjectMapper objectMapper;
    private final DruidAuthManager druidAuthManager;
    private final ClusterDataManager clusterDataManager;
    private final ApplicationConfig applicationConfig;
    private final JavaType listOfStringsType;

    public static String generateAuditAuthor(String detailedUserId) {
        if (detailedUserId == null) {
            return "[Imply Cloud System]";
        }
        Matcher matcher = Constants.IMPERSONATED_USER_ID_PATTERN.matcher(detailedUserId);
        if (matcher.matches()) {
            return String.format("%s %s on behalf of %s", "[Imply Cloud System]", matcher.group(1), matcher.group(2));
        }
        return String.format("%s %s", "[Imply Cloud System]", detailedUserId);
    }

    @Inject
    public DruidApiClient(HttpClientProvider httpClientProvider, ObjectMapper objectMapper, DruidAuthManager druidAuthManager, ClusterDataManager clusterDataManager, ApplicationConfig applicationConfig) {
        this.httpClientProvider = httpClientProvider;
        this.objectMapper = objectMapper;
        this.druidAuthManager = druidAuthManager;
        this.clusterDataManager = clusterDataManager;
        this.applicationConfig = applicationConfig;
        this.listOfStringsType = objectMapper.getTypeFactory().constructCollectionType(List.class, String.class);
    }

    public long getDataSize(Supplier<Collection<String>> hosts, String clusterId) {
        return this.runSQLQuery(hosts, clusterId, "SELECT SUM(\"size\") FILTER (WHERE (is_published = 1 OR is_realtime = 1) AND replication_factor > 0) AS total_data_size FROM sys.segments", (List<Map<String, Object>> result) -> {
            if (CollectionUtils.isEmpty((Collection)result) || ((Map)result.get(0)).get("total_data_size") == null) {
                return 0L;
            }
            return ((Number)((Map)result.get(0)).get("total_data_size")).longValue();
        });
    }

    public long getCapacity(Supplier<Collection<String>> hosts, String clusterId) {
        return this.runSQLQuery(hosts, clusterId, "SELECT SUM(\"max_size\") AS max_size FROM sys.servers", (List<Map<String, Object>> result) -> CollectionUtils.isEmpty((Collection)result) ? Long.valueOf(0L).longValue() : ((Number)((Map)result.get(0)).get("max_size")).longValue());
    }

    public int getSegmentCount(Collection<String> hosts, String clusterId) {
        return this.runSQLQuery(hosts, clusterId, "SELECT COUNT(*) AS segmentCount FROM sys.segments", (List<Map<String, Object>> result) -> CollectionUtils.isEmpty((Collection)result) ? Integer.valueOf(0) : (Integer)((Map)result.get(0)).get("segmentCount"));
    }

    public String getCoordinatorDynamicConfiguration(Collection<String> hosts, String clusterId) {
        Cluster cluster = this.clusterDataManager.getOrNull(clusterId);
        return this.get(this.getCoordinatorTarget(hosts, "/druid/coordinator/v1/config", cluster), null, cluster, null, true);
    }

    public String setCoordinatorDynamicConfiguration(Collection<String> hosts, String configurationData, String clusterId, String auditAuthor, String auditComment) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (auditAuthor != null) {
            headers.put("X-Druid-Author", auditAuthor);
        }
        if (auditComment != null) {
            headers.put("X-Druid-Comment", auditComment);
        }
        Cluster cluster = this.clusterDataManager.getOrNull(clusterId);
        return this.post(this.getCoordinatorTarget(hosts, "/druid/coordinator/v1/config", cluster), configurationData, null, cluster, headers, true);
    }

    public Map<String, List<LoadRule>> getLoadRules(Collection<String> hosts, String clusterId) {
        Cluster cluster = this.clusterDataManager.getOrNull(clusterId);
        String data = this.get(this.getCoordinatorTarget(hosts, "/druid/coordinator/v1/rules", cluster), null, cluster, null, false);
        try {
            return (Map)this.objectMapper.readValue(data, (TypeReference)new TypeReference<Map<String, List<LoadRule>>>(){});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String setLoadRuleConfiguration(Collection<String> hosts, String loadRule, List<LoadRule> ruleConfiguration, String clusterId, String auditAuthor, String auditComment) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (auditAuthor != null) {
            headers.put("X-Druid-Author", auditAuthor);
        }
        if (auditComment != null) {
            headers.put("X-Druid-Comment", auditComment);
        }
        Cluster cluster = this.clusterDataManager.getOrNull(clusterId);
        try {
            return this.post(this.getCoordinatorTarget(hosts, String.format("%s/%s", "/druid/coordinator/v1/rules", loadRule), cluster), this.objectMapper.writeValueAsString(ruleConfiguration), null, cluster, headers, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String setLoadRuleConfiguration(Collection<String> hosts, String loadRule, String ruleConfiguration, String clusterId, String auditAuthor, String auditComment) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (auditAuthor != null) {
            headers.put("X-Druid-Author", auditAuthor);
        }
        if (auditComment != null) {
            headers.put("X-Druid-Comment", auditComment);
        }
        Cluster cluster = this.clusterDataManager.getOrNull(clusterId);
        return this.post(this.getCoordinatorTarget(hosts, String.format("%s/%s", "/druid/coordinator/v1/rules", loadRule), cluster), ruleConfiguration, null, cluster, headers, false);
    }

    public String getOverlordDynamicConfiguration(Collection<String> hosts, String clusterId) {
        Cluster cluster = this.clusterDataManager.getOrNull(clusterId);
        return this.get(this.getOverlordTarget(hosts, "/druid/indexer/v1/worker", cluster), null, cluster, null, true, true);
    }

    public String setOverlordDynamicConfiguration(Collection<String> hosts, String configurationData, String clusterId, String auditAuthor, String auditComment) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (auditAuthor != null) {
            headers.put("X-Druid-Author", auditAuthor);
        }
        if (auditComment != null) {
            headers.put("X-Druid-Comment", auditComment);
        }
        Cluster cluster = this.clusterDataManager.getOrNull(clusterId);
        return this.post(this.getOverlordTarget(hosts, "/druid/indexer/v1/worker", cluster), configurationData, null, cluster, headers, true);
    }

    public List<SimpleComputeServer> getHistoricalHosts(Collection<String> hosts, String clusterId) {
        Cluster cluster = this.clusterDataManager.getOrNull(clusterId);
        String data = this.get(this.getCoordinatorTarget(hosts, "/druid/coordinator/v1/servers", cluster), "simple", cluster, null, true);
        try {
            List allServers = (List)this.objectMapper.readValue(data, (TypeReference)new TypeReference<List<SimpleComputeServer>>(){});
            return allServers.stream().filter(x -> x.getType() != null && x.getType().toLowerCase().equals("historical")).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<ImmutableWorkerInfo> getWorkers(Collection<String> hosts, String clusterId) {
        Cluster cluster = this.clusterDataManager.getOrNull(clusterId);
        String data = this.get(this.getOverlordTarget(hosts, "/druid/indexer/v1/workers", cluster), null, cluster, null, true);
        try {
            return (List)this.objectMapper.readValue(data, (TypeReference)new TypeReference<List<ImmutableWorkerInfo>>(){});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getMiddleManagerTasks(String host, String clusterId) {
        Cluster cluster = this.clusterDataManager.getOrNull(clusterId);
        String data = this.get(this.getMiddleManagerTarget((Collection<String>)ImmutableSet.of((Object)host), "/druid/worker/v1/tasks", cluster), null, cluster, null, true);
        try {
            return (List)this.objectMapper.readValue(data, this.listOfStringsType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<TaskListItem> getRunningTasks(String clusterId, List<String> masterHosts, String taskType) {
        Cluster cluster = this.clusterDataManager.getOrNull(clusterId);
        String data = this.get(this.getOverlordTarget(masterHosts, "/druid/indexer/v1/tasks", cluster), String.format("state=running&type=%s", taskType), cluster, null, true);
        try {
            return (List)this.objectMapper.readValue(data, (TypeReference)new TypeReference<List<TaskListItem>>(){});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public GetTaskPayloadResponse getTaskPayload(String clusterId, List<String> masterHosts, String taskId) {
        Cluster cluster = this.clusterDataManager.getOrNull(clusterId);
        String data = this.get(this.getOverlordTarget(masterHosts, String.format("/druid/indexer/v1/task/%s", taskId), cluster), null, cluster, null, true);
        try {
            return (GetTaskPayloadResponse)this.objectMapper.readValue(data, GetTaskPayloadResponse.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String createOrUpdateSupervisor(String clusterId, Collection<String> masterHosts, String supervisorPayload) {
        Cluster cluster = this.clusterDataManager.getOrNull(clusterId);
        return this.post(this.getOverlordTarget(masterHosts, "/druid/indexer/v1/supervisor", cluster), supervisorPayload, null, cluster, null, true);
    }

    public String createOrUpdateCatalogTable(String clusterId, Collection<String> masterHosts, String catalogPayload, String schema, String table) {
        Cluster cluster = this.clusterDataManager.getOrNull(clusterId);
        String path = String.format("/druid/coordinator/v1/catalog/schemas/%s/tables/%s", schema, table);
        return this.post(this.getCoordinatorTarget(masterHosts, path, cluster), catalogPayload, null, cluster, null, true);
    }

    public String handoffSupervisorTasksEarly(String clusterId, List<String> masterHosts, String dataSource, List<Integer> groupIds) {
        Cluster cluster = this.clusterDataManager.getOrNull(clusterId);
        try {
            String handoffPayload = this.objectMapper.writeValueAsString((Object)ImmutableMap.of((Object)"taskGroupIds", groupIds));
            return this.post(this.getOverlordTarget(masterHosts, String.format("/druid/indexer/v1/supervisor/%s/taskGroups/handoff", dataSource), cluster), handoffPayload, null, cluster, null, true);
        }
        catch (JsonProcessingException e) {
            log.error("Failed to serialize payload to trigger early handoff of streaming tasks");
            throw new RuntimeException(e);
        }
    }

    public String disableMiddleManager(String host, String clusterId) {
        Cluster cluster = this.clusterDataManager.getOrNull(clusterId);
        return this.post(this.getMiddleManagerTarget((Collection<String>)ImmutableSet.of((Object)host), "/druid/worker/v1/disable", cluster), null, null, cluster, null, true);
    }

    public String enableMiddleManager(String host, String clusterId) {
        Cluster cluster = this.clusterDataManager.getOrNull(clusterId);
        return this.post(this.getMiddleManagerTarget((Collection<String>)ImmutableSet.of((Object)host), "/druid/worker/v1/enable", cluster), null, null, cluster, null, true);
    }

    public String configureAutoCompactionTaskSlots(Collection<String> hosts, String clusterId, Double compactionSlotRatio, Integer maxTaskSlots, Boolean useAutoScaleSlots, String auditAuthor, String auditComment) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (auditAuthor != null) {
            headers.put("X-Druid-Author", auditAuthor);
        }
        if (auditComment != null) {
            headers.put("X-Druid-Comment", auditComment);
        }
        Cluster cluster = this.clusterDataManager.getOrNull(clusterId);
        return this.post(this.getCoordinatorTarget(hosts, "/druid/coordinator/v1/config/compaction/taskslots", cluster), null, String.format("ratio=%.2f&max=%d&useAutoScaleSlots=%s", compactionSlotRatio, maxTaskSlots, useAutoScaleSlots), cluster, headers, true);
    }

    public boolean isWorkerOnline(String host, Collection<String> masterHosts, String clusterId) {
        return this.getWorkers(masterHosts, clusterId).stream().anyMatch(x -> x.getWorker().getIp().contains(host) || x.getWorker().getIp().contains(host.replace('.', '-')));
    }

    public Map<String, Map<String, Long>> getFullLoadStatus(Collection<String> masterHosts, String clusterId, Boolean computeUsingClusterView) {
        Cluster cluster = this.clusterDataManager.getOrNull(clusterId);
        String query = computeUsingClusterView != false ? "full&computeUsingClusterView" : "full";
        String data = this.get(this.getCoordinatorTarget(masterHosts, "/druid/coordinator/v1/loadstatus", cluster), query, cluster, null, true);
        try {
            return (Map)this.objectMapper.readValue(data, (TypeReference)new TypeReference<Map<String, Map<String, Long>>>(){});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<CloneStatus> getCloneStatus(Collection<String> masterHosts, String clusterId) {
        Cluster cluster = this.clusterDataManager.getOrNull(clusterId);
        String data = this.get(this.getCoordinatorTarget(masterHosts, "/druid/coordinator/v1/config/cloneStatus", cluster), null, cluster, null, true);
        try {
            return (List)((Map)this.objectMapper.readValue(data, (TypeReference)new TypeReference<Map<String, List<CloneStatus>>>(){})).get("cloneStatus");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<SyncedBroker> getSyncedBrokers(Collection<String> masterHosts, String clusterId) {
        Cluster cluster = this.clusterDataManager.getOrNull(clusterId);
        String data = this.get(this.getCoordinatorTarget(masterHosts, "/druid/coordinator/v1/config/syncedBrokers", cluster), null, cluster, null, true);
        try {
            return (List)((Map)this.objectMapper.readValue(data, (TypeReference)new TypeReference<Map<String, List<SyncedBroker>>>(){})).get("syncedBrokers");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getDatasources(Collection<String> masterHosts, String clusterId) {
        Cluster cluster = this.clusterDataManager.getOrNull(clusterId);
        String data = this.get(this.getCoordinatorTarget(masterHosts, "/druid/coordinator/v1/datasources", cluster), null, cluster, null, true);
        try {
            return (List)this.objectMapper.readValue(data, (TypeReference)new TypeReference<List<String>>(){});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Long getColdStorageUsage(Supplier<Collection<String>> hosts, String clusterId) {
        return this.runSQLQuery(hosts, clusterId, "SELECT sum(\"size\") AS storage_size FROM sys.segments WHERE replication_factor=0 AND is_overshadowed=0", (List<Map<String, Object>> result) -> CollectionUtils.isEmpty((Collection)result) ? 0L : ((Number)((Map)result.get(0)).get("storage_size")).longValue());
    }

    public boolean isCoordinatorStatusOK(String host, String clusterId) {
        Cluster cluster = this.clusterDataManager.getOrNull(clusterId);
        return this.isServerStatusOK(host, this.isUseTls(cluster) ? 8281 : 8081, this.isUseTls(cluster) ? SCHEME_HTTPS : SCHEME_HTTP, cluster);
    }

    public boolean isOverlordStatusOK(String host, String clusterId) {
        Cluster cluster = this.clusterDataManager.getOrNull(clusterId);
        return this.isServerStatusOK(host, this.isUseTls(cluster) ? 8290 : 8090, this.isUseTls(cluster) ? SCHEME_HTTPS : SCHEME_HTTP, cluster);
    }

    public boolean isBrokerStatusOK(String host, String clusterId) {
        Cluster cluster = this.clusterDataManager.getOrNull(clusterId);
        return this.isServerStatusOK(host, this.isUseTls(cluster) ? 8282 : 8082, this.isUseTls(cluster) ? SCHEME_HTTPS : SCHEME_HTTP, cluster);
    }

    public boolean isRouterStatusOK(String host, String clusterId) {
        Cluster cluster = this.clusterDataManager.getOrNull(clusterId);
        return this.isServerStatusOK(host, this.isUseTls(cluster) ? 9088 : 8888, this.isUseTls(cluster) ? SCHEME_HTTPS : SCHEME_HTTP, cluster);
    }

    public boolean isMiddleManagerStatusOK(String host, String clusterId) {
        Cluster cluster = this.clusterDataManager.getOrNull(clusterId);
        return this.isServerStatusOK(host, this.isUseTls(cluster) ? 8291 : 8091, this.isUseTls(cluster) ? SCHEME_HTTPS : SCHEME_HTTP, cluster);
    }

    public boolean isHistoricalStatusOK(String host, String clusterId) {
        Cluster cluster = this.clusterDataManager.getOrNull(clusterId);
        return this.isServerStatusOK(host, this.isUseTls(cluster) ? 8283 : 8083, this.isUseTls(cluster) ? SCHEME_HTTPS : SCHEME_HTTP, cluster);
    }

    private boolean isServerStatusOK(String host, int port, String scheme, Cluster cluster) {
        try {
            this.get(host, port, scheme, "/status", null, cluster, null, true);
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    public boolean isPivotHealthOK(String host, String clusterId) {
        return this.isPivotHealthOK(host, clusterId, null);
    }

    public boolean isPivotHealthOK(String host, String clusterId, Integer clusterVersion) {
        Cluster cluster = clusterVersion == null ? this.clusterDataManager.getOrNull(clusterId) : this.clusterDataManager.getVersionOrNull(clusterId, clusterVersion);
        try {
            this.get(host, 9095, this.isUseTls(cluster) ? SCHEME_HTTPS : SCHEME_HTTP, this.getPivotHealthEndpoint(cluster), null, cluster, null, true);
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    private <T> T runSQLQuery(Collection<String> hosts, String clusterId, String query, Function<List<Map<String, Object>>, T> mapper) {
        return this.runSQLQuery(() -> hosts, clusterId, query, mapper);
    }

    private <T> T runSQLQuery(Supplier<Collection<String>> hosts, String clusterId, String query, Function<List<Map<String, Object>>, T> mapper) {
        Cluster cluster = this.clusterDataManager.getOrNull(clusterId);
        ImmutableMap q = ImmutableMap.of((Object)"query", (Object)query);
        try {
            String data = this.post(this.getRouterTarget(hosts, "/druid/v2/sql", cluster), this.objectMapper.writeValueAsString((Object)q), null, cluster, null, true);
            List result = (List)this.objectMapper.readValue(data, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
            return mapper.apply(result);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected RequestTarget getRouterTarget(Collection<String> hosts, String path, Cluster cluster) {
        return this.getRouterTarget(() -> hosts, path, cluster);
    }

    protected RequestTarget getRouterTarget(Supplier<Collection<String>> hosts, String path, Cluster cluster) {
        return RequestTarget.builder().hosts(hosts == null ? Collections.emptyList() : CollectionUtils.emptyIfNull(hosts.get())).port(this.isUseTls(cluster) ? 9088 : 8888).scheme(this.isUseTls(cluster) ? SCHEME_HTTPS : SCHEME_HTTP).path(path).build();
    }

    protected RequestTarget getOverlordTarget(Collection<String> hosts, String path, Cluster cluster) {
        return RequestTarget.builder().hosts(CollectionUtils.emptyIfNull(hosts)).port(this.isUseTls(cluster) ? 8290 : 8090).scheme(this.isUseTls(cluster) ? SCHEME_HTTPS : SCHEME_HTTP).path(path).build();
    }

    protected RequestTarget getCoordinatorTarget(Collection<String> hosts, String path, Cluster cluster) {
        return RequestTarget.builder().hosts(CollectionUtils.emptyIfNull(hosts)).port(this.isUseTls(cluster) ? 8281 : 8081).scheme(this.isUseTls(cluster) ? SCHEME_HTTPS : SCHEME_HTTP).path(path).build();
    }

    protected RequestTarget getMiddleManagerTarget(Collection<String> hosts, String path, Cluster cluster) {
        return RequestTarget.builder().hosts(CollectionUtils.emptyIfNull(hosts)).port(this.isUseTls(cluster) ? 8291 : 8091).scheme(this.isUseTls(cluster) ? SCHEME_HTTPS : SCHEME_HTTP).path(path).build();
    }

    private String get(RequestTarget target, String query, Cluster cluster, Map<String, String> headers, boolean tryQuietly) {
        return this.get(target.getHosts(), target.getPort(), target.getScheme(), target.getPath(), query, cluster, headers, tryQuietly, false);
    }

    private String get(String host, int port, String scheme, String path, String query, Cluster cluster, Map<String, String> headers, boolean tryQuietly) {
        return this.get((Collection<String>)ImmutableSet.of((Object)host), port, scheme, path, query, cluster, headers, tryQuietly, false);
    }

    private String get(RequestTarget target, String query, Cluster cluster, Map<String, String> headers, boolean tryQuietly, boolean allowEmptyResponse) {
        return this.get(target.getHosts(), target.getPort(), target.getScheme(), target.getPath(), query, cluster, headers, tryQuietly, allowEmptyResponse);
    }

    private String get(Collection<String> hosts, int port, String scheme, String path, String query, Cluster cluster, Map<String, String> headers, boolean tryQuietly, boolean allowEmptyResponse) {
        return this.request(hosts, port, scheme, path, HttpMethod.GET, null, query, cluster, headers, tryQuietly, allowEmptyResponse);
    }

    private String post(RequestTarget target, String content, String query, Cluster cluster, Map<String, String> headers, boolean tryQuietly) {
        return this.post(target.getHosts(), target.getPort(), target.getScheme(), target.getPath(), content, query, cluster, headers, tryQuietly, false);
    }

    private String post(Collection<String> hosts, int port, String scheme, String path, String content, String query, Cluster cluster, Map<String, String> headers, boolean tryQuietly, boolean allowEmptyResponse) {
        return this.request(hosts, port, scheme, path, HttpMethod.POST, content, query, cluster, headers, tryQuietly, allowEmptyResponse);
    }

    private String request(Collection<String> hosts, int port, String scheme, String path, HttpMethod method, String content, String query, Cluster cluster, Map<String, String> headers, boolean tryQuietly, boolean allowEmptyResponse) {
        Preconditions.checkArgument((hosts != null && !hosts.isEmpty() ? 1 : 0) != 0, (Object)"hosts cannot be empty");
        Exception lastException = null;
        for (String host : hosts) {
            URI uri = null;
            try {
                ContentResponse response;
                Authentication.Result druidAuth;
                uri = new URI(scheme, null, host, port, path, query, null);
                Request request = this.httpClientProvider.get().newRequest(uri).method(method).timeout((long)this.applicationConfig.getDruidApiClientTimeout().toStandardSeconds().getSeconds(), TimeUnit.SECONDS);
                if (content != null) {
                    request.content((ContentProvider)new StringContentProvider(MimeTypes.Type.APPLICATION_JSON.asString(), content, StandardCharsets.UTF_8));
                }
                request.header(HttpHeader.ACCEPT, MimeTypes.Type.APPLICATION_JSON.asString());
                if (headers != null) {
                    headers.forEach((arg_0, arg_1) -> ((Request)request).header(arg_0, arg_1));
                }
                if ((druidAuth = this.druidAuthManager.getAuthentication(cluster)) != null) {
                    druidAuth.apply(request);
                }
                if ((response = request.send()).getStatus() / 100 != 2) {
                    throw new ISE("Status code [%d] calling %s %s", response.getStatus(), method, uri);
                }
                String data = response.getContentAsString();
                if (!allowEmptyResponse && HttpMethod.GET.equals((Object)method) && (data == null || data.isEmpty())) {
                    throw new ISE("Empty GET response from [%s]", uri);
                }
                return data;
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug(e, "Bad response while calling [%s %s]", method, uri);
                } else if (!tryQuietly) {
                    log.info("Bad response while calling [%s %s]: %s -> %s", method, uri, e.getClass().getName(), e.getMessage());
                }
                lastException = e;
            }
        }
        throw new ISE(lastException, "No host returned a success response", new Object[0]);
    }

    private boolean isUseTls(Cluster cluster) {
        if (cluster != null && cluster.isUseTls() != null) {
            return cluster.isUseTls();
        }
        return this.applicationConfig.isAWS();
    }

    private String getPivotHealthEndpoint(Cluster cluster) {
        if (cluster != null) {
            Object pivotConfig = ImmutableMap.of();
            try {
                if (cluster.getCustomDruidProperties() != null && StringUtils.isNotBlank((CharSequence)cluster.getCustomDruidProperties().get(ServiceType.PIVOT.getCustomDruidPropertiesKey()))) {
                    pivotConfig = (Map)YAML_MAPPER.readValue(cluster.getCustomDruidProperties().get(ServiceType.PIVOT.getCustomDruidPropertiesKey()), (TypeReference)new TypeReference<Map<String, Object>>(){});
                } else if (cluster.getPivot() != null) {
                    pivotConfig = cluster.getPivot().getConfig();
                }
            }
            catch (Exception e) {
                log.warn(e, "Failed to process pivot config");
            }
            if (StringUtils.isNotBlank((CharSequence)((String)pivotConfig.get("serverRoot")))) {
                String serverRoot = StringUtils.strip((String)((String)pivotConfig.get("serverRoot")), (String)"/");
                return "/" + serverRoot + "/health";
            }
        }
        return "/health";
    }

    public static class RequestTarget {
        private final Collection<String> hosts;
        private final int port;
        private final String scheme;
        private final String path;

        @Generated
        RequestTarget(Collection<String> hosts, int port, String scheme, String path) {
            this.hosts = hosts;
            this.port = port;
            this.scheme = scheme;
            this.path = path;
        }

        @Generated
        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Collection<String> getHosts() {
            return this.hosts;
        }

        @Generated
        public int getPort() {
            return this.port;
        }

        @Generated
        public String getScheme() {
            return this.scheme;
        }

        @Generated
        public String getPath() {
            return this.path;
        }

        @Generated
        public static class Builder {
            @Generated
            private Collection<String> hosts;
            @Generated
            private int port;
            @Generated
            private String scheme;
            @Generated
            private String path;

            @Generated
            Builder() {
            }

            @Generated
            public Builder hosts(Collection<String> hosts) {
                this.hosts = hosts;
                return this;
            }

            @Generated
            public Builder port(int port) {
                this.port = port;
                return this;
            }

            @Generated
            public Builder scheme(String scheme) {
                this.scheme = scheme;
                return this;
            }

            @Generated
            public Builder path(String path) {
                this.path = path;
                return this;
            }

            @Generated
            public RequestTarget build() {
                return new RequestTarget(this.hosts, this.port, this.scheme, this.path);
            }

            @Generated
            public String toString() {
                return "DruidApiClient.RequestTarget.Builder(hosts=" + String.valueOf(this.hosts) + ", port=" + this.port + ", scheme=" + this.scheme + ", path=" + this.path + ")";
            }
        }
    }
}

