/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.configurator.authenticator;

import com.google.common.base.Preconditions;
import io.imply.cloud.configurator.authenticator.AuthConfigurator;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.security.Authentication;
import io.imply.cloud.security.ImplyAuthentication;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class ImplyAuthConfigurator
implements AuthConfigurator {
    @Override
    public String getAuthenticatorType() {
        return "imply";
    }

    @Override
    public String getAuthorizerType() {
        return "imply";
    }

    @Override
    public Properties getAuthenticatorProperties(Cluster cluster) {
        Preconditions.checkArgument((boolean)this.isEnabled(cluster));
        Properties props = new Properties();
        props.setProperty(String.format("druid.auth.authenticator.%s.type", this.getAuthenticatorType()), this.getAuthenticatorType());
        props.setProperty(String.format("druid.auth.authenticator.%s.authorizerName", this.getAuthenticatorType()), this.getAuthorizerType());
        props.setProperty(String.format("druid.auth.authorizer.%s.type", this.getAuthorizerType()), this.getAuthorizerType());
        props.setProperty("druid.auth.authenticator.imply.secret", cluster.getSecurityConfiguration().getHmacSecret());
        return props;
    }

    @Override
    public Optional<Properties> getEscalatorProperties(Cluster cluster) {
        Preconditions.checkArgument((boolean)this.isEnabled(cluster));
        Properties props = new Properties();
        props.setProperty("druid.escalator.type", this.getAuthenticatorType());
        props.setProperty("druid.escalator.authorizerName", this.getAuthorizerType());
        props.setProperty("druid.escalator.secret", cluster.getSecurityConfiguration().getHmacSecret());
        return Optional.of(props);
    }

    @Override
    public String getExtension(Cluster cluster) {
        Preconditions.checkArgument((boolean)this.isEnabled(cluster));
        return "imply-druid-security";
    }

    @Override
    public Optional<Authentication> getAuthentication(Cluster cluster) {
        Preconditions.checkArgument((boolean)this.isEnabled(cluster));
        return Optional.of(new ImplyAuthentication(cluster.getSecurityConfiguration().getHmacSecret()));
    }

    @Override
    public boolean isEnabled(Cluster cluster) {
        return cluster != null && cluster.getSecurityConfiguration() != null && StringUtils.isNotBlank((CharSequence)cluster.getSecurityConfiguration().getHmacSecret());
    }
}

