/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.configurator;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.multibindings.Multibinder;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.configurator.authenticator.AuthConfigurator;
import io.imply.cloud.configurator.authenticator.ClusterAuthConfigurator;
import io.imply.cloud.configurator.authenticator.NoopAuthConfigurator;
import io.imply.cloud.guice.annotations.LazySingleton;

public class ClusterAuthConfiguratorModule
extends AbstractModule {
    private Multibinder<AuthConfigurator> authConfigMultibinder;
    @Inject
    private ApplicationConfig applicationConfig;

    public void configure() {
        this.authConfigMultibinder = Multibinder.newSetBinder((Binder)this.binder(), AuthConfigurator.class);
        this.configureAuthenticators();
        this.binder().bind(ClusterAuthConfigurator.class).in(LazySingleton.class);
    }

    public void configureAuthenticators() {
        if (this.applicationConfig.getServiceName() == null) {
            this.bindAuthenticator().to(NoopAuthConfigurator.class);
        }
    }

    public final LinkedBindingBuilder<AuthConfigurator> bindAuthenticator() {
        return this.authConfigMultibinder.addBinding();
    }
}

