/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.configurator;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.inject.Inject;
import io.imply.cloud.Constants;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ConfigRequestBody;
import io.imply.cloud.model.SecurityConfiguration;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.persistence.EntityStateDataManager;
import io.imply.cloud.tls.CertAndKeyHolder;
import io.imply.cloud.tls.TLSUtils;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.Logger;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class CertificateCache {
    private static final Logger log = new Logger(CertificateCache.class);
    private final ClusterDataManager clusterDataManager;
    private final EntityStateDataManager entityStateDataManager;
    private final ApplicationConfig applicationConfig;
    private final LoadingCache<ConfigRequestBody, CertAndKeyHolder> cache;

    @Inject
    public CertificateCache(ClusterDataManager clusterDataManager, EntityStateDataManager entityStateDataManager, ApplicationConfig applicationConfig) {
        this.clusterDataManager = clusterDataManager;
        this.entityStateDataManager = entityStateDataManager;
        this.applicationConfig = applicationConfig;
        this.cache = CacheBuilder.newBuilder().maximumSize(500L).expireAfterWrite(15L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<ConfigRequestBody, CertAndKeyHolder>(){

            public CertAndKeyHolder load(ConfigRequestBody configRequestBody) throws Exception {
                return CertificateCache.this.generateServerCertificateAndKeys(configRequestBody);
            }
        });
    }

    public CertAndKeyHolder getServerCertificateAndKeys(ConfigRequestBody body) {
        try {
            return (CertAndKeyHolder)this.cache.get((Object)body);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            log.warn(e, "Exception fetching/generating server keys and certificate for cluster [%s] instance [%s]", body.getClusterId(), body.getInstanceId());
            return null;
        }
    }

    private CertAndKeyHolder generateServerCertificateAndKeys(ConfigRequestBody body) throws Exception {
        Cluster cluster = this.clusterDataManager.getVersionForConfig(body, this.entityStateDataManager);
        if (cluster == null || cluster.getSecurityConfiguration() == null) {
            throw new ISE("Security configuration not found for cluster [%s]", body.getClusterId());
        }
        SecurityConfiguration securityConfiguration = cluster.getSecurityConfiguration();
        if (securityConfiguration.getIntermediatePrivateKey() == null || securityConfiguration.getIntermediateCertificate() == null || securityConfiguration.getKeyStorePassword() == null) {
            throw new ISE("Intermediate private key and certificate or key store password not found for cluster [%s]", body.getClusterId());
        }
        ArrayList<String> allIpAddresses = new ArrayList<String>();
        if (body.getPrivateIpAddresses() != null) {
            allIpAddresses.addAll(body.getPrivateIpAddresses());
        }
        if (body.getPublicIpAddresses() != null) {
            allIpAddresses.addAll(body.getPublicIpAddresses());
        }
        ArrayList<String> allHostnames = new ArrayList<String>();
        if (body.getPrivateHostnames() != null) {
            allHostnames.addAll(body.getPrivateHostnames());
        }
        if (body.getPublicHostnames() != null) {
            allHostnames.addAll(body.getPublicHostnames());
        }
        if (this.applicationConfig.isUseLocalhostForHostList()) {
            allHostnames.add("localhost");
        }
        return TLSUtils.generateServerKeysAndCert(Constants.BASE_SUBJECT_INFO.withCommonName(body.getMyPrivateHostname()), allIpAddresses.stream().filter(Constants.INTERPOLATION_VARIABLE_PATTERN.asPredicate().negate()).distinct().collect(Collectors.toList()), allHostnames.stream().filter(Constants.INTERPOLATION_VARIABLE_PATTERN.asPredicate().negate()).distinct().collect(Collectors.toList()), securityConfiguration.getIntermediatePrivateKey(), securityConfiguration.getIntermediateCertificate(), 3072, 128);
    }
}

