/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import io.imply.cloud.model.SecurityConfiguration;
import io.imply.cloud.persistence.DefaultPasswordProvider;
import io.imply.cloud.persistence.PasswordProvider;
import io.imply.cloud.util.ToStringBuilder;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.ListUtils;

public class SecurityConfig {
    @JsonProperty
    private String keyStoreFilename = "imply-onprem.jks";
    @JsonProperty
    private PasswordProvider keyStorePassword = DefaultPasswordProvider.fromString("mtY9afF2GIzcbH1JJ8bRYQ");
    @JsonProperty
    private PasswordProvider signingPrivateKeyPassword = DefaultPasswordProvider.fromString("TvfA7f7L4jbJZl8dIaPOfw");
    @JsonProperty
    private String signingKeyStoreAlias = "imply-onprem";
    @JsonProperty
    private List<String> alternateRootCertificates;
    private KeyStore keyStore;
    private byte[] rootCertificate;
    private List<byte[]> intermediateCertificates;
    private byte[] signingPrivateKey;

    public String getSigningKeyStoreAlias() {
        return this.signingKeyStoreAlias;
    }

    @Deprecated
    public List<byte[]> getAlternateRootCertificates() {
        return this.alternateRootCertificates == null ? null : this.alternateRootCertificates.stream().map(Base64.getDecoder()::decode).collect(Collectors.toList());
    }

    public byte[] getRootCertificate() {
        this.maybeInitialize();
        return this.rootCertificate;
    }

    public List<byte[]> getIntermediateCertificates() {
        this.maybeInitialize();
        return this.intermediateCertificates;
    }

    public byte[] getSigningCertificate() {
        this.maybeInitialize();
        return this.intermediateCertificates.isEmpty() ? this.rootCertificate : this.intermediateCertificates.get(0);
    }

    public byte[] getSigningPrivateKey() {
        this.maybeInitialize();
        return this.signingPrivateKey;
    }

    public void validate() {
        Preconditions.checkNotNull((Object)this.keyStoreFilename, (Object)"[security.keyStoreFilename] must be set");
        Preconditions.checkNotNull((Object)this.keyStorePassword, (Object)"[security.keyStorePassword] must be set");
        Preconditions.checkNotNull((Object)this.signingPrivateKeyPassword, (Object)"[security.signingPrivateKeyPassword] must be set");
    }

    public String toString() {
        return new ToStringBuilder(this).append("keyStoreFilename", this.keyStoreFilename).append("keyStorePassword", (Object)"*****************").append("signingPrivateKeyPassword", (Object)"*****************").append("signingKeyStoreAlias", (Object)this.signingKeyStoreAlias).append("alternateRootCertificates", this.alternateRootCertificates).toString();
    }

    public boolean hasSameCertificates(SecurityConfiguration securityConfiguration) {
        if (securityConfiguration == null) {
            return false;
        }
        if (!Arrays.equals(securityConfiguration.getRootCertificate(), this.getRootCertificate())) {
            return false;
        }
        List parentIntermediateCertificates = ListUtils.emptyIfNull(securityConfiguration.getParentIntermediateCertificates());
        List intermediateCertificates = ListUtils.emptyIfNull(this.getIntermediateCertificates());
        if (parentIntermediateCertificates.size() != intermediateCertificates.size()) {
            return false;
        }
        return IntStream.range(0, parentIntermediateCertificates.size()).allMatch(i -> Arrays.equals((byte[])parentIntermediateCertificates.get(i), (byte[])intermediateCertificates.get(i)));
    }

    private void maybeInitialize() {
        if (this.keyStore != null && this.rootCertificate != null && this.intermediateCertificates != null && this.signingPrivateKey != null) {
            return;
        }
        try (InputStream stream = this.getFileStream();){
            this.keyStore = KeyStore.getInstance("JKS");
            this.keyStore.load(stream, this.keyStorePassword.getPassword().toCharArray());
            Key privateKey = this.keyStore.getKey(this.signingKeyStoreAlias, this.signingPrivateKeyPassword.getPassword().toCharArray());
            Preconditions.checkState((privateKey != null ? 1 : 0) != 0, (String)"Private key with alias [%s] not found", (Object)this.signingKeyStoreAlias);
            this.signingPrivateKey = privateKey.getEncoded();
            ArrayList<byte[]> myIntermediateCertificates = new ArrayList<byte[]>();
            Certificate[] certificates = this.keyStore.getCertificateChain(this.signingKeyStoreAlias);
            if (certificates.length >= 1) {
                Arrays.stream(certificates).map(SecurityConfig::getEncoded).forEach(myIntermediateCertificates::add);
                this.rootCertificate = (byte[])myIntermediateCertificates.remove(myIntermediateCertificates.size() - 1);
            }
            Preconditions.checkState((this.rootCertificate != null ? 1 : 0) != 0, (String)"Certificate with alias [%s] not found", (Object)this.signingKeyStoreAlias);
            this.intermediateCertificates = myIntermediateCertificates;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private InputStream getFileStream() throws FileNotFoundException {
        InputStream stream = ClassLoader.getSystemResourceAsStream(this.keyStoreFilename);
        if (stream == null) {
            stream = new FileInputStream(this.keyStoreFilename);
        }
        return stream;
    }

    private static byte[] getEncoded(Certificate certificate) {
        try {
            return certificate.getEncoded();
        }
        catch (CertificateEncodingException cee) {
            throw new RuntimeException(cee);
        }
    }
}

