/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.config;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.imply.cloud.model.ImplyVersion;
import io.imply.cloud.model.UserFile;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class DefaultsConfig {
    public static final Integer COORDINATOR_JVM_HEAP_MB = 128;
    public static final Integer OVERLORD_JVM_HEAP_MB = 128;
    public static final Integer BROKER_JVM_HEAP_MB = 256;
    public static final Integer ROUTER_JVM_HEAP_MB = 64;
    public static final Integer MM_JVM_HEAP_MB = 64;
    public static final Integer HISTORICAL_JVM_HEAP_MB = 256;
    public static final Long PROCESSING_BUFFER_BYTES = 50000000L;
    public static final Integer PROCESSING_THREADS = 1;
    public static final Long SEGMENT_CACHE_SIZE_BYTES = 10000000000L;
    public static final Integer WORKER_CAPACITY = 2;
    public static final Long CACHE_SIZE_BYTES = 50000000L;
    public static final String SEGMENT_CACHE_LOCATIONS = "[{\"path\":\"/mnt/var/druid/segment-cache\",\"maxSize\":10000000000}]";
    @JsonProperty
    private String implyVersion;
    @JsonProperty
    private ImplyVersion implyVersionFull;
    @JsonProperty
    private List<ImplyVersion> customImplyVersions;
    @JsonProperty
    private Map<String, String> userExtensions;
    @JsonProperty
    private List<UserFile> customFiles;
    @JsonProperty
    private String zkHosts;
    @JsonProperty
    private String zkBasePath;
    @JsonProperty
    private String metadataStorageType;
    @JsonProperty
    private String metadataStorageHost;
    @JsonProperty
    private Integer metadataStoragePort;
    @JsonProperty
    private String metadataStorageSchema;
    @JsonProperty
    private String metadataStorageUser;
    @JsonProperty
    private String metadataStoragePassword;
    @JsonProperty
    private String metadataStorageTlsCert;
    @JsonProperty
    private String metadataStorageClientCert;
    @JsonProperty
    private String metadataStorageClientKey;
    @JsonProperty
    private String deepStorageType;
    @JsonProperty
    @JsonAlias(value={"deepStorageBaseLocation"})
    private String deepStoragePath;
    @JsonProperty
    @JsonAlias(value={"deepStorageS3AccessKey"})
    private String deepStorageUser;
    @JsonProperty
    @JsonAlias(value={"deepStorageS3SecretKey"})
    private String deepStoragePassword;
    @JsonProperty
    private Boolean deepStorageUseAzureCredentialsChain;
    @JsonProperty
    private String deepStorageAzureStorageAccount;
    @JsonProperty
    private String commonCustomDruidProperties;
    @JsonProperty
    private String coordinatorCustomDruidProperties;
    @JsonProperty
    private String overlordCustomDruidProperties;
    @JsonProperty
    private String historicalCustomDruidProperties;
    @JsonProperty
    private String historicalTier1CustomDruidProperties;
    @JsonProperty
    private String historicalTier2CustomDruidProperties;
    @JsonProperty
    private String historicalTier3CustomDruidProperties;
    @JsonProperty
    private Map<String, String> additionalDataTierHistoricalRuntimeProperties;
    @JsonProperty
    private String middleManagerCustomDruidProperties;
    @JsonProperty
    private String middleManagerTier1CustomDruidProperties;
    @JsonProperty
    private String middleManagerTier2CustomDruidProperties;
    @JsonProperty
    private String middleManagerTier3CustomDruidProperties;
    @JsonProperty
    private Map<String, String> additionalDataTierMiddleManagerRuntimeProperties;
    @JsonProperty
    private String brokerCustomDruidProperties;
    @JsonProperty
    private String routerCustomDruidProperties;
    @JsonProperty
    private String pivotCustomDruidProperties;
    @JsonProperty
    private Integer coordinatorJvmHeapMb = COORDINATOR_JVM_HEAP_MB;
    @JsonProperty
    private Integer overlordJvmHeapMb = OVERLORD_JVM_HEAP_MB;
    @JsonProperty
    private Integer brokerJvmHeapMb = BROKER_JVM_HEAP_MB;
    @JsonProperty
    private Integer routerJvmHeapMb = ROUTER_JVM_HEAP_MB;
    @JsonProperty
    private Integer middleManagerJvmHeapMb = MM_JVM_HEAP_MB;
    @JsonProperty
    private Integer historicalJvmHeapMb = HISTORICAL_JVM_HEAP_MB;
    @JsonProperty
    private Long processingBufferBytes = PROCESSING_BUFFER_BYTES;
    @JsonProperty
    private Integer processingThreads = PROCESSING_THREADS;
    @JsonProperty
    private Long segmentCacheSizeBytes = SEGMENT_CACHE_SIZE_BYTES;
    @JsonProperty
    private Integer workerCapacity = WORKER_CAPACITY;
    @JsonProperty
    private Long cacheSizeBytes = CACHE_SIZE_BYTES;
    @JsonProperty
    private String segmentCacheLocations = "[{\"path\":\"/mnt/var/druid/segment-cache\",\"maxSize\":10000000000}]";

    @JsonSetter
    void setSegmentCacheLocations(JsonNode node) {
        this.segmentCacheLocations = node.toString();
    }

    @JsonSetter
    void setCustomImplyVersions(List<ImplyVersion> customImplyVersions) {
        this.customImplyVersions = customImplyVersions == null ? ImmutableList.of() : customImplyVersions.stream().map(ImplyVersion::withDefaultsForUnset).collect(Collectors.toList());
    }

    @Generated
    private static Map<String, String> $default$userExtensions() {
        return ImmutableMap.of();
    }

    @Generated
    private static List<UserFile> $default$customFiles() {
        return ImmutableList.of();
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public DefaultsConfig() {
        this.userExtensions = DefaultsConfig.$default$userExtensions();
        this.customFiles = DefaultsConfig.$default$customFiles();
    }

    @Generated
    private DefaultsConfig(String implyVersion, ImplyVersion implyVersionFull, List<ImplyVersion> customImplyVersions, Map<String, String> userExtensions, List<UserFile> customFiles, String zkHosts, String zkBasePath, String metadataStorageType, String metadataStorageHost, Integer metadataStoragePort, String metadataStorageSchema, String metadataStorageUser, String metadataStoragePassword, String metadataStorageTlsCert, String metadataStorageClientCert, String metadataStorageClientKey, String deepStorageType, String deepStoragePath, String deepStorageUser, String deepStoragePassword, Boolean deepStorageUseAzureCredentialsChain, String deepStorageAzureStorageAccount, String commonCustomDruidProperties, String coordinatorCustomDruidProperties, String overlordCustomDruidProperties, String historicalCustomDruidProperties, String historicalTier1CustomDruidProperties, String historicalTier2CustomDruidProperties, String historicalTier3CustomDruidProperties, Map<String, String> additionalDataTierHistoricalRuntimeProperties, String middleManagerCustomDruidProperties, String middleManagerTier1CustomDruidProperties, String middleManagerTier2CustomDruidProperties, String middleManagerTier3CustomDruidProperties, Map<String, String> additionalDataTierMiddleManagerRuntimeProperties, String brokerCustomDruidProperties, String routerCustomDruidProperties, String pivotCustomDruidProperties, Integer coordinatorJvmHeapMb, Integer overlordJvmHeapMb, Integer brokerJvmHeapMb, Integer routerJvmHeapMb, Integer middleManagerJvmHeapMb, Integer historicalJvmHeapMb, Long processingBufferBytes, Integer processingThreads, Long segmentCacheSizeBytes, Integer workerCapacity, Long cacheSizeBytes, String segmentCacheLocations) {
        this.implyVersion = implyVersion;
        this.implyVersionFull = implyVersionFull;
        this.customImplyVersions = customImplyVersions;
        this.userExtensions = userExtensions;
        this.customFiles = customFiles;
        this.zkHosts = zkHosts;
        this.zkBasePath = zkBasePath;
        this.metadataStorageType = metadataStorageType;
        this.metadataStorageHost = metadataStorageHost;
        this.metadataStoragePort = metadataStoragePort;
        this.metadataStorageSchema = metadataStorageSchema;
        this.metadataStorageUser = metadataStorageUser;
        this.metadataStoragePassword = metadataStoragePassword;
        this.metadataStorageTlsCert = metadataStorageTlsCert;
        this.metadataStorageClientCert = metadataStorageClientCert;
        this.metadataStorageClientKey = metadataStorageClientKey;
        this.deepStorageType = deepStorageType;
        this.deepStoragePath = deepStoragePath;
        this.deepStorageUser = deepStorageUser;
        this.deepStoragePassword = deepStoragePassword;
        this.deepStorageUseAzureCredentialsChain = deepStorageUseAzureCredentialsChain;
        this.deepStorageAzureStorageAccount = deepStorageAzureStorageAccount;
        this.commonCustomDruidProperties = commonCustomDruidProperties;
        this.coordinatorCustomDruidProperties = coordinatorCustomDruidProperties;
        this.overlordCustomDruidProperties = overlordCustomDruidProperties;
        this.historicalCustomDruidProperties = historicalCustomDruidProperties;
        this.historicalTier1CustomDruidProperties = historicalTier1CustomDruidProperties;
        this.historicalTier2CustomDruidProperties = historicalTier2CustomDruidProperties;
        this.historicalTier3CustomDruidProperties = historicalTier3CustomDruidProperties;
        this.additionalDataTierHistoricalRuntimeProperties = additionalDataTierHistoricalRuntimeProperties;
        this.middleManagerCustomDruidProperties = middleManagerCustomDruidProperties;
        this.middleManagerTier1CustomDruidProperties = middleManagerTier1CustomDruidProperties;
        this.middleManagerTier2CustomDruidProperties = middleManagerTier2CustomDruidProperties;
        this.middleManagerTier3CustomDruidProperties = middleManagerTier3CustomDruidProperties;
        this.additionalDataTierMiddleManagerRuntimeProperties = additionalDataTierMiddleManagerRuntimeProperties;
        this.brokerCustomDruidProperties = brokerCustomDruidProperties;
        this.routerCustomDruidProperties = routerCustomDruidProperties;
        this.pivotCustomDruidProperties = pivotCustomDruidProperties;
        this.coordinatorJvmHeapMb = coordinatorJvmHeapMb;
        this.overlordJvmHeapMb = overlordJvmHeapMb;
        this.brokerJvmHeapMb = brokerJvmHeapMb;
        this.routerJvmHeapMb = routerJvmHeapMb;
        this.middleManagerJvmHeapMb = middleManagerJvmHeapMb;
        this.historicalJvmHeapMb = historicalJvmHeapMb;
        this.processingBufferBytes = processingBufferBytes;
        this.processingThreads = processingThreads;
        this.segmentCacheSizeBytes = segmentCacheSizeBytes;
        this.workerCapacity = workerCapacity;
        this.cacheSizeBytes = cacheSizeBytes;
        this.segmentCacheLocations = segmentCacheLocations;
    }

    @Generated
    public String getImplyVersion() {
        return this.implyVersion;
    }

    @Generated
    public ImplyVersion getImplyVersionFull() {
        return this.implyVersionFull;
    }

    @Generated
    public List<ImplyVersion> getCustomImplyVersions() {
        return this.customImplyVersions;
    }

    @Generated
    public Map<String, String> getUserExtensions() {
        return this.userExtensions;
    }

    @Generated
    public List<UserFile> getCustomFiles() {
        return this.customFiles;
    }

    @Generated
    public String getZkHosts() {
        return this.zkHosts;
    }

    @Generated
    public String getZkBasePath() {
        return this.zkBasePath;
    }

    @Generated
    public String getMetadataStorageType() {
        return this.metadataStorageType;
    }

    @Generated
    public String getMetadataStorageHost() {
        return this.metadataStorageHost;
    }

    @Generated
    public Integer getMetadataStoragePort() {
        return this.metadataStoragePort;
    }

    @Generated
    public String getMetadataStorageSchema() {
        return this.metadataStorageSchema;
    }

    @Generated
    public String getMetadataStorageUser() {
        return this.metadataStorageUser;
    }

    @Generated
    public String getMetadataStoragePassword() {
        return this.metadataStoragePassword;
    }

    @Generated
    public String getMetadataStorageTlsCert() {
        return this.metadataStorageTlsCert;
    }

    @Generated
    public String getMetadataStorageClientCert() {
        return this.metadataStorageClientCert;
    }

    @Generated
    public String getMetadataStorageClientKey() {
        return this.metadataStorageClientKey;
    }

    @Generated
    public String getDeepStorageType() {
        return this.deepStorageType;
    }

    @Generated
    public String getDeepStoragePath() {
        return this.deepStoragePath;
    }

    @Generated
    public String getDeepStorageUser() {
        return this.deepStorageUser;
    }

    @Generated
    public String getDeepStoragePassword() {
        return this.deepStoragePassword;
    }

    @Generated
    public Boolean getDeepStorageUseAzureCredentialsChain() {
        return this.deepStorageUseAzureCredentialsChain;
    }

    @Generated
    public String getDeepStorageAzureStorageAccount() {
        return this.deepStorageAzureStorageAccount;
    }

    @Generated
    public String getCommonCustomDruidProperties() {
        return this.commonCustomDruidProperties;
    }

    @Generated
    public String getCoordinatorCustomDruidProperties() {
        return this.coordinatorCustomDruidProperties;
    }

    @Generated
    public String getOverlordCustomDruidProperties() {
        return this.overlordCustomDruidProperties;
    }

    @Generated
    public String getHistoricalCustomDruidProperties() {
        return this.historicalCustomDruidProperties;
    }

    @Generated
    public String getHistoricalTier1CustomDruidProperties() {
        return this.historicalTier1CustomDruidProperties;
    }

    @Generated
    public String getHistoricalTier2CustomDruidProperties() {
        return this.historicalTier2CustomDruidProperties;
    }

    @Generated
    public String getHistoricalTier3CustomDruidProperties() {
        return this.historicalTier3CustomDruidProperties;
    }

    @Generated
    public Map<String, String> getAdditionalDataTierHistoricalRuntimeProperties() {
        return this.additionalDataTierHistoricalRuntimeProperties;
    }

    @Generated
    public String getMiddleManagerCustomDruidProperties() {
        return this.middleManagerCustomDruidProperties;
    }

    @Generated
    public String getMiddleManagerTier1CustomDruidProperties() {
        return this.middleManagerTier1CustomDruidProperties;
    }

    @Generated
    public String getMiddleManagerTier2CustomDruidProperties() {
        return this.middleManagerTier2CustomDruidProperties;
    }

    @Generated
    public String getMiddleManagerTier3CustomDruidProperties() {
        return this.middleManagerTier3CustomDruidProperties;
    }

    @Generated
    public Map<String, String> getAdditionalDataTierMiddleManagerRuntimeProperties() {
        return this.additionalDataTierMiddleManagerRuntimeProperties;
    }

    @Generated
    public String getBrokerCustomDruidProperties() {
        return this.brokerCustomDruidProperties;
    }

    @Generated
    public String getRouterCustomDruidProperties() {
        return this.routerCustomDruidProperties;
    }

    @Generated
    public String getPivotCustomDruidProperties() {
        return this.pivotCustomDruidProperties;
    }

    @Generated
    public Integer getCoordinatorJvmHeapMb() {
        return this.coordinatorJvmHeapMb;
    }

    @Generated
    public Integer getOverlordJvmHeapMb() {
        return this.overlordJvmHeapMb;
    }

    @Generated
    public Integer getBrokerJvmHeapMb() {
        return this.brokerJvmHeapMb;
    }

    @Generated
    public Integer getRouterJvmHeapMb() {
        return this.routerJvmHeapMb;
    }

    @Generated
    public Integer getMiddleManagerJvmHeapMb() {
        return this.middleManagerJvmHeapMb;
    }

    @Generated
    public Integer getHistoricalJvmHeapMb() {
        return this.historicalJvmHeapMb;
    }

    @Generated
    public Long getProcessingBufferBytes() {
        return this.processingBufferBytes;
    }

    @Generated
    public Integer getProcessingThreads() {
        return this.processingThreads;
    }

    @Generated
    public Long getSegmentCacheSizeBytes() {
        return this.segmentCacheSizeBytes;
    }

    @Generated
    public Integer getWorkerCapacity() {
        return this.workerCapacity;
    }

    @Generated
    public Long getCacheSizeBytes() {
        return this.cacheSizeBytes;
    }

    @Generated
    public String getSegmentCacheLocations() {
        return this.segmentCacheLocations;
    }

    @Generated
    public static class Builder {
        @Generated
        private String implyVersion;
        @Generated
        private ImplyVersion implyVersionFull;
        @Generated
        private List<ImplyVersion> customImplyVersions;
        @Generated
        private boolean userExtensions$set;
        @Generated
        private Map<String, String> userExtensions$value;
        @Generated
        private boolean customFiles$set;
        @Generated
        private List<UserFile> customFiles$value;
        @Generated
        private String zkHosts;
        @Generated
        private String zkBasePath;
        @Generated
        private String metadataStorageType;
        @Generated
        private String metadataStorageHost;
        @Generated
        private Integer metadataStoragePort;
        @Generated
        private String metadataStorageSchema;
        @Generated
        private String metadataStorageUser;
        @Generated
        private String metadataStoragePassword;
        @Generated
        private String metadataStorageTlsCert;
        @Generated
        private String metadataStorageClientCert;
        @Generated
        private String metadataStorageClientKey;
        @Generated
        private String deepStorageType;
        @Generated
        private String deepStoragePath;
        @Generated
        private String deepStorageUser;
        @Generated
        private String deepStoragePassword;
        @Generated
        private Boolean deepStorageUseAzureCredentialsChain;
        @Generated
        private String deepStorageAzureStorageAccount;
        @Generated
        private String commonCustomDruidProperties;
        @Generated
        private String coordinatorCustomDruidProperties;
        @Generated
        private String overlordCustomDruidProperties;
        @Generated
        private String historicalCustomDruidProperties;
        @Generated
        private String historicalTier1CustomDruidProperties;
        @Generated
        private String historicalTier2CustomDruidProperties;
        @Generated
        private String historicalTier3CustomDruidProperties;
        @Generated
        private Map<String, String> additionalDataTierHistoricalRuntimeProperties;
        @Generated
        private String middleManagerCustomDruidProperties;
        @Generated
        private String middleManagerTier1CustomDruidProperties;
        @Generated
        private String middleManagerTier2CustomDruidProperties;
        @Generated
        private String middleManagerTier3CustomDruidProperties;
        @Generated
        private Map<String, String> additionalDataTierMiddleManagerRuntimeProperties;
        @Generated
        private String brokerCustomDruidProperties;
        @Generated
        private String routerCustomDruidProperties;
        @Generated
        private String pivotCustomDruidProperties;
        @Generated
        private Integer coordinatorJvmHeapMb;
        @Generated
        private Integer overlordJvmHeapMb;
        @Generated
        private Integer brokerJvmHeapMb;
        @Generated
        private Integer routerJvmHeapMb;
        @Generated
        private Integer middleManagerJvmHeapMb;
        @Generated
        private Integer historicalJvmHeapMb;
        @Generated
        private Long processingBufferBytes;
        @Generated
        private Integer processingThreads;
        @Generated
        private Long segmentCacheSizeBytes;
        @Generated
        private Integer workerCapacity;
        @Generated
        private Long cacheSizeBytes;
        @Generated
        private String segmentCacheLocations;

        @Generated
        Builder() {
        }

        @JsonProperty
        @Generated
        public Builder implyVersion(String implyVersion) {
            this.implyVersion = implyVersion;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder implyVersionFull(ImplyVersion implyVersionFull) {
            this.implyVersionFull = implyVersionFull;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder customImplyVersions(List<ImplyVersion> customImplyVersions) {
            this.customImplyVersions = customImplyVersions;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder userExtensions(Map<String, String> userExtensions) {
            this.userExtensions$value = userExtensions;
            this.userExtensions$set = true;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder customFiles(List<UserFile> customFiles) {
            this.customFiles$value = customFiles;
            this.customFiles$set = true;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder zkHosts(String zkHosts) {
            this.zkHosts = zkHosts;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder zkBasePath(String zkBasePath) {
            this.zkBasePath = zkBasePath;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder metadataStorageType(String metadataStorageType) {
            this.metadataStorageType = metadataStorageType;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder metadataStorageHost(String metadataStorageHost) {
            this.metadataStorageHost = metadataStorageHost;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder metadataStoragePort(Integer metadataStoragePort) {
            this.metadataStoragePort = metadataStoragePort;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder metadataStorageSchema(String metadataStorageSchema) {
            this.metadataStorageSchema = metadataStorageSchema;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder metadataStorageUser(String metadataStorageUser) {
            this.metadataStorageUser = metadataStorageUser;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder metadataStoragePassword(String metadataStoragePassword) {
            this.metadataStoragePassword = metadataStoragePassword;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder metadataStorageTlsCert(String metadataStorageTlsCert) {
            this.metadataStorageTlsCert = metadataStorageTlsCert;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder metadataStorageClientCert(String metadataStorageClientCert) {
            this.metadataStorageClientCert = metadataStorageClientCert;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder metadataStorageClientKey(String metadataStorageClientKey) {
            this.metadataStorageClientKey = metadataStorageClientKey;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder deepStorageType(String deepStorageType) {
            this.deepStorageType = deepStorageType;
            return this;
        }

        @JsonProperty
        @JsonAlias(value={"deepStorageBaseLocation"})
        @Generated
        public Builder deepStoragePath(String deepStoragePath) {
            this.deepStoragePath = deepStoragePath;
            return this;
        }

        @JsonProperty
        @JsonAlias(value={"deepStorageS3AccessKey"})
        @Generated
        public Builder deepStorageUser(String deepStorageUser) {
            this.deepStorageUser = deepStorageUser;
            return this;
        }

        @JsonProperty
        @JsonAlias(value={"deepStorageS3SecretKey"})
        @Generated
        public Builder deepStoragePassword(String deepStoragePassword) {
            this.deepStoragePassword = deepStoragePassword;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder deepStorageUseAzureCredentialsChain(Boolean deepStorageUseAzureCredentialsChain) {
            this.deepStorageUseAzureCredentialsChain = deepStorageUseAzureCredentialsChain;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder deepStorageAzureStorageAccount(String deepStorageAzureStorageAccount) {
            this.deepStorageAzureStorageAccount = deepStorageAzureStorageAccount;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder commonCustomDruidProperties(String commonCustomDruidProperties) {
            this.commonCustomDruidProperties = commonCustomDruidProperties;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder coordinatorCustomDruidProperties(String coordinatorCustomDruidProperties) {
            this.coordinatorCustomDruidProperties = coordinatorCustomDruidProperties;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder overlordCustomDruidProperties(String overlordCustomDruidProperties) {
            this.overlordCustomDruidProperties = overlordCustomDruidProperties;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder historicalCustomDruidProperties(String historicalCustomDruidProperties) {
            this.historicalCustomDruidProperties = historicalCustomDruidProperties;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder historicalTier1CustomDruidProperties(String historicalTier1CustomDruidProperties) {
            this.historicalTier1CustomDruidProperties = historicalTier1CustomDruidProperties;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder historicalTier2CustomDruidProperties(String historicalTier2CustomDruidProperties) {
            this.historicalTier2CustomDruidProperties = historicalTier2CustomDruidProperties;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder historicalTier3CustomDruidProperties(String historicalTier3CustomDruidProperties) {
            this.historicalTier3CustomDruidProperties = historicalTier3CustomDruidProperties;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder additionalDataTierHistoricalRuntimeProperties(Map<String, String> additionalDataTierHistoricalRuntimeProperties) {
            this.additionalDataTierHistoricalRuntimeProperties = additionalDataTierHistoricalRuntimeProperties;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder middleManagerCustomDruidProperties(String middleManagerCustomDruidProperties) {
            this.middleManagerCustomDruidProperties = middleManagerCustomDruidProperties;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder middleManagerTier1CustomDruidProperties(String middleManagerTier1CustomDruidProperties) {
            this.middleManagerTier1CustomDruidProperties = middleManagerTier1CustomDruidProperties;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder middleManagerTier2CustomDruidProperties(String middleManagerTier2CustomDruidProperties) {
            this.middleManagerTier2CustomDruidProperties = middleManagerTier2CustomDruidProperties;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder middleManagerTier3CustomDruidProperties(String middleManagerTier3CustomDruidProperties) {
            this.middleManagerTier3CustomDruidProperties = middleManagerTier3CustomDruidProperties;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder additionalDataTierMiddleManagerRuntimeProperties(Map<String, String> additionalDataTierMiddleManagerRuntimeProperties) {
            this.additionalDataTierMiddleManagerRuntimeProperties = additionalDataTierMiddleManagerRuntimeProperties;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder brokerCustomDruidProperties(String brokerCustomDruidProperties) {
            this.brokerCustomDruidProperties = brokerCustomDruidProperties;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder routerCustomDruidProperties(String routerCustomDruidProperties) {
            this.routerCustomDruidProperties = routerCustomDruidProperties;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder pivotCustomDruidProperties(String pivotCustomDruidProperties) {
            this.pivotCustomDruidProperties = pivotCustomDruidProperties;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder coordinatorJvmHeapMb(Integer coordinatorJvmHeapMb) {
            this.coordinatorJvmHeapMb = coordinatorJvmHeapMb;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder overlordJvmHeapMb(Integer overlordJvmHeapMb) {
            this.overlordJvmHeapMb = overlordJvmHeapMb;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder brokerJvmHeapMb(Integer brokerJvmHeapMb) {
            this.brokerJvmHeapMb = brokerJvmHeapMb;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder routerJvmHeapMb(Integer routerJvmHeapMb) {
            this.routerJvmHeapMb = routerJvmHeapMb;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder middleManagerJvmHeapMb(Integer middleManagerJvmHeapMb) {
            this.middleManagerJvmHeapMb = middleManagerJvmHeapMb;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder historicalJvmHeapMb(Integer historicalJvmHeapMb) {
            this.historicalJvmHeapMb = historicalJvmHeapMb;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder processingBufferBytes(Long processingBufferBytes) {
            this.processingBufferBytes = processingBufferBytes;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder processingThreads(Integer processingThreads) {
            this.processingThreads = processingThreads;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder segmentCacheSizeBytes(Long segmentCacheSizeBytes) {
            this.segmentCacheSizeBytes = segmentCacheSizeBytes;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder workerCapacity(Integer workerCapacity) {
            this.workerCapacity = workerCapacity;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder cacheSizeBytes(Long cacheSizeBytes) {
            this.cacheSizeBytes = cacheSizeBytes;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder segmentCacheLocations(String segmentCacheLocations) {
            this.segmentCacheLocations = segmentCacheLocations;
            return this;
        }

        @Generated
        public DefaultsConfig build() {
            Map<String, String> userExtensions$value = this.userExtensions$value;
            if (!this.userExtensions$set) {
                userExtensions$value = DefaultsConfig.$default$userExtensions();
            }
            List<UserFile> customFiles$value = this.customFiles$value;
            if (!this.customFiles$set) {
                customFiles$value = DefaultsConfig.$default$customFiles();
            }
            return new DefaultsConfig(this.implyVersion, this.implyVersionFull, this.customImplyVersions, userExtensions$value, customFiles$value, this.zkHosts, this.zkBasePath, this.metadataStorageType, this.metadataStorageHost, this.metadataStoragePort, this.metadataStorageSchema, this.metadataStorageUser, this.metadataStoragePassword, this.metadataStorageTlsCert, this.metadataStorageClientCert, this.metadataStorageClientKey, this.deepStorageType, this.deepStoragePath, this.deepStorageUser, this.deepStoragePassword, this.deepStorageUseAzureCredentialsChain, this.deepStorageAzureStorageAccount, this.commonCustomDruidProperties, this.coordinatorCustomDruidProperties, this.overlordCustomDruidProperties, this.historicalCustomDruidProperties, this.historicalTier1CustomDruidProperties, this.historicalTier2CustomDruidProperties, this.historicalTier3CustomDruidProperties, this.additionalDataTierHistoricalRuntimeProperties, this.middleManagerCustomDruidProperties, this.middleManagerTier1CustomDruidProperties, this.middleManagerTier2CustomDruidProperties, this.middleManagerTier3CustomDruidProperties, this.additionalDataTierMiddleManagerRuntimeProperties, this.brokerCustomDruidProperties, this.routerCustomDruidProperties, this.pivotCustomDruidProperties, this.coordinatorJvmHeapMb, this.overlordJvmHeapMb, this.brokerJvmHeapMb, this.routerJvmHeapMb, this.middleManagerJvmHeapMb, this.historicalJvmHeapMb, this.processingBufferBytes, this.processingThreads, this.segmentCacheSizeBytes, this.workerCapacity, this.cacheSizeBytes, this.segmentCacheLocations);
        }

        @Generated
        public String toString() {
            return "DefaultsConfig.Builder(implyVersion=" + this.implyVersion + ", implyVersionFull=" + String.valueOf(this.implyVersionFull) + ", customImplyVersions=" + String.valueOf(this.customImplyVersions) + ", userExtensions$value=" + String.valueOf(this.userExtensions$value) + ", customFiles$value=" + String.valueOf(this.customFiles$value) + ", zkHosts=" + this.zkHosts + ", zkBasePath=" + this.zkBasePath + ", metadataStorageType=" + this.metadataStorageType + ", metadataStorageHost=" + this.metadataStorageHost + ", metadataStoragePort=" + this.metadataStoragePort + ", metadataStorageSchema=" + this.metadataStorageSchema + ", metadataStorageUser=" + this.metadataStorageUser + ", metadataStoragePassword=" + this.metadataStoragePassword + ", metadataStorageTlsCert=" + this.metadataStorageTlsCert + ", metadataStorageClientCert=" + this.metadataStorageClientCert + ", metadataStorageClientKey=" + this.metadataStorageClientKey + ", deepStorageType=" + this.deepStorageType + ", deepStoragePath=" + this.deepStoragePath + ", deepStorageUser=" + this.deepStorageUser + ", deepStoragePassword=" + this.deepStoragePassword + ", deepStorageUseAzureCredentialsChain=" + this.deepStorageUseAzureCredentialsChain + ", deepStorageAzureStorageAccount=" + this.deepStorageAzureStorageAccount + ", commonCustomDruidProperties=" + this.commonCustomDruidProperties + ", coordinatorCustomDruidProperties=" + this.coordinatorCustomDruidProperties + ", overlordCustomDruidProperties=" + this.overlordCustomDruidProperties + ", historicalCustomDruidProperties=" + this.historicalCustomDruidProperties + ", historicalTier1CustomDruidProperties=" + this.historicalTier1CustomDruidProperties + ", historicalTier2CustomDruidProperties=" + this.historicalTier2CustomDruidProperties + ", historicalTier3CustomDruidProperties=" + this.historicalTier3CustomDruidProperties + ", additionalDataTierHistoricalRuntimeProperties=" + String.valueOf(this.additionalDataTierHistoricalRuntimeProperties) + ", middleManagerCustomDruidProperties=" + this.middleManagerCustomDruidProperties + ", middleManagerTier1CustomDruidProperties=" + this.middleManagerTier1CustomDruidProperties + ", middleManagerTier2CustomDruidProperties=" + this.middleManagerTier2CustomDruidProperties + ", middleManagerTier3CustomDruidProperties=" + this.middleManagerTier3CustomDruidProperties + ", additionalDataTierMiddleManagerRuntimeProperties=" + String.valueOf(this.additionalDataTierMiddleManagerRuntimeProperties) + ", brokerCustomDruidProperties=" + this.brokerCustomDruidProperties + ", routerCustomDruidProperties=" + this.routerCustomDruidProperties + ", pivotCustomDruidProperties=" + this.pivotCustomDruidProperties + ", coordinatorJvmHeapMb=" + this.coordinatorJvmHeapMb + ", overlordJvmHeapMb=" + this.overlordJvmHeapMb + ", brokerJvmHeapMb=" + this.brokerJvmHeapMb + ", routerJvmHeapMb=" + this.routerJvmHeapMb + ", middleManagerJvmHeapMb=" + this.middleManagerJvmHeapMb + ", historicalJvmHeapMb=" + this.historicalJvmHeapMb + ", processingBufferBytes=" + this.processingBufferBytes + ", processingThreads=" + this.processingThreads + ", segmentCacheSizeBytes=" + this.segmentCacheSizeBytes + ", workerCapacity=" + this.workerCapacity + ", cacheSizeBytes=" + this.cacheSizeBytes + ", segmentCacheLocations=" + this.segmentCacheLocations + ")";
        }
    }
}

