/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.imply.cloud.model.DefaultsUpdateType;
import io.imply.cloud.model.Platform;
import io.imply.cloud.util.ToStringBuilder;
import lombok.Generated;
import org.joda.time.Period;

public class ApplicationConfig {
    public static final String MANAGER_CLASS_NAME = "io.imply.cloud.manager.CliManager";
    public static final String CONFIG_SERVER_CLASS_NAME = "io.imply.cloud.configurator.CliConfigServer";
    @JsonProperty
    private Platform platform = Platform.ONPREM;
    @JsonProperty
    private boolean kubernetesMode = false;
    @JsonProperty
    private String serviceName;
    @JsonProperty
    private Integer numWorkerThreads = 20;
    @JsonProperty(value="dev.mode")
    private boolean developmentMode = false;
    @JsonProperty(value="dev.useMocks")
    private boolean useMocks = false;
    @JsonProperty(value="dev.useLocalhostForHostList")
    private boolean useLocalhostForHostList = false;
    @JsonProperty(value="dev.startingClusterNumber")
    private Integer startingClusterNumber = 0;
    @JsonProperty(value="dev.awaitMiddleManagerIdleDelay")
    private Integer awaitMiddleManagerIdleDelay = 60;
    @JsonProperty(value="dev.awaitTaskStatusDelay")
    private Integer awaitTaskStatusDelay = 60;
    @JsonProperty(value="dev.earlyHandoffDelay")
    private Integer earlyHandoffDelay;
    @JsonProperty
    private boolean skipRewriteUrlForGroveServer = false;
    @JsonProperty
    private boolean disablePersistenceCache = false;
    @JsonProperty
    private boolean useTls = false;
    @JsonProperty
    private boolean useAuthentication = false;
    @JsonProperty(value="grove.username")
    private String groveUsername;
    @JsonProperty(value="grove.password")
    private String grovePassword;
    @JsonProperty
    private DefaultsUpdateType defaultsUpdateType = DefaultsUpdateType.DISABLED;
    @JsonProperty(value="dev.skipPackageValidation")
    private boolean skipPackageValidation = false;
    @JsonProperty
    private Period druidApiClientTimeout;

    public boolean isOnPrem() {
        return Platform.ONPREM.equals((Object)this.platform);
    }

    public boolean isAWS() {
        return Platform.AWS.equals((Object)this.platform);
    }

    public boolean isSaaS() {
        return Platform.SAAS.equals((Object)this.platform);
    }

    public boolean isIOW() {
        return Platform.IOW.equals((Object)this.platform);
    }

    public boolean isGroveBased() {
        return this.isOnPrem() || this.isSaaS();
    }

    public boolean isManager() {
        return MANAGER_CLASS_NAME.equals(this.serviceName);
    }

    public boolean isConfigServer() {
        return CONFIG_SERVER_CLASS_NAME.equals(this.serviceName);
    }

    public boolean useGroveAuthentication() {
        return this.groveUsername != null && this.grovePassword != null;
    }

    public String toString() {
        return new ToStringBuilder(this).append("platform", (Object)this.platform).append("kubernetesMode", this.kubernetesMode).append("serviceName", (Object)this.serviceName).append("numWorkerThreads", (Object)this.numWorkerThreads).append("developmentMode", this.developmentMode).append("useMocks", this.useMocks).append("useLocalhostForHostList", this.useLocalhostForHostList).append("startingClusterNumber", (Object)this.startingClusterNumber).append("skipRewriteUrlForGroveServer", this.skipRewriteUrlForGroveServer).append("disablePersistenceCache", this.disablePersistenceCache).append("useTls", this.useTls).append("useAuthentication", this.useAuthentication).append("groveUsername", (Object)this.groveUsername).append("grovePassword", (Object)"*****************").append("defaultsUpdateType", (Object)this.defaultsUpdateType).toString();
    }

    @Generated
    private static Integer $default$earlyHandoffDelay() {
        return 90;
    }

    @Generated
    private static Period $default$druidApiClientTimeout() {
        return new Period((Object)"PT10S");
    }

    @Generated
    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Builder toBuilder() {
        return new Builder().platform(this.platform).kubernetesMode(this.kubernetesMode).serviceName(this.serviceName).numWorkerThreads(this.numWorkerThreads).developmentMode(this.developmentMode).useMocks(this.useMocks).useLocalhostForHostList(this.useLocalhostForHostList).startingClusterNumber(this.startingClusterNumber).awaitMiddleManagerIdleDelay(this.awaitMiddleManagerIdleDelay).awaitTaskStatusDelay(this.awaitTaskStatusDelay).earlyHandoffDelay(this.earlyHandoffDelay).skipRewriteUrlForGroveServer(this.skipRewriteUrlForGroveServer).disablePersistenceCache(this.disablePersistenceCache).useTls(this.useTls).useAuthentication(this.useAuthentication).groveUsername(this.groveUsername).grovePassword(this.grovePassword).defaultsUpdateType(this.defaultsUpdateType).skipPackageValidation(this.skipPackageValidation).druidApiClientTimeout(this.druidApiClientTimeout);
    }

    @Generated
    public Platform getPlatform() {
        return this.platform;
    }

    @Generated
    public boolean isKubernetesMode() {
        return this.kubernetesMode;
    }

    @Generated
    public String getServiceName() {
        return this.serviceName;
    }

    @Generated
    public Integer getNumWorkerThreads() {
        return this.numWorkerThreads;
    }

    @Generated
    public boolean isDevelopmentMode() {
        return this.developmentMode;
    }

    @Generated
    public boolean isUseMocks() {
        return this.useMocks;
    }

    @Generated
    public boolean isUseLocalhostForHostList() {
        return this.useLocalhostForHostList;
    }

    @Generated
    public Integer getStartingClusterNumber() {
        return this.startingClusterNumber;
    }

    @Generated
    public Integer getAwaitMiddleManagerIdleDelay() {
        return this.awaitMiddleManagerIdleDelay;
    }

    @Generated
    public Integer getAwaitTaskStatusDelay() {
        return this.awaitTaskStatusDelay;
    }

    @Generated
    public Integer getEarlyHandoffDelay() {
        return this.earlyHandoffDelay;
    }

    @Generated
    public boolean isSkipRewriteUrlForGroveServer() {
        return this.skipRewriteUrlForGroveServer;
    }

    @Generated
    public boolean isDisablePersistenceCache() {
        return this.disablePersistenceCache;
    }

    @JsonProperty
    @Generated
    public boolean useTls() {
        return this.useTls;
    }

    @JsonProperty
    @Generated
    public boolean useAuthentication() {
        return this.useAuthentication;
    }

    @Generated
    public String getGroveUsername() {
        return this.groveUsername;
    }

    @Generated
    public String getGrovePassword() {
        return this.grovePassword;
    }

    @Generated
    public DefaultsUpdateType getDefaultsUpdateType() {
        return this.defaultsUpdateType;
    }

    @Generated
    public boolean isSkipPackageValidation() {
        return this.skipPackageValidation;
    }

    @Generated
    public Period getDruidApiClientTimeout() {
        return this.druidApiClientTimeout;
    }

    @Generated
    public ApplicationConfig() {
        this.earlyHandoffDelay = ApplicationConfig.$default$earlyHandoffDelay();
        this.druidApiClientTimeout = ApplicationConfig.$default$druidApiClientTimeout();
    }

    @Generated
    private ApplicationConfig(Platform platform, boolean kubernetesMode, String serviceName, Integer numWorkerThreads, boolean developmentMode, boolean useMocks, boolean useLocalhostForHostList, Integer startingClusterNumber, Integer awaitMiddleManagerIdleDelay, Integer awaitTaskStatusDelay, Integer earlyHandoffDelay, boolean skipRewriteUrlForGroveServer, boolean disablePersistenceCache, boolean useTls, boolean useAuthentication, String groveUsername, String grovePassword, DefaultsUpdateType defaultsUpdateType, boolean skipPackageValidation, Period druidApiClientTimeout) {
        this.platform = platform;
        this.kubernetesMode = kubernetesMode;
        this.serviceName = serviceName;
        this.numWorkerThreads = numWorkerThreads;
        this.developmentMode = developmentMode;
        this.useMocks = useMocks;
        this.useLocalhostForHostList = useLocalhostForHostList;
        this.startingClusterNumber = startingClusterNumber;
        this.awaitMiddleManagerIdleDelay = awaitMiddleManagerIdleDelay;
        this.awaitTaskStatusDelay = awaitTaskStatusDelay;
        this.earlyHandoffDelay = earlyHandoffDelay;
        this.skipRewriteUrlForGroveServer = skipRewriteUrlForGroveServer;
        this.disablePersistenceCache = disablePersistenceCache;
        this.useTls = useTls;
        this.useAuthentication = useAuthentication;
        this.groveUsername = groveUsername;
        this.grovePassword = grovePassword;
        this.defaultsUpdateType = defaultsUpdateType;
        this.skipPackageValidation = skipPackageValidation;
        this.druidApiClientTimeout = druidApiClientTimeout;
    }

    @Generated
    public static class Builder {
        @Generated
        private Platform platform;
        @Generated
        private boolean kubernetesMode;
        @Generated
        private String serviceName;
        @Generated
        private Integer numWorkerThreads;
        @Generated
        private boolean developmentMode;
        @Generated
        private boolean useMocks;
        @Generated
        private boolean useLocalhostForHostList;
        @Generated
        private Integer startingClusterNumber;
        @Generated
        private Integer awaitMiddleManagerIdleDelay;
        @Generated
        private Integer awaitTaskStatusDelay;
        @Generated
        private boolean earlyHandoffDelay$set;
        @Generated
        private Integer earlyHandoffDelay$value;
        @Generated
        private boolean skipRewriteUrlForGroveServer;
        @Generated
        private boolean disablePersistenceCache;
        @Generated
        private boolean useTls;
        @Generated
        private boolean useAuthentication;
        @Generated
        private String groveUsername;
        @Generated
        private String grovePassword;
        @Generated
        private DefaultsUpdateType defaultsUpdateType;
        @Generated
        private boolean skipPackageValidation;
        @Generated
        private boolean druidApiClientTimeout$set;
        @Generated
        private Period druidApiClientTimeout$value;

        @Generated
        Builder() {
        }

        @JsonProperty
        @Generated
        public Builder platform(Platform platform) {
            this.platform = platform;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder kubernetesMode(boolean kubernetesMode) {
            this.kubernetesMode = kubernetesMode;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder numWorkerThreads(Integer numWorkerThreads) {
            this.numWorkerThreads = numWorkerThreads;
            return this;
        }

        @JsonProperty(value="dev.mode")
        @Generated
        public Builder developmentMode(boolean developmentMode) {
            this.developmentMode = developmentMode;
            return this;
        }

        @JsonProperty(value="dev.useMocks")
        @Generated
        public Builder useMocks(boolean useMocks) {
            this.useMocks = useMocks;
            return this;
        }

        @JsonProperty(value="dev.useLocalhostForHostList")
        @Generated
        public Builder useLocalhostForHostList(boolean useLocalhostForHostList) {
            this.useLocalhostForHostList = useLocalhostForHostList;
            return this;
        }

        @JsonProperty(value="dev.startingClusterNumber")
        @Generated
        public Builder startingClusterNumber(Integer startingClusterNumber) {
            this.startingClusterNumber = startingClusterNumber;
            return this;
        }

        @JsonProperty(value="dev.awaitMiddleManagerIdleDelay")
        @Generated
        public Builder awaitMiddleManagerIdleDelay(Integer awaitMiddleManagerIdleDelay) {
            this.awaitMiddleManagerIdleDelay = awaitMiddleManagerIdleDelay;
            return this;
        }

        @JsonProperty(value="dev.awaitTaskStatusDelay")
        @Generated
        public Builder awaitTaskStatusDelay(Integer awaitTaskStatusDelay) {
            this.awaitTaskStatusDelay = awaitTaskStatusDelay;
            return this;
        }

        @JsonProperty(value="dev.earlyHandoffDelay")
        @Generated
        public Builder earlyHandoffDelay(Integer earlyHandoffDelay) {
            this.earlyHandoffDelay$value = earlyHandoffDelay;
            this.earlyHandoffDelay$set = true;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder skipRewriteUrlForGroveServer(boolean skipRewriteUrlForGroveServer) {
            this.skipRewriteUrlForGroveServer = skipRewriteUrlForGroveServer;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder disablePersistenceCache(boolean disablePersistenceCache) {
            this.disablePersistenceCache = disablePersistenceCache;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder useTls(boolean useTls) {
            this.useTls = useTls;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder useAuthentication(boolean useAuthentication) {
            this.useAuthentication = useAuthentication;
            return this;
        }

        @JsonProperty(value="grove.username")
        @Generated
        public Builder groveUsername(String groveUsername) {
            this.groveUsername = groveUsername;
            return this;
        }

        @JsonProperty(value="grove.password")
        @Generated
        public Builder grovePassword(String grovePassword) {
            this.grovePassword = grovePassword;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder defaultsUpdateType(DefaultsUpdateType defaultsUpdateType) {
            this.defaultsUpdateType = defaultsUpdateType;
            return this;
        }

        @JsonProperty(value="dev.skipPackageValidation")
        @Generated
        public Builder skipPackageValidation(boolean skipPackageValidation) {
            this.skipPackageValidation = skipPackageValidation;
            return this;
        }

        @JsonProperty
        @Generated
        public Builder druidApiClientTimeout(Period druidApiClientTimeout) {
            this.druidApiClientTimeout$value = druidApiClientTimeout;
            this.druidApiClientTimeout$set = true;
            return this;
        }

        @Generated
        public ApplicationConfig build() {
            Integer earlyHandoffDelay$value = this.earlyHandoffDelay$value;
            if (!this.earlyHandoffDelay$set) {
                earlyHandoffDelay$value = ApplicationConfig.$default$earlyHandoffDelay();
            }
            Period druidApiClientTimeout$value = this.druidApiClientTimeout$value;
            if (!this.druidApiClientTimeout$set) {
                druidApiClientTimeout$value = ApplicationConfig.$default$druidApiClientTimeout();
            }
            return new ApplicationConfig(this.platform, this.kubernetesMode, this.serviceName, this.numWorkerThreads, this.developmentMode, this.useMocks, this.useLocalhostForHostList, this.startingClusterNumber, this.awaitMiddleManagerIdleDelay, this.awaitTaskStatusDelay, earlyHandoffDelay$value, this.skipRewriteUrlForGroveServer, this.disablePersistenceCache, this.useTls, this.useAuthentication, this.groveUsername, this.grovePassword, this.defaultsUpdateType, this.skipPackageValidation, druidApiClientTimeout$value);
        }

        @Generated
        public String toString() {
            return "ApplicationConfig.Builder(platform=" + String.valueOf((Object)this.platform) + ", kubernetesMode=" + this.kubernetesMode + ", serviceName=" + this.serviceName + ", numWorkerThreads=" + this.numWorkerThreads + ", developmentMode=" + this.developmentMode + ", useMocks=" + this.useMocks + ", useLocalhostForHostList=" + this.useLocalhostForHostList + ", startingClusterNumber=" + this.startingClusterNumber + ", awaitMiddleManagerIdleDelay=" + this.awaitMiddleManagerIdleDelay + ", awaitTaskStatusDelay=" + this.awaitTaskStatusDelay + ", earlyHandoffDelay$value=" + this.earlyHandoffDelay$value + ", skipRewriteUrlForGroveServer=" + this.skipRewriteUrlForGroveServer + ", disablePersistenceCache=" + this.disablePersistenceCache + ", useTls=" + this.useTls + ", useAuthentication=" + this.useAuthentication + ", groveUsername=" + this.groveUsername + ", grovePassword=" + this.grovePassword + ", defaultsUpdateType=" + String.valueOf((Object)this.defaultsUpdateType) + ", skipPackageValidation=" + this.skipPackageValidation + ", druidApiClientTimeout$value=" + String.valueOf(this.druidApiClientTimeout$value) + ")";
        }
    }
}

