/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.concurrent;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.imply.cloud.concurrent.ExecutorServices;
import io.imply.cloud.concurrent.ScheduledExecutorFactory;
import io.imply.cloud.lifecycle.Lifecycle;
import io.imply.cloud.util.Logger;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.joda.time.Duration;

public class ScheduledExecutors {
    private static final Logger log = new Logger(ScheduledExecutors.class);

    public static void scheduleWithFixedDelay(ScheduledExecutorService exec, Duration delay, Runnable runnable) {
        ScheduledExecutors.scheduleWithFixedDelay(exec, delay, delay, runnable);
    }

    public static void scheduleWithFixedDelay(ScheduledExecutorService exec, Duration initialDelay, Duration delay, final Runnable runnable) {
        ScheduledExecutors.scheduleWithFixedDelay(exec, initialDelay, delay, new Callable<Signal>(){

            @Override
            public Signal call() {
                runnable.run();
                return Signal.REPEAT;
            }
        });
    }

    public static void scheduleWithFixedDelay(ScheduledExecutorService exec, Duration delay, Callable<Signal> callable) {
        ScheduledExecutors.scheduleWithFixedDelay(exec, delay, delay, callable);
    }

    public static void scheduleWithFixedDelay(final ScheduledExecutorService exec, Duration initialDelay, final Duration delay, final Callable<Signal> callable) {
        log.debug("Scheduling repeatedly: %s with delay %s", callable, delay);
        exec.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    log.debug("Running %s (delay %s)", callable, delay);
                    if (callable.call() == Signal.REPEAT) {
                        log.debug("Rescheduling %s (delay %s)", callable, delay);
                        exec.schedule(this, delay.getMillis(), TimeUnit.MILLISECONDS);
                    } else {
                        log.debug("Stopped rescheduling %s (delay %s)", callable, delay);
                    }
                }
                catch (Throwable e) {
                    log.error(e, "Uncaught exception.");
                }
            }
        }, initialDelay.getMillis(), TimeUnit.MILLISECONDS);
    }

    public static void scheduleAtFixedRate(ScheduledExecutorService exec, Duration rate, Runnable runnable) {
        ScheduledExecutors.scheduleAtFixedRate(exec, rate, rate, runnable);
    }

    public static void scheduleAtFixedRate(ScheduledExecutorService exec, Duration initialDelay, Duration period, final Runnable runnable) {
        ScheduledExecutors.scheduleAtFixedRate(exec, initialDelay, period, new Callable<Signal>(){

            @Override
            public Signal call() throws Exception {
                runnable.run();
                return Signal.REPEAT;
            }
        });
    }

    public static void scheduleAtFixedRate(ScheduledExecutorService exec, Duration rate, Callable<Signal> callable) {
        ScheduledExecutors.scheduleAtFixedRate(exec, rate, rate, callable);
    }

    public static void scheduleAtFixedRate(final ScheduledExecutorService exec, Duration initialDelay, final Duration rate, final Callable<Signal> callable) {
        log.debug("Scheduling periodically: %s with period %s", callable, rate);
        exec.schedule(new Runnable(){
            private volatile Signal prevSignal = null;

            @Override
            public void run() {
                if (this.prevSignal == null || this.prevSignal == Signal.REPEAT) {
                    exec.schedule(this, rate.getMillis(), TimeUnit.MILLISECONDS);
                }
                try {
                    log.debug("Running %s (period %s)", callable, rate);
                    this.prevSignal = (Signal)((Object)callable.call());
                }
                catch (Throwable e) {
                    log.error(e, "Uncaught exception.");
                }
            }
        }, initialDelay.getMillis(), TimeUnit.MILLISECONDS);
    }

    public static ScheduledExecutorFactory createFactory(final Lifecycle lifecycle) {
        return new ScheduledExecutorFactory(){

            @Override
            public ScheduledExecutorService create(int corePoolSize, String nameFormat) {
                return ExecutorServices.manageLifecycle(lifecycle, ScheduledExecutors.fixed(corePoolSize, nameFormat));
            }
        };
    }

    public static ScheduledExecutorService fixed(int corePoolSize, String nameFormat) {
        return Executors.newScheduledThreadPool(corePoolSize, new ThreadFactoryBuilder().setDaemon(true).setNameFormat(nameFormat).build());
    }

    public static enum Signal {
        REPEAT,
        STOP;

    }
}

