/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.imply.cloud.cache.Cache;
import io.imply.cloud.cache.CacheKey;
import io.imply.cloud.cache.CacheStats;
import io.imply.cloud.cache.CaffeineCacheConfig;
import io.imply.cloud.lifecycle.LifecycleStop;
import io.imply.cloud.util.JvmUtils;
import io.imply.cloud.util.ThreadLocalContext;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.OptionalLong;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;

public class CaffeineCache
implements Cache {
    private static final int FIXED_COST = 8;
    private static final int MAX_DEFAULT_BYTES = 0x40000000;
    private static final LZ4Factory LZ4_FACTORY = LZ4Factory.fastestInstance();
    private static final LZ4FastDecompressor LZ4_DECOMPRESSOR = LZ4_FACTORY.fastDecompressor();
    private static final LZ4Compressor LZ4_COMPRESSOR = LZ4_FACTORY.fastCompressor();
    private final com.github.benmanes.caffeine.cache.Cache<CacheKey, byte[]> cache;
    private final CaffeineCacheConfig config;
    private final boolean requestScoped;

    public static CaffeineCache create(CaffeineCacheConfig config) {
        return CaffeineCache.create(config, config.createExecutor());
    }

    public static CaffeineCache create(CaffeineCacheConfig config, Executor executor) {
        Caffeine builder = Caffeine.newBuilder().recordStats();
        if (config.getExpireAfter() >= 0L) {
            builder.expireAfterWrite(config.getExpireAfter(), TimeUnit.MILLISECONDS);
        }
        if (config.getSizeInBytes() >= 0L) {
            builder.maximumWeight(config.getSizeInBytes());
        } else {
            builder.maximumWeight(Math.min(0x40000000L, JvmUtils.getRuntimeInfo().getMaxHeapSizeBytes() / 10L));
        }
        builder.weigher((key, value) -> ((byte[])value).length + key.getKey().length() * 2 + key.getType().name().length() * 2 + key.getNamespace().length() * 2 + 8).executor(executor);
        return new CaffeineCache((com.github.benmanes.caffeine.cache.Cache<CacheKey, byte[]>)builder.build(), config);
    }

    private CaffeineCache(com.github.benmanes.caffeine.cache.Cache<CacheKey, byte[]> cache, CaffeineCacheConfig config) {
        this.cache = cache;
        this.config = config;
        this.requestScoped = CaffeineCacheConfig.Scope.REQUEST.equals((Object)config.getScope());
    }

    @Override
    public byte[] get(CacheKey key) {
        byte[] data = null;
        if (!this.requestScoped) {
            data = (byte[])this.cache.getIfPresent((Object)key);
        } else if (ThreadLocalContext.getCacheId() != null) {
            data = (byte[])this.cache.getIfPresent((Object)key.withNamespace(ThreadLocalContext.getCacheId()));
        }
        return this.deserialize(data);
    }

    @Override
    public void put(CacheKey key, byte[] value) {
        if (!this.requestScoped) {
            this.cache.put((Object)key, (Object)this.serialize(value));
        } else if (ThreadLocalContext.getCacheId() != null) {
            this.cache.put((Object)key.withNamespace(ThreadLocalContext.getCacheId()), (Object)this.serialize(value));
        }
    }

    @Override
    public Map<CacheKey, byte[]> getBulk(Iterable<CacheKey> keys) {
        return ImmutableMap.copyOf((Map)Maps.transformValues((Map)this.cache.getAllPresent(keys), this::deserialize));
    }

    @Override
    public void invalidate(CacheKey key) {
        this.cache.invalidate((Object)key);
    }

    @Override
    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    @Override
    public void close(String namespace) {
        if (this.config.isEvictOnClose()) {
            this.cache.asMap().keySet().removeIf(key -> key.getNamespace().equals(namespace));
        }
    }

    @Override
    @LifecycleStop
    public void close() {
        this.cache.cleanUp();
    }

    @Override
    public CacheStats getStats() {
        com.github.benmanes.caffeine.cache.stats.CacheStats stats = this.cache.stats();
        long size = this.cache.policy().eviction().map(eviction -> eviction.isWeighted() ? eviction.weightedSize() : OptionalLong.empty()).orElseGet(OptionalLong::empty).orElse(-1L);
        return new CacheStats(stats.hitCount(), stats.missCount(), this.cache.estimatedSize(), size, stats.evictionCount(), 0L, stats.loadFailureCount());
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @VisibleForTesting
    com.github.benmanes.caffeine.cache.Cache<CacheKey, byte[]> getCache() {
        return this.cache;
    }

    private byte[] deserialize(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        int decompressedLen = ByteBuffer.wrap(bytes).getInt();
        byte[] out = new byte[decompressedLen];
        LZ4_DECOMPRESSOR.decompress(bytes, 4, out, 0, out.length);
        return out;
    }

    private byte[] serialize(byte[] value) {
        int len = LZ4_COMPRESSOR.maxCompressedLength(value.length);
        byte[] out = new byte[len];
        int compressedSize = LZ4_COMPRESSOR.compress(value, 0, value.length, out, 0);
        return ByteBuffer.allocate(compressedSize + 4).putInt(value.length).put(out, 0, compressedSize).array();
    }
}

