/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Inject;
import io.imply.cloud.ExcludeFromJacocoGeneratedReport;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.concurrent.Execs;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.config.DefaultsConfig;
import io.imply.cloud.config.SecurityConfig;
import io.imply.cloud.configurator.ConfiguratorManager;
import io.imply.cloud.druid.DruidApiClient;
import io.imply.cloud.grove.GroveClient;
import io.imply.cloud.http.HttpClientProvider;
import io.imply.cloud.model.Platform;
import io.imply.cloud.persistence.AccountDataManager;
import io.imply.cloud.persistence.BillingDataManager;
import io.imply.cloud.persistence.CloudResourcesDataManager;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.persistence.ClusterNodesDataManager;
import io.imply.cloud.persistence.EntityStateDataManager;
import io.imply.cloud.persistence.InstanceHealthDataManager;
import io.imply.cloud.persistence.NotificationDataManager;
import io.imply.cloud.persistence.UserDataManager;
import io.imply.cloud.util.ImplyVersionHelper;
import io.imply.cloud.util.InstanceTypeHelper;
import io.imply.telemetry.Emitter;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.eclipse.jetty.client.HttpClient;

@ExcludeFromJacocoGeneratedReport
public class Toolbox {
    private final ApplicationConfig applicationConfig;
    private final SecurityConfig securityConfig;
    private final AccountDataManager accountDataManager;
    private final ClusterDataManager clusterDataManager;
    private final UserDataManager userDataManager;
    private final EntityStateDataManager entityStateDataManager;
    private final InstanceHealthDataManager instanceHealthDataManager;
    private final CloudResourcesDataManager cloudResourcesDataManager;
    private final NotificationDataManager notificationDataManager;
    private final ClusterNodesDataManager clusterNodesDataManager;
    private final BillingDataManager billingDataManager;
    private final HttpClientProvider httpClientProvider;
    private final ObjectMapper objectMapper;
    private final DruidApiClient druidApiClient;
    private final GroveClient groveClient;
    private final DefaultsConfig defaultsConfig;
    private final ConfiguratorManager configuratorManager;
    private final ImplyVersionHelper implyVersionHelper;
    private final Emitter emitter;
    private final RefreshableConstants refreshableConstants;
    private final InstanceTypeHelper instanceTypeHelper;
    private final ListeningExecutorService workerExecutor;

    @Inject
    public Toolbox(ApplicationConfig applicationConfig, SecurityConfig securityConfig, AccountDataManager accountDataManager, ClusterDataManager clusterDataManager, UserDataManager userDataManager, EntityStateDataManager entityStateDataManager, InstanceHealthDataManager instanceHealthDataManager, CloudResourcesDataManager cloudResourcesDataManager, NotificationDataManager notificationDataManager, ClusterNodesDataManager clusterNodesDataManager, BillingDataManager billingDataManager, HttpClientProvider httpClientProvider, ObjectMapper objectMapper, DruidApiClient druidApiClient, GroveClient groveClient, DefaultsConfig defaultsConfig, ConfiguratorManager configuratorManager, ImplyVersionHelper implyVersionHelper, Emitter emitter, RefreshableConstants refreshableConstants, InstanceTypeHelper instanceTypeHelper) {
        this.applicationConfig = applicationConfig;
        this.securityConfig = securityConfig;
        this.accountDataManager = accountDataManager;
        this.clusterDataManager = clusterDataManager;
        this.userDataManager = userDataManager;
        this.entityStateDataManager = entityStateDataManager;
        this.instanceHealthDataManager = instanceHealthDataManager;
        this.cloudResourcesDataManager = cloudResourcesDataManager;
        this.notificationDataManager = notificationDataManager;
        this.clusterNodesDataManager = clusterNodesDataManager;
        this.billingDataManager = billingDataManager;
        this.httpClientProvider = httpClientProvider;
        this.objectMapper = objectMapper;
        this.druidApiClient = druidApiClient;
        this.groveClient = groveClient;
        this.defaultsConfig = defaultsConfig;
        this.configuratorManager = configuratorManager;
        this.workerExecutor = MoreExecutors.listeningDecorator((ExecutorService)Execs.multiThreaded(applicationConfig.getNumWorkerThreads(), "Toolbox-%02d"));
        this.implyVersionHelper = implyVersionHelper;
        this.emitter = emitter;
        this.refreshableConstants = refreshableConstants;
        this.instanceTypeHelper = instanceTypeHelper;
    }

    public ApplicationConfig getApplicationConfig() {
        return this.applicationConfig;
    }

    public SecurityConfig getSecurityConfig() {
        return this.securityConfig;
    }

    public AccountDataManager getAccountDataManager() {
        return this.accountDataManager;
    }

    public ClusterDataManager getClusterDataManager() {
        return this.clusterDataManager;
    }

    public UserDataManager getUserDataManager() {
        return this.userDataManager;
    }

    public EntityStateDataManager getEntityStateDataManager() {
        return this.entityStateDataManager;
    }

    public InstanceHealthDataManager getInstanceHealthDataManager() {
        return this.instanceHealthDataManager;
    }

    public CloudResourcesDataManager getCloudResourcesDataManager() {
        return this.cloudResourcesDataManager;
    }

    public NotificationDataManager getNotificationDataManager() {
        return this.notificationDataManager;
    }

    public ClusterNodesDataManager getClusterNodesDataManager() {
        return this.clusterNodesDataManager;
    }

    public BillingDataManager getBillingDataManager() {
        return this.billingDataManager;
    }

    public HttpClient getHttpClient() {
        return this.httpClientProvider.get();
    }

    public HttpClient getHttpClient(boolean forceRealClient) {
        return this.httpClientProvider.get(forceRealClient);
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public DruidApiClient getDruidApiClient() {
        return this.druidApiClient;
    }

    public GroveClient getGroveClient() {
        return this.groveClient;
    }

    public DefaultsConfig getDefaultsConfig() {
        return this.defaultsConfig;
    }

    public ConfiguratorManager getConfiguratorManager() {
        return this.configuratorManager;
    }

    public ImplyVersionHelper getImplyVersionHelper() {
        return this.implyVersionHelper;
    }

    public ListeningExecutorService getWorkerExecutor() {
        return this.workerExecutor;
    }

    public Platform getPlatform() {
        return this.applicationConfig.getPlatform();
    }

    public boolean isOnPrem() {
        return this.applicationConfig.isOnPrem();
    }

    public boolean isAWS() {
        return this.applicationConfig.isAWS();
    }

    public Emitter getEmitter() {
        return this.emitter;
    }

    public RefreshableConstants getRefreshableConstants() {
        return this.refreshableConstants;
    }

    public InstanceTypeHelper getInstanceTypeHelper() {
        return this.instanceTypeHelper;
    }

    @Generated
    protected Toolbox(Builder<?, ?> b) {
        this.applicationConfig = b.applicationConfig;
        this.securityConfig = b.securityConfig;
        this.accountDataManager = b.accountDataManager;
        this.clusterDataManager = b.clusterDataManager;
        this.userDataManager = b.userDataManager;
        this.entityStateDataManager = b.entityStateDataManager;
        this.instanceHealthDataManager = b.instanceHealthDataManager;
        this.cloudResourcesDataManager = b.cloudResourcesDataManager;
        this.notificationDataManager = b.notificationDataManager;
        this.clusterNodesDataManager = b.clusterNodesDataManager;
        this.billingDataManager = b.billingDataManager;
        this.httpClientProvider = b.httpClientProvider;
        this.objectMapper = b.objectMapper;
        this.druidApiClient = b.druidApiClient;
        this.groveClient = b.groveClient;
        this.defaultsConfig = b.defaultsConfig;
        this.configuratorManager = b.configuratorManager;
        this.implyVersionHelper = b.implyVersionHelper;
        this.emitter = b.emitter;
        this.refreshableConstants = b.refreshableConstants;
        this.instanceTypeHelper = b.instanceTypeHelper;
        this.workerExecutor = b.workerExecutor;
    }

    @Generated
    public static Builder<?, ?> builder() {
        return new BuilderImpl();
    }

    @Generated
    public static abstract class Builder<C extends Toolbox, B extends Builder<C, B>> {
        @Generated
        private ApplicationConfig applicationConfig;
        @Generated
        private SecurityConfig securityConfig;
        @Generated
        private AccountDataManager accountDataManager;
        @Generated
        private ClusterDataManager clusterDataManager;
        @Generated
        private UserDataManager userDataManager;
        @Generated
        private EntityStateDataManager entityStateDataManager;
        @Generated
        private InstanceHealthDataManager instanceHealthDataManager;
        @Generated
        private CloudResourcesDataManager cloudResourcesDataManager;
        @Generated
        private NotificationDataManager notificationDataManager;
        @Generated
        private ClusterNodesDataManager clusterNodesDataManager;
        @Generated
        private BillingDataManager billingDataManager;
        @Generated
        private HttpClientProvider httpClientProvider;
        @Generated
        private ObjectMapper objectMapper;
        @Generated
        private DruidApiClient druidApiClient;
        @Generated
        private GroveClient groveClient;
        @Generated
        private DefaultsConfig defaultsConfig;
        @Generated
        private ConfiguratorManager configuratorManager;
        @Generated
        private ImplyVersionHelper implyVersionHelper;
        @Generated
        private Emitter emitter;
        @Generated
        private RefreshableConstants refreshableConstants;
        @Generated
        private InstanceTypeHelper instanceTypeHelper;
        @Generated
        private ListeningExecutorService workerExecutor;

        @Generated
        public B applicationConfig(ApplicationConfig applicationConfig) {
            this.applicationConfig = applicationConfig;
            return this.self();
        }

        @Generated
        public B securityConfig(SecurityConfig securityConfig) {
            this.securityConfig = securityConfig;
            return this.self();
        }

        @Generated
        public B accountDataManager(AccountDataManager accountDataManager) {
            this.accountDataManager = accountDataManager;
            return this.self();
        }

        @Generated
        public B clusterDataManager(ClusterDataManager clusterDataManager) {
            this.clusterDataManager = clusterDataManager;
            return this.self();
        }

        @Generated
        public B userDataManager(UserDataManager userDataManager) {
            this.userDataManager = userDataManager;
            return this.self();
        }

        @Generated
        public B entityStateDataManager(EntityStateDataManager entityStateDataManager) {
            this.entityStateDataManager = entityStateDataManager;
            return this.self();
        }

        @Generated
        public B instanceHealthDataManager(InstanceHealthDataManager instanceHealthDataManager) {
            this.instanceHealthDataManager = instanceHealthDataManager;
            return this.self();
        }

        @Generated
        public B cloudResourcesDataManager(CloudResourcesDataManager cloudResourcesDataManager) {
            this.cloudResourcesDataManager = cloudResourcesDataManager;
            return this.self();
        }

        @Generated
        public B notificationDataManager(NotificationDataManager notificationDataManager) {
            this.notificationDataManager = notificationDataManager;
            return this.self();
        }

        @Generated
        public B clusterNodesDataManager(ClusterNodesDataManager clusterNodesDataManager) {
            this.clusterNodesDataManager = clusterNodesDataManager;
            return this.self();
        }

        @Generated
        public B billingDataManager(BillingDataManager billingDataManager) {
            this.billingDataManager = billingDataManager;
            return this.self();
        }

        @Generated
        public B httpClientProvider(HttpClientProvider httpClientProvider) {
            this.httpClientProvider = httpClientProvider;
            return this.self();
        }

        @Generated
        public B objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this.self();
        }

        @Generated
        public B druidApiClient(DruidApiClient druidApiClient) {
            this.druidApiClient = druidApiClient;
            return this.self();
        }

        @Generated
        public B groveClient(GroveClient groveClient) {
            this.groveClient = groveClient;
            return this.self();
        }

        @Generated
        public B defaultsConfig(DefaultsConfig defaultsConfig) {
            this.defaultsConfig = defaultsConfig;
            return this.self();
        }

        @Generated
        public B configuratorManager(ConfiguratorManager configuratorManager) {
            this.configuratorManager = configuratorManager;
            return this.self();
        }

        @Generated
        public B implyVersionHelper(ImplyVersionHelper implyVersionHelper) {
            this.implyVersionHelper = implyVersionHelper;
            return this.self();
        }

        @Generated
        public B emitter(Emitter emitter) {
            this.emitter = emitter;
            return this.self();
        }

        @Generated
        public B refreshableConstants(RefreshableConstants refreshableConstants) {
            this.refreshableConstants = refreshableConstants;
            return this.self();
        }

        @Generated
        public B instanceTypeHelper(InstanceTypeHelper instanceTypeHelper) {
            this.instanceTypeHelper = instanceTypeHelper;
            return this.self();
        }

        @Generated
        public B workerExecutor(ListeningExecutorService workerExecutor) {
            this.workerExecutor = workerExecutor;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "Toolbox.Builder(applicationConfig=" + String.valueOf(this.applicationConfig) + ", securityConfig=" + String.valueOf(this.securityConfig) + ", accountDataManager=" + String.valueOf(this.accountDataManager) + ", clusterDataManager=" + String.valueOf(this.clusterDataManager) + ", userDataManager=" + String.valueOf(this.userDataManager) + ", entityStateDataManager=" + String.valueOf(this.entityStateDataManager) + ", instanceHealthDataManager=" + String.valueOf(this.instanceHealthDataManager) + ", cloudResourcesDataManager=" + String.valueOf(this.cloudResourcesDataManager) + ", notificationDataManager=" + String.valueOf(this.notificationDataManager) + ", clusterNodesDataManager=" + String.valueOf(this.clusterNodesDataManager) + ", billingDataManager=" + String.valueOf(this.billingDataManager) + ", httpClientProvider=" + String.valueOf(this.httpClientProvider) + ", objectMapper=" + String.valueOf(this.objectMapper) + ", druidApiClient=" + String.valueOf(this.druidApiClient) + ", groveClient=" + String.valueOf(this.groveClient) + ", defaultsConfig=" + String.valueOf(this.defaultsConfig) + ", configuratorManager=" + String.valueOf(this.configuratorManager) + ", implyVersionHelper=" + String.valueOf(this.implyVersionHelper) + ", emitter=" + String.valueOf(this.emitter) + ", refreshableConstants=" + String.valueOf(this.refreshableConstants) + ", instanceTypeHelper=" + String.valueOf(this.instanceTypeHelper) + ", workerExecutor=" + String.valueOf(this.workerExecutor) + ")";
        }
    }

    @Generated
    private static final class BuilderImpl
    extends Builder<Toolbox, BuilderImpl> {
        @Generated
        private BuilderImpl() {
        }

        @Override
        @Generated
        protected BuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Toolbox build() {
            return new Toolbox(this);
        }
    }
}

