/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.imply.cloud.config.ApplicationConfig;
import io.imply.cloud.config.RefreshableConstantsConfig;
import io.imply.cloud.guice.annotations.LazySingleton;
import io.imply.cloud.model.AdditionalFiles;
import io.imply.cloud.model.AmiRegion;
import io.imply.cloud.model.Architecture;
import io.imply.cloud.model.ClusterSizeDetails;
import io.imply.cloud.model.ColdTierClusterSizeDetails;
import io.imply.cloud.model.ComparableVersion;
import io.imply.cloud.model.DataUnitType;
import io.imply.cloud.model.DruidConfiguration;
import io.imply.cloud.model.DruidExtensions;
import io.imply.cloud.model.DruidInstanceTypeConfig;
import io.imply.cloud.model.DruidRoleMapping;
import io.imply.cloud.model.FeatureFlag;
import io.imply.cloud.model.ImplyVersion;
import io.imply.cloud.model.InstanceType;
import io.imply.cloud.model.LicenseEntitlement;
import io.imply.cloud.model.MasterUnitType;
import io.imply.cloud.model.PivotConfiguration;
import io.imply.cloud.model.Platform;
import io.imply.cloud.model.ProjectPlan;
import io.imply.cloud.model.QueryUnitType;
import io.imply.cloud.model.Region;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.inject.Inject;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;

@LazySingleton
public class RefreshableConstants {
    @Generated
    private static final Logger log = Logger.from(RefreshableConstants.class);
    private final ObjectMapper objectMapper;
    private volatile List<AmiRegion> amiForRegion;
    private volatile List<ImplyVersion> supportedImplyVersions;
    private volatile List<InstanceType> supportedMasterInstanceTypes;
    private volatile List<InstanceType> supportedQueryInstanceTypes;
    private volatile List<InstanceType> supportedDataInstanceTypes;
    private volatile List<InstanceType> supportedDbInstanceTypes;
    private volatile List<InstanceType> supportedIngestInstanceTypes;
    private volatile List<DruidInstanceTypeConfig> druidInstanceTypeConfigurations;
    private volatile List<DruidExtensions> druidExtensions;
    private volatile List<PivotConfiguration> pivotConfigurations;
    private volatile List<String> clusterHealthCheckExclusions;
    private volatile List<FeatureFlag> featureFlags;
    private volatile List<AdditionalFiles> additionalFiles;
    private volatile List<DruidConfiguration> druidConfigurations;
    private volatile List<ColdTierClusterSizeDetails> coldTierClusterSizeDetails;
    private volatile List<DruidRoleMapping> druidRoleMappings;
    private volatile List<LicenseEntitlement> licenseEntitlements;
    private volatile Map<String, List<ClusterSizeDetails>> projectSizeMap;
    private volatile List<ProjectPlan> projectPlans;
    private volatile Map<String, List<DataUnitType>> dataUnitTypeMap;
    private volatile Map<String, List<MasterUnitType>> masterUnitTypeMap;
    private volatile Map<String, List<QueryUnitType>> queryUnitTypeMap;

    @Inject
    public RefreshableConstants(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setAmiForRegion(List<AmiRegion> amiForRegion) {
        this.amiForRegion = amiForRegion;
    }

    private void setSupportedImplyVersions(List<ImplyVersion> supportedImplyVersions) {
        this.supportedImplyVersions = supportedImplyVersions;
    }

    private void setSupportedMasterInstanceTypes(List<InstanceType> supportedMasterInstanceTypes) {
        this.supportedMasterInstanceTypes = supportedMasterInstanceTypes == null ? null : supportedMasterInstanceTypes.stream().filter(Objects::nonNull).filter(InstanceType::isNotNull).collect(Collectors.toList());
    }

    private void setSupportedQueryInstanceTypes(List<InstanceType> supportedQueryInstanceTypes) {
        this.supportedQueryInstanceTypes = supportedQueryInstanceTypes == null ? null : supportedQueryInstanceTypes.stream().filter(Objects::nonNull).filter(InstanceType::isNotNull).collect(Collectors.toList());
    }

    private void setSupportedDataInstanceTypes(List<InstanceType> supportedDataInstanceTypes) {
        this.supportedDataInstanceTypes = supportedDataInstanceTypes == null ? null : supportedDataInstanceTypes.stream().filter(Objects::nonNull).filter(InstanceType::isNotNull).collect(Collectors.toList());
    }

    private void setSupportedDbInstanceTypes(List<InstanceType> supportedDbInstanceTypes) {
        this.supportedDbInstanceTypes = supportedDbInstanceTypes == null ? null : supportedDbInstanceTypes.stream().filter(Objects::nonNull).filter(InstanceType::isNotNull).collect(Collectors.toList());
    }

    private void setSupportedIngestInstanceTypes(List<InstanceType> supportedIngestInstanceTypes) {
        this.supportedIngestInstanceTypes = supportedIngestInstanceTypes == null ? null : supportedIngestInstanceTypes.stream().filter(Objects::nonNull).filter(InstanceType::isNotNull).collect(Collectors.toList());
    }

    private void setDruidInstanceTypeConfigurations(List<DruidInstanceTypeConfig> druidInstanceTypeConfigurations) {
        this.druidInstanceTypeConfigurations = druidInstanceTypeConfigurations == null ? null : druidInstanceTypeConfigurations.stream().filter(Objects::nonNull).filter(DruidInstanceTypeConfig::isNotEmpty).collect(Collectors.toList());
    }

    private void setDruidExtensions(List<DruidExtensions> druidExtensions) {
        this.druidExtensions = druidExtensions;
    }

    private void setPivotConfigurations(List<PivotConfiguration> pivotConfigurations) {
        this.pivotConfigurations = pivotConfigurations;
    }

    private void setClusterHealthCheckExclusions(List<String> clusterHealthCheckExclusions) {
        this.clusterHealthCheckExclusions = clusterHealthCheckExclusions;
    }

    private void setFeatureFlags(List<FeatureFlag> featureFlags) {
        this.featureFlags = featureFlags;
    }

    private void setAdditionalFiles(List<AdditionalFiles> additionalFiles) {
        this.additionalFiles = additionalFiles;
    }

    private void setDruidConfigurations(List<DruidConfiguration> druidConfigurations) {
        this.druidConfigurations = druidConfigurations == null ? null : druidConfigurations.stream().filter(Objects::nonNull).filter(DruidConfiguration::isNotEmpty).collect(Collectors.toList());
    }

    private void setColdTierClusterSizeDetails(List<ColdTierClusterSizeDetails> coldTierClusterSizeDetails) {
        this.coldTierClusterSizeDetails = coldTierClusterSizeDetails == null ? null : coldTierClusterSizeDetails.stream().filter(Objects::nonNull).filter(ColdTierClusterSizeDetails::isNotEmpty).collect(Collectors.toList());
    }

    private void setProjectSizeMap(Map<String, List<ClusterSizeDetails>> projectSizeMap) {
        this.projectSizeMap = projectSizeMap;
    }

    private void setProjectPlans(List<ProjectPlan> projectPlans) {
        this.projectPlans = projectPlans;
    }

    private void setDataUnitTypeMap(Map<String, List<DataUnitType>> dataUnitTypeMap) {
        this.dataUnitTypeMap = dataUnitTypeMap;
    }

    private void setMasterUnitTypeMap(Map<String, List<MasterUnitType>> masterUnitTypeMap) {
        this.masterUnitTypeMap = masterUnitTypeMap;
    }

    private void setQueryUnitTypeMap(Map<String, List<QueryUnitType>> queryUnitTypeMap) {
        this.queryUnitTypeMap = queryUnitTypeMap;
    }

    private void setDruidRoleMappings(List<DruidRoleMapping> druidRoleMappings) {
        this.druidRoleMappings = druidRoleMappings == null ? null : druidRoleMappings.stream().filter(Objects::nonNull).filter(DruidRoleMapping::isNotEmpty).collect(Collectors.toList());
    }

    private void setLicenseEntitlements(List<LicenseEntitlement> licenseEntitlements) {
        this.licenseEntitlements = licenseEntitlements;
    }

    public List<AmiRegion> getAmiForRegion() {
        return ListUtils.emptyIfNull(this.amiForRegion);
    }

    public List<ImplyVersion> getSupportedImplyVersions() {
        return ListUtils.emptyIfNull(this.supportedImplyVersions);
    }

    public List<InstanceType> getSupportedMasterInstanceTypes() {
        return ListUtils.emptyIfNull(this.supportedMasterInstanceTypes);
    }

    public List<InstanceType> getSupportedQueryInstanceTypes() {
        return ListUtils.emptyIfNull(this.supportedQueryInstanceTypes);
    }

    public List<InstanceType> getSupportedDataInstanceTypes() {
        return ListUtils.emptyIfNull(this.supportedDataInstanceTypes);
    }

    public List<InstanceType> getSupportedDbInstanceTypes() {
        return ListUtils.emptyIfNull(this.supportedDbInstanceTypes);
    }

    public List<InstanceType> getSupportedIngestInstanceTypes() {
        return ListUtils.emptyIfNull(this.supportedIngestInstanceTypes);
    }

    public List<DruidInstanceTypeConfig> getDruidInstanceTypeConfigurations() {
        return ListUtils.emptyIfNull(this.druidInstanceTypeConfigurations);
    }

    public List<DruidExtensions> getDruidExtensions() {
        return ListUtils.emptyIfNull(this.druidExtensions);
    }

    public List<PivotConfiguration> getPivotConfigurations() {
        return ListUtils.emptyIfNull(this.pivotConfigurations);
    }

    public List<String> getClusterHealthCheckExclusions() {
        return ListUtils.emptyIfNull(this.clusterHealthCheckExclusions);
    }

    public List<FeatureFlag> getFeatureFlags() {
        return ListUtils.emptyIfNull(this.featureFlags);
    }

    public List<AdditionalFiles> getAdditionalFiles() {
        return ListUtils.emptyIfNull(this.additionalFiles);
    }

    public List<DruidConfiguration> getDruidConfigurations() {
        return ListUtils.emptyIfNull(this.druidConfigurations);
    }

    public List<ColdTierClusterSizeDetails> getColdTierClusterSizeDetails() {
        return ListUtils.emptyIfNull(this.coldTierClusterSizeDetails);
    }

    public Map<String, List<ClusterSizeDetails>> getProjectSizeMap() {
        return MapUtils.emptyIfNull(this.projectSizeMap);
    }

    public List<ProjectPlan> getProjectPlans() {
        return ListUtils.emptyIfNull(this.projectPlans);
    }

    public Map<String, List<DataUnitType>> getDataUnitTypeMap() {
        return MapUtils.emptyIfNull(this.dataUnitTypeMap);
    }

    public Map<String, List<MasterUnitType>> getMasterUnitTypeMap() {
        return MapUtils.emptyIfNull(this.masterUnitTypeMap);
    }

    public Map<String, List<QueryUnitType>> getQueryUnitTypeMap() {
        return MapUtils.emptyIfNull(this.queryUnitTypeMap);
    }

    public List<DruidRoleMapping> getDruidRoleMappings() {
        return ListUtils.emptyIfNull(this.druidRoleMappings);
    }

    public List<LicenseEntitlement> getLicenseEntitlements() {
        return ListUtils.emptyIfNull(this.licenseEntitlements);
    }

    public String lookupAmiForRegion(Region region, ImplyVersion implyVersion, Architecture architecture) {
        Map<Region, String> versionedAmiRegion = AmiRegion.getForComparableImplyVersion(implyVersion.getComparableVersion(), architecture, this);
        return versionedAmiRegion.get((Object)region);
    }

    public String lookupAmiByInstanceTypeForRegion(Region region, ImplyVersion implyVersion, List<InstanceType> supportedInstanceTypes, String instanceTypeName) {
        Architecture architecture = supportedInstanceTypes.stream().filter(x -> x.getInstanceType().equals(instanceTypeName)).findFirst().orElseThrow(() -> new IAE("Unsupported instanceType [%s] in AWS region [%s]", instanceTypeName, region.getName())).getArchitecture();
        Map<Region, String> versionedAmiRegion = AmiRegion.getForComparableImplyVersion(implyVersion.getComparableVersion(), architecture, this);
        String ami = versionedAmiRegion.get((Object)region);
        if (ami == null) {
            throw new IAE("Unsupported AWS region [%s]", region.getName());
        }
        return ami;
    }

    public ImplyVersion lookupImplyVersion(String version) {
        return version == null ? null : (ImplyVersion)this.getSupportedImplyVersions().stream().filter(x -> version.equals(x.getVersion())).findFirst().orElse(null);
    }

    public ComparableVersion lookupComparableVersion(String version) {
        ImplyVersion implyVersion = this.lookupImplyVersion(version);
        return implyVersion == null || implyVersion.getComparableVersion() == null ? new ComparableVersion(version) : implyVersion.getComparableVersion();
    }

    protected List<RefreshJob<?>> getJobs(RefreshableConstantsConfig refreshableConstantsConfig, ApplicationConfig applicationConfig) {
        ImmutableList.Builder jobsListBuilder = ImmutableList.builder();
        jobsListBuilder.add((Object[])new RefreshJob[]{new RefreshJob<List>(refreshableConstantsConfig.getImplyVersionsKey(), new TypeReference<List<ImplyVersion>>(){}, this::getSupportedImplyVersions, this::setSupportedImplyVersions, "implyVersions"), new RefreshJob<List>(refreshableConstantsConfig.getFeatureFlagsKey(), new TypeReference<List<FeatureFlag>>(){}, this::getFeatureFlags, this::setFeatureFlags, "featureFlags"), new RefreshJob<List>(refreshableConstantsConfig.getDruidExtensionsKey(), new TypeReference<List<DruidExtensions>>(){}, this::getDruidExtensions, this::setDruidExtensions, "druidExtensions"), new RefreshJob<List>(refreshableConstantsConfig.getAdditionalFilesKey(), new TypeReference<List<AdditionalFiles>>(){}, this::getAdditionalFiles, this::setAdditionalFiles, "additionalFiles"), new RefreshJob<List>(refreshableConstantsConfig.getDruidConfigurationsKey(), new TypeReference<List<DruidConfiguration>>(){}, this::getDruidConfigurations, this::setDruidConfigurations, "defaultDruidConfigurations")});
        if (applicationConfig.isKubernetesMode() || applicationConfig.isAWS()) {
            jobsListBuilder.add((Object[])new RefreshJob[]{new RefreshJob<List>(refreshableConstantsConfig.getMasterInstanceTypesKey(), new TypeReference<List<InstanceType>>(){}, this::getSupportedMasterInstanceTypes, this::setSupportedMasterInstanceTypes, "masterInstanceTypes"), new RefreshJob<List>(refreshableConstantsConfig.getQueryInstanceTypesKey(), new TypeReference<List<InstanceType>>(){}, this::getSupportedQueryInstanceTypes, this::setSupportedQueryInstanceTypes, "queryInstanceTypes"), new RefreshJob<List>(refreshableConstantsConfig.getDataInstanceTypesKey(), new TypeReference<List<InstanceType>>(){}, this::getSupportedDataInstanceTypes, this::setSupportedDataInstanceTypes, "dataInstanceTypes"), new RefreshJob<List>(refreshableConstantsConfig.getDruidInstanceTypeConfigurationsKey(), new TypeReference<List<DruidInstanceTypeConfig>>(){}, this::getDruidInstanceTypeConfigurations, this::setDruidInstanceTypeConfigurations, "instanceTypeDruidConfigurations")});
        }
        if (applicationConfig.isAWS() || applicationConfig.isSaaS() || applicationConfig.isIOW()) {
            jobsListBuilder.add(new RefreshJob<List>(refreshableConstantsConfig.getLicenseEntitlementsKey(), new TypeReference<List<LicenseEntitlement>>(){}, this::getLicenseEntitlements, this::setLicenseEntitlements, "licenseEntitlements"));
        }
        if (Platform.AWS.equals((Object)applicationConfig.getPlatform())) {
            jobsListBuilder.add((Object[])new RefreshJob[]{new RefreshJob<List>(refreshableConstantsConfig.getPivotConfigurationsKey(), new TypeReference<List<PivotConfiguration>>(){}, this::getPivotConfigurations, this::setPivotConfigurations, "defaultPivotConfigurations"), new RefreshJob<List>(refreshableConstantsConfig.getAmiForRegionKey(), new TypeReference<List<AmiRegion>>(){}, this::getAmiForRegion, this::setAmiForRegion, "amiForRegion"), new RefreshJob<List>(refreshableConstantsConfig.getDbInstanceTypesKey(), new TypeReference<List<InstanceType>>(){}, this::getSupportedDbInstanceTypes, this::setSupportedDbInstanceTypes, "dbInstanceTypes"), new RefreshJob<List>(refreshableConstantsConfig.getClusterHealthCheckExclusionsKey(), new TypeReference<List<String>>(){}, this::getClusterHealthCheckExclusions, this::setClusterHealthCheckExclusions, "healthCheckExclusions"), new RefreshJob<List>(refreshableConstantsConfig.getColdTierClusterSizeDetailsKey(), new TypeReference<List<ColdTierClusterSizeDetails>>(){}, this::getColdTierClusterSizeDetails, this::setColdTierClusterSizeDetails, "coldTierClusterSizeDetails")});
        }
        if (applicationConfig.isSaaS()) {
            jobsListBuilder.add((Object[])new RefreshJob[]{new RefreshJob<Map>(refreshableConstantsConfig.getProjectSizeMapKey(), new TypeReference<Map<String, List<ClusterSizeDetails>>>(){}, this::getProjectSizeMap, this::setProjectSizeMap, "projectSizeMap"), new RefreshJob<List>(refreshableConstantsConfig.getProjectPlanListKey(), new TypeReference<List<ProjectPlan>>(){}, this::getProjectPlans, this::setProjectPlans, "projectPlanList"), new RefreshJob<Map>(refreshableConstantsConfig.getDataUnitTypeMapKey(), new TypeReference<Map<String, List<DataUnitType>>>(){}, this::getDataUnitTypeMap, this::setDataUnitTypeMap, "dataUnitTypeMap"), new RefreshJob<Map>(refreshableConstantsConfig.getMasterUnitTypeMapKey(), new TypeReference<Map<String, List<MasterUnitType>>>(){}, this::getMasterUnitTypeMap, this::setMasterUnitTypeMap, "masterUnitTypeMap"), new RefreshJob<Map>(refreshableConstantsConfig.getQueryUnitTypeMapKey(), new TypeReference<Map<String, List<QueryUnitType>>>(){}, this::getQueryUnitTypeMap, this::setQueryUnitTypeMap, "queryUnitTypeMap")});
        }
        if (applicationConfig.isSaaS() || applicationConfig.isIOW()) {
            jobsListBuilder.add((Object[])new RefreshJob[]{new RefreshJob<List>(refreshableConstantsConfig.getIngestInstanceTypesKey(), new TypeReference<List<InstanceType>>(){}, this::getSupportedIngestInstanceTypes, this::setSupportedIngestInstanceTypes, "ingestInstanceTypes"), new RefreshJob<List>(refreshableConstantsConfig.getDruidRoleMappings(), new TypeReference<List<DruidRoleMapping>>(){}, this::getDruidRoleMappings, this::setDruidRoleMappings, "druidRoleMappings")});
        }
        return jobsListBuilder.build();
    }

    public void refresh(RefreshableConstantsConfig refreshableConstantsConfig, UnaryOperator<String> configSupplier, ApplicationConfig applicationConfig, boolean failOnException) {
        List<RefreshJob<?>> jobs = this.getJobs(refreshableConstantsConfig, applicationConfig);
        ArrayList<String> refreshedConfigs = new ArrayList<String>();
        for (RefreshJob<?> job : jobs) {
            this.update(job, configSupplier, failOnException, refreshedConfigs);
        }
        if (!refreshedConfigs.isEmpty()) {
            log.info(false, "Updated configurations for: %s", Joiner.on((String)" / ").join(refreshedConfigs));
        }
    }

    private <T> void update(RefreshJob<T> job, UnaryOperator<String> configSupplier, boolean failOnException, List<String> refreshedConfigs) {
        block3: {
            try {
                String contentStr = (String)configSupplier.apply(job.key);
                Object contents = this.objectMapper.readValue(contentStr, job.typeReference);
                if (contents != null && !contents.equals(job.getFn.get())) {
                    log.debug("Refreshing RefreshableConstants from [%s] with: %s", job.key, contents);
                    refreshedConfigs.add(String.format("[%s]->%s", job.configName, job.key));
                    job.setFn.accept(contents);
                }
            }
            catch (Throwable e) {
                log.info("Exception while refreshing configuration key [%s]: %s", job.key, e.getMessage());
                if (!failOnException) break block3;
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    public boolean isEmpty() {
        return CollectionUtils.isEmpty(this.supportedImplyVersions) && CollectionUtils.isEmpty(this.supportedMasterInstanceTypes) && CollectionUtils.isEmpty(this.supportedQueryInstanceTypes) && CollectionUtils.isEmpty(this.supportedDataInstanceTypes) && CollectionUtils.isEmpty(this.supportedDbInstanceTypes) && CollectionUtils.isEmpty(this.druidInstanceTypeConfigurations) && CollectionUtils.isEmpty(this.druidExtensions) && CollectionUtils.isEmpty(this.pivotConfigurations) && CollectionUtils.isEmpty(this.clusterHealthCheckExclusions) && CollectionUtils.isEmpty(this.featureFlags) && CollectionUtils.isEmpty(this.additionalFiles) && CollectionUtils.isEmpty(this.druidConfigurations) && CollectionUtils.isEmpty(this.coldTierClusterSizeDetails) && CollectionUtils.isEmpty(this.druidRoleMappings) && CollectionUtils.isEmpty(this.licenseEntitlements);
    }

    public boolean isReadyToCreateCluster() {
        return !this.getSupportedImplyVersions().isEmpty() && !this.getDruidExtensions().isEmpty() && !this.getDruidConfigurations().isEmpty() && !this.getAdditionalFiles().isEmpty();
    }

    @Generated
    protected RefreshableConstants(Builder<?, ?> b) {
        this.objectMapper = b.objectMapper;
        this.amiForRegion = b.amiForRegion;
        this.supportedImplyVersions = b.supportedImplyVersions;
        this.supportedMasterInstanceTypes = b.supportedMasterInstanceTypes;
        this.supportedQueryInstanceTypes = b.supportedQueryInstanceTypes;
        this.supportedDataInstanceTypes = b.supportedDataInstanceTypes;
        this.supportedDbInstanceTypes = b.supportedDbInstanceTypes;
        this.supportedIngestInstanceTypes = b.supportedIngestInstanceTypes;
        this.druidInstanceTypeConfigurations = b.druidInstanceTypeConfigurations;
        this.druidExtensions = b.druidExtensions;
        this.pivotConfigurations = b.pivotConfigurations;
        this.clusterHealthCheckExclusions = b.clusterHealthCheckExclusions;
        this.featureFlags = b.featureFlags;
        this.additionalFiles = b.additionalFiles;
        this.druidConfigurations = b.druidConfigurations;
        this.coldTierClusterSizeDetails = b.coldTierClusterSizeDetails;
        this.druidRoleMappings = b.druidRoleMappings;
        this.licenseEntitlements = b.licenseEntitlements;
        this.projectSizeMap = b.projectSizeMap;
        this.projectPlans = b.projectPlans;
        this.dataUnitTypeMap = b.dataUnitTypeMap;
        this.masterUnitTypeMap = b.masterUnitTypeMap;
        this.queryUnitTypeMap = b.queryUnitTypeMap;
    }

    @Generated
    public static Builder<?, ?> builder() {
        return new BuilderImpl();
    }

    @Generated
    public Builder<?, ?> toBuilder() {
        return new BuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    RefreshableConstants(ObjectMapper objectMapper, List<AmiRegion> amiForRegion, List<ImplyVersion> supportedImplyVersions, List<InstanceType> supportedMasterInstanceTypes, List<InstanceType> supportedQueryInstanceTypes, List<InstanceType> supportedDataInstanceTypes, List<InstanceType> supportedDbInstanceTypes, List<InstanceType> supportedIngestInstanceTypes, List<DruidInstanceTypeConfig> druidInstanceTypeConfigurations, List<DruidExtensions> druidExtensions, List<PivotConfiguration> pivotConfigurations, List<String> clusterHealthCheckExclusions, List<FeatureFlag> featureFlags, List<AdditionalFiles> additionalFiles, List<DruidConfiguration> druidConfigurations, List<ColdTierClusterSizeDetails> coldTierClusterSizeDetails, List<DruidRoleMapping> druidRoleMappings, List<LicenseEntitlement> licenseEntitlements, Map<String, List<ClusterSizeDetails>> projectSizeMap, List<ProjectPlan> projectPlans, Map<String, List<DataUnitType>> dataUnitTypeMap, Map<String, List<MasterUnitType>> masterUnitTypeMap, Map<String, List<QueryUnitType>> queryUnitTypeMap) {
        this.objectMapper = objectMapper;
        this.amiForRegion = amiForRegion;
        this.supportedImplyVersions = supportedImplyVersions;
        this.supportedMasterInstanceTypes = supportedMasterInstanceTypes;
        this.supportedQueryInstanceTypes = supportedQueryInstanceTypes;
        this.supportedDataInstanceTypes = supportedDataInstanceTypes;
        this.supportedDbInstanceTypes = supportedDbInstanceTypes;
        this.supportedIngestInstanceTypes = supportedIngestInstanceTypes;
        this.druidInstanceTypeConfigurations = druidInstanceTypeConfigurations;
        this.druidExtensions = druidExtensions;
        this.pivotConfigurations = pivotConfigurations;
        this.clusterHealthCheckExclusions = clusterHealthCheckExclusions;
        this.featureFlags = featureFlags;
        this.additionalFiles = additionalFiles;
        this.druidConfigurations = druidConfigurations;
        this.coldTierClusterSizeDetails = coldTierClusterSizeDetails;
        this.druidRoleMappings = druidRoleMappings;
        this.licenseEntitlements = licenseEntitlements;
        this.projectSizeMap = projectSizeMap;
        this.projectPlans = projectPlans;
        this.dataUnitTypeMap = dataUnitTypeMap;
        this.masterUnitTypeMap = masterUnitTypeMap;
        this.queryUnitTypeMap = queryUnitTypeMap;
    }

    protected static class RefreshJob<T> {
        private final String key;
        private final TypeReference<T> typeReference;
        private final Supplier<T> getFn;
        private final Consumer<T> setFn;
        private final String configName;

        public RefreshJob(String key, TypeReference<T> typeReference, Supplier<T> getFn, Consumer<T> setFn, String configName) {
            this.key = key;
            this.typeReference = typeReference;
            this.getFn = getFn;
            this.setFn = setFn;
            this.configName = configName;
        }
    }

    @Generated
    public static abstract class Builder<C extends RefreshableConstants, B extends Builder<C, B>> {
        @Generated
        private ObjectMapper objectMapper;
        @Generated
        private List<AmiRegion> amiForRegion;
        @Generated
        private List<ImplyVersion> supportedImplyVersions;
        @Generated
        private List<InstanceType> supportedMasterInstanceTypes;
        @Generated
        private List<InstanceType> supportedQueryInstanceTypes;
        @Generated
        private List<InstanceType> supportedDataInstanceTypes;
        @Generated
        private List<InstanceType> supportedDbInstanceTypes;
        @Generated
        private List<InstanceType> supportedIngestInstanceTypes;
        @Generated
        private List<DruidInstanceTypeConfig> druidInstanceTypeConfigurations;
        @Generated
        private List<DruidExtensions> druidExtensions;
        @Generated
        private List<PivotConfiguration> pivotConfigurations;
        @Generated
        private List<String> clusterHealthCheckExclusions;
        @Generated
        private List<FeatureFlag> featureFlags;
        @Generated
        private List<AdditionalFiles> additionalFiles;
        @Generated
        private List<DruidConfiguration> druidConfigurations;
        @Generated
        private List<ColdTierClusterSizeDetails> coldTierClusterSizeDetails;
        @Generated
        private List<DruidRoleMapping> druidRoleMappings;
        @Generated
        private List<LicenseEntitlement> licenseEntitlements;
        @Generated
        private Map<String, List<ClusterSizeDetails>> projectSizeMap;
        @Generated
        private List<ProjectPlan> projectPlans;
        @Generated
        private Map<String, List<DataUnitType>> dataUnitTypeMap;
        @Generated
        private Map<String, List<MasterUnitType>> masterUnitTypeMap;
        @Generated
        private Map<String, List<QueryUnitType>> queryUnitTypeMap;

        @Generated
        protected B $fillValuesFrom(C instance) {
            Builder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(RefreshableConstants instance, Builder<?, ?> b) {
            b.objectMapper(instance.objectMapper);
            b.amiForRegion(instance.amiForRegion);
            b.supportedImplyVersions(instance.supportedImplyVersions);
            b.supportedMasterInstanceTypes(instance.supportedMasterInstanceTypes);
            b.supportedQueryInstanceTypes(instance.supportedQueryInstanceTypes);
            b.supportedDataInstanceTypes(instance.supportedDataInstanceTypes);
            b.supportedDbInstanceTypes(instance.supportedDbInstanceTypes);
            b.supportedIngestInstanceTypes(instance.supportedIngestInstanceTypes);
            b.druidInstanceTypeConfigurations(instance.druidInstanceTypeConfigurations);
            b.druidExtensions(instance.druidExtensions);
            b.pivotConfigurations(instance.pivotConfigurations);
            b.clusterHealthCheckExclusions(instance.clusterHealthCheckExclusions);
            b.featureFlags(instance.featureFlags);
            b.additionalFiles(instance.additionalFiles);
            b.druidConfigurations(instance.druidConfigurations);
            b.coldTierClusterSizeDetails(instance.coldTierClusterSizeDetails);
            b.druidRoleMappings(instance.druidRoleMappings);
            b.licenseEntitlements(instance.licenseEntitlements);
            b.projectSizeMap(instance.projectSizeMap);
            b.projectPlans(instance.projectPlans);
            b.dataUnitTypeMap(instance.dataUnitTypeMap);
            b.masterUnitTypeMap(instance.masterUnitTypeMap);
            b.queryUnitTypeMap(instance.queryUnitTypeMap);
        }

        @Generated
        public B objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            return this.self();
        }

        @Generated
        public B amiForRegion(List<AmiRegion> amiForRegion) {
            this.amiForRegion = amiForRegion;
            return this.self();
        }

        @Generated
        public B supportedImplyVersions(List<ImplyVersion> supportedImplyVersions) {
            this.supportedImplyVersions = supportedImplyVersions;
            return this.self();
        }

        @Generated
        public B supportedMasterInstanceTypes(List<InstanceType> supportedMasterInstanceTypes) {
            this.supportedMasterInstanceTypes = supportedMasterInstanceTypes;
            return this.self();
        }

        @Generated
        public B supportedQueryInstanceTypes(List<InstanceType> supportedQueryInstanceTypes) {
            this.supportedQueryInstanceTypes = supportedQueryInstanceTypes;
            return this.self();
        }

        @Generated
        public B supportedDataInstanceTypes(List<InstanceType> supportedDataInstanceTypes) {
            this.supportedDataInstanceTypes = supportedDataInstanceTypes;
            return this.self();
        }

        @Generated
        public B supportedDbInstanceTypes(List<InstanceType> supportedDbInstanceTypes) {
            this.supportedDbInstanceTypes = supportedDbInstanceTypes;
            return this.self();
        }

        @Generated
        public B supportedIngestInstanceTypes(List<InstanceType> supportedIngestInstanceTypes) {
            this.supportedIngestInstanceTypes = supportedIngestInstanceTypes;
            return this.self();
        }

        @Generated
        public B druidInstanceTypeConfigurations(List<DruidInstanceTypeConfig> druidInstanceTypeConfigurations) {
            this.druidInstanceTypeConfigurations = druidInstanceTypeConfigurations;
            return this.self();
        }

        @Generated
        public B druidExtensions(List<DruidExtensions> druidExtensions) {
            this.druidExtensions = druidExtensions;
            return this.self();
        }

        @Generated
        public B pivotConfigurations(List<PivotConfiguration> pivotConfigurations) {
            this.pivotConfigurations = pivotConfigurations;
            return this.self();
        }

        @Generated
        public B clusterHealthCheckExclusions(List<String> clusterHealthCheckExclusions) {
            this.clusterHealthCheckExclusions = clusterHealthCheckExclusions;
            return this.self();
        }

        @Generated
        public B featureFlags(List<FeatureFlag> featureFlags) {
            this.featureFlags = featureFlags;
            return this.self();
        }

        @Generated
        public B additionalFiles(List<AdditionalFiles> additionalFiles) {
            this.additionalFiles = additionalFiles;
            return this.self();
        }

        @Generated
        public B druidConfigurations(List<DruidConfiguration> druidConfigurations) {
            this.druidConfigurations = druidConfigurations;
            return this.self();
        }

        @Generated
        public B coldTierClusterSizeDetails(List<ColdTierClusterSizeDetails> coldTierClusterSizeDetails) {
            this.coldTierClusterSizeDetails = coldTierClusterSizeDetails;
            return this.self();
        }

        @Generated
        public B druidRoleMappings(List<DruidRoleMapping> druidRoleMappings) {
            this.druidRoleMappings = druidRoleMappings;
            return this.self();
        }

        @Generated
        public B licenseEntitlements(List<LicenseEntitlement> licenseEntitlements) {
            this.licenseEntitlements = licenseEntitlements;
            return this.self();
        }

        @Generated
        public B projectSizeMap(Map<String, List<ClusterSizeDetails>> projectSizeMap) {
            this.projectSizeMap = projectSizeMap;
            return this.self();
        }

        @Generated
        public B projectPlans(List<ProjectPlan> projectPlans) {
            this.projectPlans = projectPlans;
            return this.self();
        }

        @Generated
        public B dataUnitTypeMap(Map<String, List<DataUnitType>> dataUnitTypeMap) {
            this.dataUnitTypeMap = dataUnitTypeMap;
            return this.self();
        }

        @Generated
        public B masterUnitTypeMap(Map<String, List<MasterUnitType>> masterUnitTypeMap) {
            this.masterUnitTypeMap = masterUnitTypeMap;
            return this.self();
        }

        @Generated
        public B queryUnitTypeMap(Map<String, List<QueryUnitType>> queryUnitTypeMap) {
            this.queryUnitTypeMap = queryUnitTypeMap;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "RefreshableConstants.Builder(objectMapper=" + String.valueOf(this.objectMapper) + ", amiForRegion=" + String.valueOf(this.amiForRegion) + ", supportedImplyVersions=" + String.valueOf(this.supportedImplyVersions) + ", supportedMasterInstanceTypes=" + String.valueOf(this.supportedMasterInstanceTypes) + ", supportedQueryInstanceTypes=" + String.valueOf(this.supportedQueryInstanceTypes) + ", supportedDataInstanceTypes=" + String.valueOf(this.supportedDataInstanceTypes) + ", supportedDbInstanceTypes=" + String.valueOf(this.supportedDbInstanceTypes) + ", supportedIngestInstanceTypes=" + String.valueOf(this.supportedIngestInstanceTypes) + ", druidInstanceTypeConfigurations=" + String.valueOf(this.druidInstanceTypeConfigurations) + ", druidExtensions=" + String.valueOf(this.druidExtensions) + ", pivotConfigurations=" + String.valueOf(this.pivotConfigurations) + ", clusterHealthCheckExclusions=" + String.valueOf(this.clusterHealthCheckExclusions) + ", featureFlags=" + String.valueOf(this.featureFlags) + ", additionalFiles=" + String.valueOf(this.additionalFiles) + ", druidConfigurations=" + String.valueOf(this.druidConfigurations) + ", coldTierClusterSizeDetails=" + String.valueOf(this.coldTierClusterSizeDetails) + ", druidRoleMappings=" + String.valueOf(this.druidRoleMappings) + ", licenseEntitlements=" + String.valueOf(this.licenseEntitlements) + ", projectSizeMap=" + String.valueOf(this.projectSizeMap) + ", projectPlans=" + String.valueOf(this.projectPlans) + ", dataUnitTypeMap=" + String.valueOf(this.dataUnitTypeMap) + ", masterUnitTypeMap=" + String.valueOf(this.masterUnitTypeMap) + ", queryUnitTypeMap=" + String.valueOf(this.queryUnitTypeMap) + ")";
        }
    }

    @Generated
    private static final class BuilderImpl
    extends Builder<RefreshableConstants, BuilderImpl> {
        @Generated
        private BuilderImpl() {
        }

        @Override
        @Generated
        protected BuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public RefreshableConstants build() {
            return new RefreshableConstants(this);
        }
    }
}

