/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.services;

import com.google.inject.Injector;
import io.airlift.airline.Cli;
import io.airlift.airline.Help;
import io.airlift.airline.ParseException;
import io.imply.cloud.configurator.CliConfigServer;
import io.imply.cloud.guice.GuiceInjectors;
import io.imply.cloud.manager.CliManager;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class Main {
    public static void main(String[] args) {
        LogManager.getLogManager().reset();
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        Logger.getLogger("global").setLevel(Level.FINEST);
        Cli.CliBuilder builder = Cli.builder((String)"imply-cloud");
        builder.withDefaultCommand(Help.class).withCommands(Help.class, new Class[]{CliManager.class, CliConfigServer.class});
        Cli cli = builder.build();
        Runnable command = null;
        try {
            command = (Runnable)cli.parse(args);
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            ((Runnable)cli.parse(new String[]{"help"})).run();
            System.exit(1);
        }
        System.setProperty("application.serviceName", command.getClass().getName());
        Injector injector = GuiceInjectors.makeStartupInjector();
        if (!(command instanceof Help)) {
            injector.injectMembers((Object)command);
        }
        command.run();
    }
}

