/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.configurator.resources;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.configurator.ConfiguratorManager;
import io.imply.cloud.configurator.resources.BaseResource;
import io.imply.cloud.model.ConfigRequestBody;
import io.imply.cloud.model.DruidConfigFile;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.util.Logger;
import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path(value="/config/v1")
public class ConfiguratorResource
extends BaseResource {
    private static final Logger log = new Logger(ConfiguratorResource.class);
    private final ConfiguratorManager configuratorManager;

    @Inject
    public ConfiguratorResource(ConfiguratorManager configuratorManager, ClusterDataManager clusterDataManager, RefreshableConstants refreshableConstants) {
        super(clusterDataManager, refreshableConstants);
        this.configuratorManager = configuratorManager;
    }

    @POST
    @Path(value="config-bundle")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getConfigBundle(ConfigRequestBody body) throws IOException {
        log.info("[getConfigBundle] request with: %s", new Object[]{body});
        this.validateRequest(body, DEFAULT_VALIDATOR);
        return Response.ok((Object)this.configuratorManager.generateDruidConfigBundle(body)).type("application/zip").header("Content-Disposition", (Object)"attachment; filename=\"conf.zip\"").build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="grove-init")
    public Response getGroveInit(ConfigRequestBody body) throws IOException {
        log.info("[getGroveInit] request with: %s", new Object[]{body});
        this.validateRequest(body, DEFAULT_VALIDATOR);
        return Response.ok((Object)this.configuratorManager.generateGroveInit(body)).type(MediaType.TEXT_PLAIN_TYPE).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="user-files-x")
    public Response getExtendedUserFilePaths(ConfigRequestBody body) throws IOException {
        log.info("[getExtendedUserFilePaths] request with: %s", new Object[]{body});
        this.validateRequest(body, DEFAULT_VALIDATOR);
        return Response.ok((Object)this.configuratorManager.generateExtendedUserFilePaths(body)).type(MediaType.TEXT_PLAIN_TYPE).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="pre-init")
    public Response getPreInit(ConfigRequestBody body) throws IOException {
        log.info("[getPreInit] request with: %s", new Object[]{body});
        this.validateRequest(body, DEFAULT_VALIDATOR);
        return Response.ok((Object)this.configuratorManager.generatePreInitScript(this.clusterDataManager.get(body.getClusterId()).getAccountId())).type(MediaType.TEXT_PLAIN_TYPE).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="logview")
    public Response getLogviewConfig(ConfigRequestBody body) throws IOException {
        log.info("[getLogviewConfig] request with: %s", new Object[]{body});
        this.validateRequest(body, DEFAULT_VALIDATOR);
        return Response.ok((Object)this.configuratorManager.generateLogviewConfig(body)).type(MediaType.TEXT_PLAIN_TYPE).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="user-files")
    @Deprecated
    public Response getUserFilePaths(ConfigRequestBody body) throws IOException {
        log.info("[getUserFilePaths] request with: %s", new Object[]{body});
        this.validateRequest(body, DEFAULT_VALIDATOR);
        return Response.ok((Object)this.configuratorManager.generateUserFilePaths(body)).type(MediaType.TEXT_PLAIN_TYPE).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="extension-paths")
    @Deprecated
    public Response getExtensionPaths(ConfigRequestBody body) throws IOException {
        log.info("[getExtensionPaths] request with: %s", new Object[]{body});
        this.validateRequest(body, DEFAULT_VALIDATOR);
        String retVal = String.join((CharSequence)"\n", this.configuratorManager.generateExtensionPaths(body));
        return Response.ok((Object)retVal).type(MediaType.TEXT_PLAIN_TYPE).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="hadoop-dependencies-paths")
    @Deprecated
    public Response getHadoopDependenciesPaths(ConfigRequestBody body) throws IOException {
        log.info("[getHadoopDependenciesPaths] request with: %s", new Object[]{body});
        this.validateRequest(body, DEFAULT_VALIDATOR);
        String retVal = String.join((CharSequence)"\n", this.configuratorManager.generateBaseHadoopDependenciesPaths(body));
        return Response.ok((Object)retVal).type(MediaType.TEXT_PLAIN_TYPE).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="additional-druid-libraries")
    @Deprecated
    public Response getAdditionalDruidLibraries(ConfigRequestBody body) {
        log.info("[getAdditionalDruidLibraries] request with: %s", new Object[]{body});
        this.validateRequest(body, DEFAULT_VALIDATOR);
        return Response.ok((Object)String.join((CharSequence)"\n", (Iterable<? extends CharSequence>)ImmutableList.of((Object)"https://static.imply.io/onprem/sigar-1.6.5.132.jar"))).type(MediaType.TEXT_PLAIN_TYPE).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="peon-configs")
    public Response getPeonConfigs(ConfigRequestBody body) {
        log.info("[getPeonConfigs] request with: %s", new Object[]{body});
        this.validateRequest(body, DEFAULT_VALIDATOR);
        return Response.ok((Object)this.configuratorManager.generateDruidConfigBundle(body, file -> !DruidConfigFile.FileType.PEON_POD_TEMPLATE.equals((Object)file.getFileType()))).type("application/zip").header("Content-Disposition", (Object)"attachment; filename=\"peon.zip\"").build();
    }
}

