/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.configurator.resources;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.imply.cloud.RefreshableConstants;
import io.imply.cloud.exception.AccessDeniedException;
import io.imply.cloud.model.Cluster;
import io.imply.cloud.model.ConfigRequestBody;
import io.imply.cloud.model.InstanceType;
import io.imply.cloud.model.ServiceType;
import io.imply.cloud.persistence.ClusterDataManager;
import io.imply.cloud.util.IAE;
import io.imply.cloud.util.Logger;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BaseResource {
    private static final Logger log = new Logger(BaseResource.class);
    private static final Set<String> SUPPORTED_SERVICE_TYPES = ImmutableSet.of((Object)"master", (Object)"query", (Object)"data", (Object)"ingest", (Object)"coldtierquery", (Object)"coldtierdata", (Object[])new String[0]);
    protected static final Consumer<ConfigRequestBody> DEFAULT_VALIDATOR = x -> {
        if (x.getClusterId() == null || x.getInstanceType() == null || x.getServiceTypes() == null || x.getServiceTypes().isEmpty() || x.getKey() == null) {
            throw new IllegalArgumentException("Fields [clusterId], [instanceType], [serviceType], and [key] required");
        }
    };
    protected final ClusterDataManager clusterDataManager;
    protected final RefreshableConstants refreshableConstants;

    @Inject
    public BaseResource(ClusterDataManager clusterDataManager, RefreshableConstants refreshableConstants) {
        this.clusterDataManager = clusterDataManager;
        this.refreshableConstants = refreshableConstants;
    }

    protected void validateRequest(ConfigRequestBody body, Consumer<ConfigRequestBody> validator) {
        Cluster cluster;
        validator.accept(body);
        if (body.getInstanceType() != null) {
            Set supportedInstanceTypes = Stream.concat(this.refreshableConstants.getSupportedMasterInstanceTypes().stream(), Stream.concat(this.refreshableConstants.getSupportedQueryInstanceTypes().stream(), this.refreshableConstants.getSupportedDataInstanceTypes().stream())).map(InstanceType::getInstanceType).collect(Collectors.toSet());
            if (!("onprem".equals(body.getInstanceType().toLowerCase()) || body.getServiceTypes().contains(ServiceType.MIDDLE_MANAGER.getName()) || supportedInstanceTypes.contains(body.getInstanceType().toLowerCase()))) {
                log.warn("Received instanceType [%s], was expecting one of %s", new Object[]{body.getInstanceType(), supportedInstanceTypes});
                throw new IAE("[instanceType] must be one of %s", new Object[]{supportedInstanceTypes});
            }
        }
        if (body.getServiceTypes() != null) {
            body.getServiceTypes().forEach(x -> {
                if (!SUPPORTED_SERVICE_TYPES.contains(x.toLowerCase())) {
                    log.warn("Received serviceType [%s], expecting one of %s", new Object[]{x, SUPPORTED_SERVICE_TYPES});
                    throw new IAE("[serviceType] must be one of %s", new Object[]{SUPPORTED_SERVICE_TYPES});
                }
            });
        }
        if ((cluster = this.clusterDataManager.getOrNull(body.getClusterId())) == null || !cluster.getConfigServerKey().equals(body.getKey())) {
            throw new AccessDeniedException();
        }
    }
}

