/*
 * Decompiled with CFR 0.152.
 */
package io.imply.telemetry;

import io.imply.telemetry.Event;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class MetricEvent
implements Event {
    static final String DEFAULT_FEED = "metrics";
    private final Instant time;
    private final String feed;
    private final String metric;
    private final Number value;
    private final Map<String, Object> attributes;

    private MetricEvent(Instant time, String feed, String metric, Number value, Map<String, Object> attributes) {
        this.time = Objects.requireNonNull(time, "time cannot be null");
        this.feed = Objects.requireNonNull(feed, "feed cannot be null");
        this.metric = Objects.requireNonNull(metric, "metric cannot be null");
        this.value = Objects.requireNonNull(value, "value cannot be null");
        this.attributes = Objects.requireNonNull(attributes, "attributes cannot be null");
    }

    public static Builder builder(String metric) {
        return MetricEvent.builder(metric, 1);
    }

    public static Builder builder(String metric, Number value) {
        return new Builder(metric, value);
    }

    public Instant getTime() {
        return this.time;
    }

    @Override
    public String getFeed() {
        return this.feed;
    }

    public String getMetric() {
        return this.metric;
    }

    public Number getValue() {
        return this.value;
    }

    public Map<String, Object> getAttributes() {
        return new HashMap<String, Object>(this.attributes);
    }

    @Override
    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(this.attributes);
        map.put("metric", this.metric);
        map.put("value", this.value);
        map.put("timestamp", this.time.toString());
        return map;
    }

    public String toString() {
        return "MetricEvent{metric='" + this.metric + '\'' + ", value=" + this.value + ", time=" + this.time + ", feed='" + this.feed + '\'' + ", attributes=" + this.attributes + '}';
    }

    public static class Builder {
        private Instant time = Instant.now();
        private String feed = "metrics";
        private String metric;
        private Number value;
        private Map<String, Object> attributes = new HashMap<String, Object>();

        private Builder(String metric, Number value) {
            this.metric = metric;
            this.value = value;
        }

        public Builder time(Instant time) {
            this.time = time;
            return this;
        }

        public Builder feed(String feed) {
            this.feed = feed;
            return this;
        }

        public Builder metric(String metric) {
            this.metric = metric;
            return this;
        }

        public Builder value(Number value) {
            this.value = value;
            return this;
        }

        public <K, V> Builder attributes(Map<K, V> attributes) {
            this.attributes = attributes.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), Map.Entry::getValue));
            return this;
        }

        public Builder addAttribute(Object name, Object value) {
            this.attributes.put(name.toString(), value);
            return this;
        }

        public MetricEvent build() {
            return new MetricEvent(this.time, this.feed, this.metric, this.value, this.attributes);
        }
    }
}

