/*
 * Decompiled with CFR 0.152.
 */
package io.imply.telemetry;

import io.imply.telemetry.MetricEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public interface Event {
    public static String name(String name, String ... names) {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(Objects.requireNonNull(name, "name cannot be null"));
        parts.addAll(Arrays.asList(names));
        return parts.stream().filter(Objects::nonNull).filter(s -> !s.isEmpty()).collect(Collectors.joining("."));
    }

    public static String name(Class<?> clazz, String ... names) {
        return Event.name(clazz.getName(), names);
    }

    public static Event metric(String metric) {
        return MetricEvent.builder(metric).build();
    }

    public static Event metric(String metric, Number value) {
        return MetricEvent.builder(metric, value).build();
    }

    public static <K, V> Event metric(String metric, Number value, Map<K, V> attributes) {
        return MetricEvent.builder(metric, value).attributes(attributes).build();
    }

    public static Event metric(String metric, Number value, Object k1, Object v1) {
        return MetricEvent.builder(metric, value).addAttribute(k1, v1).build();
    }

    public static Event metric(String metric, Number value, Object k1, Object v1, Object k2, Object v2) {
        return MetricEvent.builder(metric, value).addAttribute(k1, v1).addAttribute(k2, v2).build();
    }

    public static Event metric(String metric, Number value, Object k1, Object v1, Object k2, Object v2, Object k3, Object v3) {
        return MetricEvent.builder(metric, value).addAttribute(k1, v1).addAttribute(k2, v2).addAttribute(k3, v3).build();
    }

    public static Event metric(String metric, Number value, Object k1, Object v1, Object k2, Object v2, Object k3, Object v3, Object k4, Object v4) {
        return MetricEvent.builder(metric, value).addAttribute(k1, v1).addAttribute(k2, v2).addAttribute(k3, v3).addAttribute(k4, v4).build();
    }

    public static Event metric(String metric, Number value, Object k1, Object v1, Object k2, Object v2, Object k3, Object v3, Object k4, Object v4, Object k5, Object v5) {
        return MetricEvent.builder(metric, value).addAttribute(k1, v1).addAttribute(k2, v2).addAttribute(k3, v3).addAttribute(k4, v4).addAttribute(k5, v5).build();
    }

    public static <K, V> Event metric(String metric, Map<K, V> attributes) {
        return MetricEvent.builder(metric).attributes(attributes).build();
    }

    public static Event metric(String metric, Object k1, Object v1) {
        return MetricEvent.builder(metric).addAttribute(k1, v1).build();
    }

    public static Event metric(String metric, Object k1, Object v1, Object k2, Object v2) {
        return MetricEvent.builder(metric).addAttribute(k1, v1).addAttribute(k2, v2).build();
    }

    public static Event metric(String metric, Object k1, Object v1, Object k2, Object v2, Object k3, Object v3) {
        return MetricEvent.builder(metric).addAttribute(k1, v1).addAttribute(k2, v2).addAttribute(k3, v3).build();
    }

    public static Event metric(String metric, Object k1, Object v1, Object k2, Object v2, Object k3, Object v3, Object k4, Object v4) {
        return MetricEvent.builder(metric).addAttribute(k1, v1).addAttribute(k2, v2).addAttribute(k3, v3).addAttribute(k4, v4).build();
    }

    public static Event metric(String metric, Object k1, Object v1, Object k2, Object v2, Object k3, Object v3, Object k4, Object v4, Object k5, Object v5) {
        return MetricEvent.builder(metric).addAttribute(k1, v1).addAttribute(k2, v2).addAttribute(k3, v3).addAttribute(k4, v4).addAttribute(k5, v5).build();
    }

    public Map<String, Object> toMap();

    public String getFeed();
}

