/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.util;

import com.google.common.collect.ImmutableSet;
import io.imply.cloud.model.State;
import io.imply.cloud.util.ISE;
import io.imply.cloud.util.Logger;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

public class StateValidator {
    private static final Logger log = new Logger(StateValidator.class);
    private static ImmutableSet<State> exemptedStates = ImmutableSet.of((Object)State.UNKNOWN, (Object)State.CLEAR_FIELD);

    static {
        Set externalStates = Arrays.stream(State.values()).filter(x -> x.isExternalState() && !State.UNKNOWN.equals(x)).collect(Collectors.toSet());
        log.debug("External state mappings: (valid external states: %s", new Object[]{externalStates});
        for (State state : State.values()) {
            State externalState = state.getExternalState(State.ACCOUNT_CREATED);
            if (exemptedStates.contains((Object)state)) continue;
            log.debug("  [%s] -> [%s]", new Object[]{state, externalState});
            if (externalStates.contains(externalState)) continue;
            throw new ISE("State [%s] is not mapped to a valid external state", new Object[]{state});
        }
    }
}

