/*
 * Decompiled with CFR 0.152.
 */
package io.imply.cloud.manager.util;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.imply.cloud.manager.ManagerConfig;
import io.imply.cloud.manager.ManagerLeader;
import io.imply.cloud.manager.ManagerToolbox;
import io.imply.cloud.util.Logger;
import java.net.URI;
import java.util.Enumeration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.http.HttpField;

public class ManagerLeaderProxy {
    private static final Logger log = new Logger(ManagerLeaderProxy.class);
    private final ManagerToolbox toolbox;
    private final ManagerLeader managerLeader;
    private final ManagerConfig config;

    @Inject
    public ManagerLeaderProxy(ManagerToolbox toolbox, ManagerLeader managerLeader) {
        this.toolbox = toolbox;
        this.managerLeader = managerLeader;
        this.config = toolbox.getManagerConfig();
    }

    public Response proxyRequest(HttpServletRequest request, byte[] data) throws Exception {
        ContentResponse proxiedResponse;
        log.debug("Proxying request to leader [%s]", new Object[]{this.managerLeader.getCurrentLeader()});
        String scheme = request.getScheme();
        String pathInfo = request.getPathInfo();
        String queryString = request.getQueryString();
        String contentType = request.getContentType();
        String method = request.getMethod();
        URI uri = new URI(scheme, this.managerLeader.getCurrentLeader(), pathInfo, queryString, null);
        Request proxiedRequest = this.toolbox.getHttpClient(true).newRequest(uri).method(method).content((ContentProvider)new BytesContentProvider((byte[][])new byte[][]{data}), contentType).timeout(this.config.getProxyTimeout().toStandardDuration().getStandardSeconds(), TimeUnit.SECONDS);
        log.debug("Initial Content-Type header %s", new Object[]{proxiedRequest.getHeaders().getValuesList("Content-Type").toString()});
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            if (ImmutableSet.of((Object)"te", (Object)"transfer-encoding", (Object)"keep-alive", (Object)"proxy-authorization", (Object)"proxy-authentication", (Object)"trailer", (Object[])new String[]{"upgrade", "content-type", "connection"}).contains((Object)headerName.toLowerCase())) continue;
            Enumeration headerValues = request.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                proxiedRequest.header(headerName, (String)headerValues.nextElement());
            }
        }
        log.debug("Final Content-Type header %s", new Object[]{proxiedRequest.getHeaders().getValuesList("Content-Type").toString()});
        try {
            proxiedResponse = proxiedRequest.send();
        }
        catch (TimeoutException e) {
            return Response.status((int)504).header("Via", (Object)"1.1 Imply-Cloud").build();
        }
        Response.ResponseBuilder responseBuilder = Response.status((int)proxiedResponse.getStatus()).entity((Object)proxiedResponse.getContent());
        responseBuilder.header("Via", (Object)"1.1 Imply-Cloud");
        if (proxiedResponse.getHeaders() != null) {
            for (HttpField field : proxiedResponse.getHeaders()) {
                if ("Date".equals(field.getName())) continue;
                responseBuilder.header(field.getName(), (Object)field.getValue());
            }
        }
        return responseBuilder.type(proxiedResponse.getMediaType()).build();
    }
}

